/*
 * Decompiled with CFR 0.152.
 */
package org.kolobok.annotation.processor;

import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.kolobok.annotation.BuildNumber;
import org.kolobok.annotation.processor.RepoMethodUtil;

@SupportedAnnotationTypes(value={"org.kolobok.annotation.BuildNumber"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class BuildNumberAnnotationProcessor
extends AbstractProcessor {
    public static final String ANNOTATION_TYPE = "org.kolobok.annotation.BuildNumber";
    private JavacProcessingEnvironment javacProcessingEnv;
    private TreeMaker maker;
    private Context context;
    private RepoMethodUtil repoMethodUtil;

    @Override
    public void init(ProcessingEnvironment procEnv) {
        super.init(procEnv);
        this.javacProcessingEnv = (JavacProcessingEnvironment)procEnv;
        this.maker = TreeMaker.instance(this.javacProcessingEnv.getContext());
        this.context = ((JavacProcessingEnvironment)this.processingEnv).getContext();
        this.repoMethodUtil = new RepoMethodUtil();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (annotations == null || annotations.isEmpty()) {
            return false;
        }
        JavacElements utils = this.javacProcessingEnv.getElementUtils();
        boolean hasError = false;
        for (TypeElement typeElement : annotations) {
            if (!ANNOTATION_TYPE.equals(typeElement.asType().toString())) continue;
            Set<? extends Element> fields = roundEnv.getElementsAnnotatedWith(typeElement);
            for (Element element : fields) {
                BuildNumber ba = element.getAnnotation(BuildNumber.class);
                JCTree fieldTree = utils.getTree(element);
                if (fieldTree instanceof JCTree.JCVariableDecl) {
                    JCTree.JCVariableDecl variableDecl = (JCTree.JCVariableDecl)fieldTree;
                    String value = null;
                    try {
                        URL url = new URL(ba.url());
                        HttpURLConnection httpCon = (HttpURLConnection)url.openConnection();
                        httpCon.setDoOutput(true);
                        httpCon.setConnectTimeout(ba.timeout());
                        httpCon.setReadTimeout(ba.timeout());
                        httpCon.setRequestMethod(ba.method());
                        try (OutputStreamWriter out = new OutputStreamWriter(httpCon.getOutputStream());){
                            out.write("");
                        }
                        var17_18 = null;
                        try (InputStream is = httpCon.getInputStream();){
                            byte[] buf = new byte[1000];
                            int count = is.read(buf);
                            value = new String(buf, 0, count);
                        }
                        catch (Throwable throwable) {
                            var17_18 = throwable;
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        if (ba.defaultValue() == null || ba.defaultValue().isEmpty()) {
                            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Error getting build number from URL '%s'\n%s", ba.url(), e.getLocalizedMessage()));
                            hasError = true;
                        }
                        value = ba.defaultValue();
                    }
                    if (hasError) continue;
                    String varTypeName = String.valueOf(variableDecl.getType().type);
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "varTypeName = " + varTypeName + " value = " + value);
                    if (varTypeName.equals(Long.class.getName()) || varTypeName.equals(Long.TYPE.getName())) {
                        variableDecl.init = this.maker.Literal(Long.valueOf(value));
                        continue;
                    }
                    if (varTypeName.equals(Integer.class.getName()) || varTypeName.equals(Integer.TYPE.getName())) {
                        variableDecl.init = this.maker.Literal(Integer.valueOf(value));
                        continue;
                    }
                    variableDecl.init = this.maker.Literal(value);
                    continue;
                }
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Unknown '%s' is marked with @BuildNumber annotation.", fields, ANNOTATION_TYPE));
            }
        }
        return hasError;
    }
}

