/*
 * Decompiled with CFR 0.152.
 */
package org.kolobok.annotation.processor;

import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.kolobok.annotation.processor.RepoMethodUtil;

@SupportedAnnotationTypes(value={"org.kolobok.annotation.CompileTime"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class CompileTimeAnnotationProcessor
extends AbstractProcessor {
    public static final String ANNOTATION_TYPE = "org.kolobok.annotation.CompileTime";
    private JavacProcessingEnvironment javacProcessingEnv;
    private TreeMaker maker;
    private Context context;
    private RepoMethodUtil repoMethodUtil;

    @Override
    public void init(ProcessingEnvironment procEnv) {
        super.init(procEnv);
        this.javacProcessingEnv = (JavacProcessingEnvironment)procEnv;
        this.maker = TreeMaker.instance(this.javacProcessingEnv.getContext());
        this.context = ((JavacProcessingEnvironment)this.processingEnv).getContext();
        this.repoMethodUtil = new RepoMethodUtil();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (annotations == null || annotations.isEmpty()) {
            return false;
        }
        JavacElements utils = this.javacProcessingEnv.getElementUtils();
        for (TypeElement typeElement : annotations) {
            if (!ANNOTATION_TYPE.equals(typeElement.asType().toString())) continue;
            Set<? extends Element> fields = roundEnv.getElementsAnnotatedWith(typeElement);
            for (Element element : fields) {
                JCTree fieldTree = utils.getTree(element);
                if (fieldTree instanceof JCTree.JCVariableDecl) {
                    JCTree.JCVariableDecl variableDecl = (JCTree.JCVariableDecl)fieldTree;
                    variableDecl.init = this.maker.Literal(System.currentTimeMillis());
                    continue;
                }
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Unknown '%s' is marked with @CompileTime annotation.", fields, ANNOTATION_TYPE));
            }
        }
        return false;
    }
}

