/*
 * Decompiled with CFR 0.152.
 */
package org.kolobok.annotation.processor;

import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.kolobok.annotation.processor.RepoMethod;
import org.kolobok.annotation.processor.RepoMethodUtil;

@SupportedAnnotationTypes(value={"org.kolobok.annotation.FindWithOptionalParams"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class FindWithOptionalParamsAnnotationProcessor
extends AbstractProcessor {
    public static final String ANNOTATION_TYPE = "org.kolobok.annotation.FindWithOptionalParams";
    public static final String LAST_DOUBLE_PARAM_NAME = "__last___param___";
    private JavacProcessingEnvironment javacProcessingEnv;
    private TreeMaker maker;
    private Context context;
    private RepoMethodUtil repoMethodUtil;

    @Override
    public void init(ProcessingEnvironment procEnv) {
        super.init(procEnv);
        this.javacProcessingEnv = (JavacProcessingEnvironment)procEnv;
        this.maker = TreeMaker.instance(this.javacProcessingEnv.getContext());
        this.context = ((JavacProcessingEnvironment)this.processingEnv).getContext();
        this.repoMethodUtil = new RepoMethodUtil();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (annotations == null || annotations.isEmpty()) {
            return false;
        }
        JavacElements utils = this.javacProcessingEnv.getElementUtils();
        ArrayList<Element> methodsToProcess = new ArrayList<Element>();
        boolean hasErrors = false;
        for (TypeElement typeElement : annotations) {
            if (!ANNOTATION_TYPE.equals(typeElement.asType().toString())) continue;
            Set<? extends Element> methods = roundEnv.getElementsAnnotatedWith(typeElement);
            for (Element element : methods) {
                if (element.getEnclosingElement().getKind() != ElementKind.INTERFACE) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Method '%s' in '%s' cannot be annotated with @%s  because '%s' is not interface ", element, element.getEnclosingElement(), ANNOTATION_TYPE, element.getEnclosingElement()));
                    hasErrors = true;
                }
                if (element.getModifiers().contains((Object)Modifier.DEFAULT)) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Method '%s' in '%' cannot be annotated with @%s because it has default implementation.", element, element.getEnclosingElement(), ANNOTATION_TYPE));
                    hasErrors = true;
                }
                JCTree methodTree = utils.getTree(element);
                JCTree.JCMethodDecl methodDecl = (JCTree.JCMethodDecl)methodTree;
                String returnTypeName = String.valueOf(methodDecl.getReturnType().type);
                RepoMethod repoMethod = this.repoMethodUtil.parseMethodName(methodDecl.name.toString());
                if (repoMethod.getType() == RepoMethod.Type.FIND && !returnTypeName.startsWith("java.lang.Iterable") && !returnTypeName.startsWith("org.springframework.data.domain.Page")) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Find method '%s' in '%s' should return either 'org.springframework.data.domain.Page' or 'java.lang.Iterable<?>' but it returns '%s'.", element, element.getEnclosingElement(), returnTypeName));
                    hasErrors = true;
                } else if (repoMethod.getType() == RepoMethod.Type.COUNT && !returnTypeName.startsWith("java.lang.Long") && !returnTypeName.startsWith("long")) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Count method '%s' in '%s' should return either 'java.lang.Long' or 'long' but it returns '%s'.", element, element.getEnclosingElement(), returnTypeName));
                    hasErrors = true;
                }
                methodsToProcess.add(element);
            }
        }
        if (!hasErrors) {
            JCTree.JCModifiers modifiers = this.maker.Modifiers(1L);
            HashSet<String> hashSet = new HashSet<String>();
            for (Element method : methodsToProcess) {
                Element element = method.getEnclosingElement();
                JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)utils.getTree(element);
                for (JCTree member : classDecl.getMembers()) {
                    if (!(member instanceof JCTree.JCMethodDecl)) continue;
                    JCTree.JCMethodDecl methodDecl = (JCTree.JCMethodDecl)member;
                    String signature = this.generateSignature(methodDecl);
                    hashSet.add(signature);
                }
                JCTree methodTree = utils.getTree(method);
                JCTree.JCMethodDecl methodDecl = (JCTree.JCMethodDecl)methodTree;
                List<JCTree.JCVariableDecl> params = methodDecl.params;
                RepoMethod repoMethod = this.repoMethodUtil.parseMethodName(methodDecl.name.toString());
                JCTree.JCIf ifSt = this.generateIf(repoMethod, params, 0, repoMethod.getType().getGeneratedMethodPrefix(), new ArrayList<JCTree.JCVariableDecl>());
                List<JCTree.JCStatement> statements = List.from(new JCTree.JCStatement[]{ifSt});
                methodDecl.body = this.maker.Block(0L, statements);
                methodDecl.mods.flags |= 0x80000000000L;
                int pow2 = 1 << repoMethod.getParts().length;
                for (int i = 1; i < pow2; ++i) {
                    JCTree.JCMethodDecl newMethodDecl;
                    String signature;
                    int roll = i;
                    int idx = 0;
                    ArrayList<RepoMethod.Part> newParts = new ArrayList<RepoMethod.Part>();
                    ArrayList<JCTree.JCVariableDecl> newParams = new ArrayList<JCTree.JCVariableDecl>();
                    while (roll != 0) {
                        if ((roll & 1) != 0) {
                            newParts.add(repoMethod.getParts()[idx]);
                            JCTree.JCVariableDecl param = params.get(idx);
                            newParams.add(param);
                        }
                        roll >>= 1;
                        ++idx;
                    }
                    if (i == pow2 - 1 && repoMethod.getType() == RepoMethod.Type.COUNT) {
                        JCTree.JCVariableDecl lastParam = (JCTree.JCVariableDecl)newParams.get(newParams.size() - 1);
                        Name name = this.getName(LAST_DOUBLE_PARAM_NAME);
                        JCTree.JCVariableDecl lp = this.maker.Param(name, lastParam.getType().type, lastParam.sym);
                        newParams.add(lp);
                        newParts.add((RepoMethod.Part)newParts.get(newParts.size() - 1));
                    }
                    for (int j = repoMethod.getParts().length; j < params.length(); ++j) {
                        newParams.add(params.get(j));
                    }
                    List<JCTree.JCVariableDecl> newParameters = List.from(newParams);
                    String newMethodName = this.repoMethodUtil.generateMethodName(newParts);
                    if (repoMethod.getType() == RepoMethod.Type.COUNT) {
                        newMethodName = repoMethod.getType().getDefaultPrefix() + this.repoMethodUtil.firstLetterToUpperCase(newMethodName);
                    }
                    if (hashSet.contains(signature = this.generateSignature(newMethodDecl = this.maker.MethodDef(modifiers, this.getName(newMethodName), methodDecl.restype, methodDecl.typarams, newParameters, methodDecl.thrown, null, null)))) continue;
                    hashSet.add(signature);
                    classDecl.defs = classDecl.defs.append(newMethodDecl);
                }
            }
        }
        return hasErrors;
    }

    private String generateSignature(JCTree.JCMethodDecl method) {
        return method.name + "(" + method.params.stream().map(p -> p.getType().toString()).collect(Collectors.joining(",")) + ")";
    }

    private JCTree.JCIf generateIf(RepoMethod repoMethod, List<JCTree.JCVariableDecl> params, int idx, String methodPrefix, java.util.List<JCTree.JCVariableDecl> paramsToCall) {
        JCTree.JCStatement nonNullSt;
        JCTree.JCStatement nullSt;
        methodPrefix = this.repoMethodUtil.firstLetterToLowerCase(methodPrefix);
        JCTree.JCLiteral nil = this.maker.Literal(TypeTag.BOT, null);
        ArrayList<JCTree.JCVariableDecl> newParamsToCall = new ArrayList<JCTree.JCVariableDecl>(paramsToCall);
        newParamsToCall.add(params.get(idx));
        RepoMethod.Part part = repoMethod.getParts()[idx];
        if (idx >= repoMethod.getParts().length - 1) {
            String newMethodName;
            String findAll = repoMethod.getType() == RepoMethod.Type.FIND ? "findAll" : "count";
            JCTree.JCIdent funcNullName = this.maker.Ident(this.getName(paramsToCall.isEmpty() ? findAll : methodPrefix));
            String string = newMethodName = paramsToCall.isEmpty() ? this.repoMethodUtil.firstLetterToLowerCase(methodPrefix + this.repoMethodUtil.firstLetterToUpperCase(part.getFullExpression())) : methodPrefix + (Object)((Object)part.getPreOperation()) + this.repoMethodUtil.firstLetterToUpperCase(part.getFullExpression());
            if (repoMethod.getType() == RepoMethod.Type.COUNT && newParamsToCall.size() == params.size()) {
                newParamsToCall.add(params.get(idx));
                newMethodName = newMethodName + (Object)((Object)(part.getPreOperation() == null ? RepoMethod.Operation.And : part.getPreOperation())) + this.repoMethodUtil.firstLetterToUpperCase(part.getFullExpression());
            }
            JCTree.JCIdent funcNonNullName = this.maker.Ident(this.getName(newMethodName));
            ArrayList<JCTree.JCVariableDecl> nullParamsToCall = new ArrayList<JCTree.JCVariableDecl>(paramsToCall);
            for (int j = repoMethod.getParts().length; j < params.size(); ++j) {
                nullParamsToCall.add(params.get(j));
                newParamsToCall.add(params.get(j));
            }
            nullSt = this.maker.Return(this.maker.Apply(List.nil(), funcNullName, List.from(nullParamsToCall.stream().map(decl -> this.maker.Ident(this.getName("" + decl.getName()))).toArray(JCTree.JCExpression[]::new))));
            java.util.List lst = newParamsToCall.stream().map(decl -> this.maker.Ident(this.getName("" + decl.getName()))).collect(Collectors.toList());
            List<JCTree.JCExpression> newP = List.from(lst);
            nonNullSt = this.maker.Return(this.maker.Apply(List.nil(), funcNonNullName, newP));
        } else {
            nullSt = this.generateIf(repoMethod, params, idx + 1, methodPrefix, paramsToCall);
            String newMethodName = paramsToCall.isEmpty() ? methodPrefix + this.repoMethodUtil.firstLetterToUpperCase(part.getFullExpression()) : methodPrefix + (Object)((Object)part.getPreOperation()) + this.repoMethodUtil.firstLetterToUpperCase(part.getFullExpression());
            newMethodName = this.repoMethodUtil.firstLetterToLowerCase(newMethodName);
            nonNullSt = this.generateIf(repoMethod, params, idx + 1, newMethodName, newParamsToCall);
        }
        JCTree.JCIf res = this.maker.If(this.maker.Binary(JCTree.Tag.EQ, this.maker.Ident(params.get((int)idx).name), nil), nullSt, nonNullSt);
        return res;
    }

    private Name getName(String s) {
        return Names.instance(this.context).fromString(s);
    }
}

