/*
 * Decompiled with CFR 0.152.
 */
package org.kolobok.annotation.processor;

import java.util.Arrays;
import java.util.Objects;

public class RepoMethod {
    private Type type;
    private Part[] parts;

    public RepoMethod() {
    }

    public RepoMethod(Type type, Part[] parts) {
        this.type = type;
        this.parts = parts;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Part[] getParts() {
        return this.parts;
    }

    public void setParts(Part[] parts) {
        this.parts = parts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepoMethod that = (RepoMethod)o;
        return this.type == that.type && Arrays.equals(this.parts, that.parts);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.type});
        result = 31 * result + Arrays.hashCode(this.parts);
        return result;
    }

    public String toString() {
        return "RepoMethod{type=" + (Object)((Object)this.type) + ", parts=" + Arrays.toString(this.parts) + '}';
    }

    public static class Part {
        private Operation preOperation;
        private String fullExpression;

        public Part(Operation preOperation, String fullExpression) {
            this.preOperation = preOperation;
            this.fullExpression = fullExpression;
        }

        public Part(String fullExpression) {
            this.fullExpression = fullExpression;
        }

        public Operation getPreOperation() {
            return this.preOperation;
        }

        public String getFullExpression() {
            return this.fullExpression;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Part part = (Part)o;
            return this.preOperation == part.preOperation && Objects.equals(this.fullExpression, part.fullExpression);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.preOperation, this.fullExpression});
        }

        public String toString() {
            return "Part{preOperation=" + (Object)((Object)this.preOperation) + ", fullExpression='" + this.fullExpression + '\'' + '}';
        }
    }

    public static enum Operation {
        Or,
        And;

    }

    public static enum Type {
        COUNT("countBy"),
        FIND("findBy", "");

        private final String[] prefixes;

        private Type(String ... prefixes) {
            this.prefixes = prefixes;
        }

        public String getDefaultPrefix() {
            return this.prefixes[0];
        }

        public String getGeneratedMethodPrefix() {
            return this.prefixes[this.prefixes.length - 1];
        }

        public String[] getPrefixes() {
            return this.prefixes;
        }
    }
}

