/*
 * Decompiled with CFR 0.152.
 */
package org.kolobok.annotation.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kolobok.annotation.processor.RepoMethod;

public class RepoMethodUtil {
    public static final String SEPARATOR_REGEXP = "(" + (Object)((Object)RepoMethod.Operation.And) + "|" + (Object)((Object)RepoMethod.Operation.Or) + ")";
    public static final Pattern SEPARATOR_PATTERN = Pattern.compile(SEPARATOR_REGEXP);

    public RepoMethod parseMethodName(String methodName) {
        RepoMethod.Type type = null;
        ArrayList<RepoMethod.Part> parts = new ArrayList<RepoMethod.Part>();
        int idx = 0;
        block0: for (RepoMethod.Type t : RepoMethod.Type.values()) {
            for (String prefix : t.getPrefixes()) {
                if (!methodName.startsWith(prefix)) continue;
                if (!prefix.isEmpty()) {
                    if (!this.isFirstUpperSymbolOfProperty(methodName.charAt(prefix.length()))) continue;
                    type = t;
                    idx = prefix.length();
                    break block0;
                }
                type = t;
                idx = prefix.length();
                break block0;
            }
        }
        String postFix = methodName.substring(idx, idx + 1).toLowerCase() + methodName.substring(idx + 1);
        idx = 0;
        Matcher m = SEPARATOR_PATTERN.matcher(postFix);
        RepoMethod.Operation op = null;
        while (m.find()) {
            char postC;
            int end;
            int start = m.start();
            if (start <= 0 || (end = m.end()) >= postFix.length() || Character.toUpperCase(postC = postFix.charAt(end)) != postC) continue;
            String fieldName = postFix.substring(idx, idx + 1).toLowerCase() + postFix.substring(idx + 1, start);
            parts.add(new RepoMethod.Part(op, fieldName));
            op = RepoMethod.Operation.valueOf(m.group());
            idx = end;
        }
        String fieldName = postFix.substring(idx, idx + 1).toLowerCase() + postFix.substring(idx + 1, postFix.length());
        parts.add(new RepoMethod.Part(op, fieldName));
        return new RepoMethod(type, parts.toArray(new RepoMethod.Part[parts.size()]));
    }

    private boolean isFirstUpperSymbolOfProperty(char c) {
        return c == Character.toUpperCase(c);
    }

    public String generateMethodName(List<RepoMethod.Part> newParts) {
        StringBuilder sb = new StringBuilder();
        for (RepoMethod.Part newPart : newParts) {
            if (sb.length() > 0) {
                sb.append((Object)(newPart.getPreOperation() == null ? RepoMethod.Operation.And : newPart.getPreOperation()));
                sb.append(this.firstLetterToUpperCase(newPart.getFullExpression()));
                continue;
            }
            sb.append(this.firstLetterToLowerCase(newPart.getFullExpression()));
        }
        return sb.toString();
    }

    public String firstLetterToLowerCase(String s) {
        return s.length() == 0 ? s : s.substring(0, 1).toLowerCase() + s.substring(1);
    }

    public String firstLetterToUpperCase(String s) {
        return s.length() == 0 ? s : s.substring(0, 1).toUpperCase() + s.substring(1);
    }
}

