/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptmavenplugin.encrypt;

import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.properties.EncryptableProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionService {
    private static final Pattern ENCRYPTED_PATTERN = Pattern.compile("ENC\\((.*?)\\)", 32);
    private static final Pattern DECRYPTED_PATTERN = Pattern.compile("DEC\\((.*?)\\)", 32);
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptionService.class);
    private final StringEncryptor encryptor;

    public EncryptionService(StringEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    private static String replaceAll(String templateText, Pattern pattern, Function<String, String> replacer) {
        Matcher matcher = pattern.matcher(templateText);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String replace = replacer.apply(matcher.group(1));
            matcher.appendReplacement(result, "");
            result.append(replace);
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private String run(String contents, Pattern pattern, String prefix, String mutationName, Function<String, String> mutator) {
        return EncryptionService.replaceAll(contents, pattern, matched -> {
            String mutatedValue = prefix + "(" + (String)mutator.apply((String)matched) + ")";
            LOGGER.debug("{} value {} to {}", new Object[]{mutationName, matched, mutatedValue});
            return mutatedValue;
        });
    }

    public String decrypt(String input) {
        return this.run(input, ENCRYPTED_PATTERN, "DEC", "Decrypted", arg_0 -> ((StringEncryptor)this.encryptor).decrypt(arg_0));
    }

    public String encrypt(String input) {
        return this.run(input, DECRYPTED_PATTERN, "ENC", "Encrypted", arg_0 -> ((StringEncryptor)this.encryptor).encrypt(arg_0));
    }

    public EncryptableProperties getEncryptableProperties() {
        return new EncryptableProperties(this.encryptor);
    }
}

