/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptmavenplugin.mojo;

import com.ulisesbocchio.jasyptmavenplugin.encrypt.EncryptionService;
import com.ulisesbocchio.jasyptmavenplugin.mojo.Application;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;
import org.jasypt.encryption.StringEncryptor;
import org.springframework.boot.Banner;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;

public abstract class AbstractJasyptMojo
extends AbstractMojo {
    @Parameter(property="jasypt.plugin.path", defaultValue="file:src/main/resources/application.properties")
    private String path = "file:src/main/resources/application.properties";

    public void execute() throws MojoExecutionException {
        ConfigurableApplicationContext context = new SpringApplicationBuilder(new Class[0]).sources(new Class[]{Application.class}).bannerMode(Banner.Mode.OFF).run(new String[0]);
        StringEncryptor encryptor = (StringEncryptor)context.getBean(StringEncryptor.class);
        this.run(new EncryptionService(encryptor), this.getFullFilePath((ApplicationContext)context));
    }

    abstract void run(EncryptionService var1, Path var2) throws MojoExecutionException;

    private Path getFullFilePath(ApplicationContext context) throws MojoExecutionException {
        String fullPath = this.path;
        Environment env = context.getEnvironment();
        String[] activeProfiles = env.getActiveProfiles();
        if (activeProfiles.length > 0) {
            String extension = FileUtils.getExtension((String)fullPath);
            String pathWithoutExtension = FileUtils.removeExtension((String)fullPath);
            fullPath = pathWithoutExtension + "-" + activeProfiles[0];
            if (!extension.isEmpty()) {
                fullPath = fullPath + "." + extension;
            }
        }
        try {
            return context.getResource(fullPath).getFile().toPath();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to open configuration file", (Exception)e);
        }
    }
}

