/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptmavenplugin.mojo;

import com.ulisesbocchio.jasyptmavenplugin.encrypt.EncryptionService;
import com.ulisesbocchio.jasyptmavenplugin.mojo.AbstractJasyptMojo;
import com.ulisesbocchio.jasyptmavenplugin.mojo.FileService;
import java.nio.file.Path;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jasypt.properties.EncryptableProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="load", defaultPhase=LifecyclePhase.NONE, threadSafe=true)
public class LoadMojo
extends AbstractJasyptMojo {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadMojo.class);
    @Parameter(property="jasypt.plugin.keyPrefix")
    private String keyPrefix = null;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;

    @Override
    protected void run(EncryptionService service, Path path) throws MojoExecutionException {
        EncryptableProperties properties = service.getEncryptableProperties();
        FileService.load(path, (Properties)properties);
        if (properties.isEmpty()) {
            LOGGER.info("  No properties found");
        } else {
            for (String key : properties.stringPropertyNames()) {
                LOGGER.info("  Loaded '" + key + "' property");
            }
        }
        Properties projectProperties = this.project.getProperties();
        for (String key : properties.stringPropertyNames()) {
            if (this.keyPrefix != null) {
                projectProperties.put(this.keyPrefix + key, properties.get(key));
                continue;
            }
            projectProperties.put(key, properties.get(key));
        }
    }
}

