/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot;

import com.ulisesbocchio.jasyptspringboot.EncryptablePropertySource;
import com.ulisesbocchio.jasyptspringboot.InterceptionMode;
import com.ulisesbocchio.jasyptspringboot.aop.EncryptablePropertySourceMethodInterceptor;
import com.ulisesbocchio.jasyptspringboot.wrapper.EncryptableEnumerablePropertySourceWrapper;
import com.ulisesbocchio.jasyptspringboot.wrapper.EncryptablePropertySourceWrapper;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jasypt.encryption.StringEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.CommandLinePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class EnableEncryptablePropertySourcesPostProcessor
implements BeanFactoryPostProcessor,
ApplicationListener<ApplicationEvent>,
Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(EnableEncryptablePropertySourcesPostProcessor.class);
    private ConfigurableEnvironment environment;
    private InterceptionMode interceptionMode;

    public EnableEncryptablePropertySourcesPostProcessor() {
        this.interceptionMode = InterceptionMode.PROXY;
    }

    public EnableEncryptablePropertySourcesPostProcessor(ConfigurableEnvironment environment, InterceptionMode interceptionMode) {
        this.environment = environment;
        this.interceptionMode = interceptionMode;
    }

    private <T> PropertySource<T> makeEncryptable(PropertySource<T> propertySource, ConfigurableListableBeanFactory registry) {
        StringEncryptor encryptor = (StringEncryptor)registry.getBean(this.environment.resolveRequiredPlaceholders("${jasypt.encryptor.bean:jasyptStringEncryptor}"), StringEncryptor.class);
        PropertySource<T> encryptablePropertySource = this.interceptionMode == InterceptionMode.PROXY ? this.proxyPropertySource(propertySource, encryptor) : this.instantiatePropertySource(propertySource, encryptor);
        LOG.info("Converting PropertySource {} [{}] to {}", new Object[]{propertySource.getName(), propertySource.getClass().getName(), AopUtils.isAopProxy(encryptablePropertySource) ? "AOP Proxy" : encryptablePropertySource.getClass().getSimpleName()});
        return encryptablePropertySource;
    }

    private <T> PropertySource<T> proxyPropertySource(PropertySource<T> propertySource, StringEncryptor encryptor) {
        if (CommandLinePropertySource.class.isAssignableFrom(propertySource.getClass())) {
            return this.instantiatePropertySource(propertySource, encryptor);
        }
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setTargetClass(propertySource.getClass());
        proxyFactory.setProxyTargetClass(true);
        proxyFactory.addInterface(EncryptablePropertySource.class);
        proxyFactory.setTarget(propertySource);
        proxyFactory.addAdvice(new EncryptablePropertySourceMethodInterceptor(encryptor));
        return (PropertySource)proxyFactory.getProxy();
    }

    private <T> PropertySource<T> instantiatePropertySource(PropertySource<T> propertySource, StringEncryptor encryptor) {
        Object encryptablePropertySource = propertySource instanceof MapPropertySource ? new PropertySource<T>((MapPropertySource)propertySource, encryptor) : (propertySource.getClass().getName().equals("org.springframework.boot.context.config.ConfigFileApplicationListener$ConfigurationPropertySources") ? this.proxyPropertySource(propertySource, encryptor) : (propertySource instanceof EnumerablePropertySource ? new EncryptableEnumerablePropertySourceWrapper((EnumerablePropertySource)propertySource, encryptor) : new EncryptablePropertySourceWrapper<T>(propertySource, encryptor)));
        return encryptablePropertySource;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        LOG.info("Post-processing PropertySource instances");
        MutablePropertySources propSources = this.environment.getPropertySources();
        StreamSupport.stream(propSources.spliterator(), false).filter(ps -> !(ps instanceof EncryptablePropertySource)).map(s -> this.makeEncryptable((PropertySource)s, beanFactory)).collect(Collectors.toList()).forEach(ps -> propSources.replace(ps.getName(), ps));
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        LOG.debug("Application Event Raised: {}", (Object)event.getClass().getSimpleName());
    }
}

