/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.aop;

import com.ulisesbocchio.jasyptspringboot.EncryptablePropertySource;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.jasypt.encryption.StringEncryptor;
import org.springframework.core.env.PropertySource;

public class EncryptablePropertySourceMethodInterceptor<T>
implements MethodInterceptor,
EncryptablePropertySource<T> {
    private final StringEncryptor encryptor;

    public EncryptablePropertySourceMethodInterceptor(StringEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object returnValue = invocation.proceed();
        if (this.isGetPropertyCall(invocation)) {
            return this.getProperty(this.encryptor, this.getPropertySource(invocation), this.getNameArgument(invocation));
        }
        return returnValue;
    }

    private PropertySource<T> getPropertySource(MethodInvocation invocation) {
        return (PropertySource)invocation.getThis();
    }

    private String getNameArgument(MethodInvocation invocation) {
        return (String)invocation.getArguments()[0];
    }

    private boolean isGetPropertyCall(MethodInvocation invocation) {
        return invocation.getMethod().getName().equals("getProperty") && invocation.getMethod().getParameters().length == 1 && invocation.getMethod().getParameters()[0].getType() == String.class;
    }
}

