/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot;

import com.ulisesbocchio.jasyptspringboot.exception.DecryptionException;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;
import org.jasypt.properties.PropertyValueEncryptionUtils;
import org.springframework.core.env.PropertySource;

public interface EncryptablePropertySource<T> {
    default public Object getProperty(StringEncryptor encryptor, PropertySource<T> source, String name) {
        String stringValue;
        Object value = source.getProperty(name);
        if (value instanceof String && PropertyValueEncryptionUtils.isEncryptedValue((String)(stringValue = String.valueOf(value)))) {
            try {
                value = PropertyValueEncryptionUtils.decrypt((String)stringValue, (StringEncryptor)encryptor);
            }
            catch (EncryptionOperationNotPossibleException e) {
                throw new DecryptionException("Decryption of Properties failed,  make sure encryption/decryption passwords match", e);
            }
        }
        return value;
    }
}

