/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.configuration;

import com.ulisesbocchio.jasyptspringboot.EnableEncryptablePropertySourcesPostProcessor;
import com.ulisesbocchio.jasyptspringboot.InterceptionMode;
import com.ulisesbocchio.jasyptspringboot.configuration.StringEncryptorConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.ConfigurableEnvironment;

@Configuration
@Import(value={StringEncryptorConfiguration.class})
public class EnableEncryptablePropertySourcesConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(EnableEncryptablePropertySourcesConfiguration.class);

    @Bean
    public static EnableEncryptablePropertySourcesPostProcessor enableEncryptablePropertySourcesPostProcessor(ConfigurableEnvironment environment) {
        boolean proxyPropertySources = (Boolean)environment.getProperty("jasypt.encryptor.proxyPropertySources", Boolean.TYPE, (Object)false);
        InterceptionMode interceptionMode = proxyPropertySources ? InterceptionMode.PROXY : InterceptionMode.WRAPPER;
        return new EnableEncryptablePropertySourcesPostProcessor(environment, interceptionMode);
    }
}

