/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.resolver;

import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyDetector;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyResolver;
import com.ulisesbocchio.jasyptspringboot.detector.DefaultPropertyDetector;
import com.ulisesbocchio.jasyptspringboot.exception.DecryptionException;
import java.util.Optional;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

public class DefaultPropertyResolver
implements EncryptablePropertyResolver {
    private final Environment environment;
    private StringEncryptor encryptor;
    private EncryptablePropertyDetector detector;

    public DefaultPropertyResolver(StringEncryptor encryptor, Environment environment) {
        this(encryptor, new DefaultPropertyDetector(), environment);
    }

    public DefaultPropertyResolver(StringEncryptor encryptor, EncryptablePropertyDetector detector, Environment environment) {
        this.environment = environment;
        Assert.notNull((Object)encryptor, (String)"String encryptor can't be null");
        Assert.notNull((Object)detector, (String)"Encryptable Property detector can't be null");
        this.encryptor = encryptor;
        this.detector = detector;
    }

    @Override
    public String resolvePropertyValue(String value) {
        return Optional.ofNullable(value).map(arg_0 -> ((Environment)this.environment).resolveRequiredPlaceholders(arg_0)).filter(this.detector::isEncrypted).map(resolvedValue -> {
            try {
                String unwrappedProperty = this.detector.unwrapEncryptedValue(resolvedValue.trim());
                String resolvedProperty = this.environment.resolvePlaceholders(unwrappedProperty);
                return this.encryptor.decrypt(resolvedProperty);
            }
            catch (EncryptionOperationNotPossibleException e) {
                throw new DecryptionException("Unable to decrypt: " + value + ". Decryption of Properties failed,  make sure encryption/decryption passwords match", e);
            }
        }).orElse(value);
    }
}

