/*
 * Decompiled with CFR 0.152.
 */
package com.github.ulisesbocchio.jar.resources;

import com.github.ulisesbocchio.jar.resources.JarUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.ResourceUtils;

public class JarResource
implements Resource {
    private static final Logger log = LoggerFactory.getLogger(JarResource.class);
    private final Resource delegate;
    private final String extractPath;
    private static final Map<URL, File> FILE_REGISTRY = new ConcurrentHashMap<URL, File>();

    public JarResource(Resource resource) {
        this(resource, null);
    }

    public JarResource(Resource resource, String extractPath) {
        this.delegate = resource;
        this.extractPath = extractPath;
    }

    public boolean exists() {
        return this.delegate.exists();
    }

    public boolean isReadable() {
        return this.delegate.isReadable();
    }

    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    public URL getURL() throws IOException {
        return this.delegate.getURL();
    }

    public URI getURI() throws IOException {
        return this.delegate.getURI();
    }

    public File getFile() throws IOException {
        URL resourceUrl = this.getURL();
        if (ResourceUtils.isJarURL((URL)resourceUrl)) {
            File tempFile = FILE_REGISTRY.get(resourceUrl);
            if (tempFile == null || !tempFile.exists()) {
                log.debug("Extracting File for URL: {}", (Object)resourceUrl);
                tempFile = JarUtils.getFile(this.delegate, this.extractPath);
                FILE_REGISTRY.put(resourceUrl, tempFile);
            } else {
                log.debug("File found in registry for URL: {}", (Object)resourceUrl);
            }
            return new File(tempFile.toURI());
        }
        return this.delegate.getFile();
    }

    public long contentLength() throws IOException {
        return this.getFile().length();
    }

    public long lastModified() throws IOException {
        return this.getFile().lastModified();
    }

    public Resource createRelative(String relativePath) throws IOException {
        return new JarResource(this.delegate.createRelative(relativePath), this.extractPath);
    }

    public String getFilename() {
        return this.delegate.getFilename();
    }

    public String getDescription() {
        return this.delegate.getDescription();
    }

    public InputStream getInputStream() throws IOException {
        return this.delegate.getInputStream();
    }

    public String toString() {
        return this.getDescription();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Resource && ((Resource)obj).getDescription().equals(this.getDescription());
    }

    public int hashCode() {
        return this.getDescription().hashCode();
    }
}

