/*
 * Decompiled with CFR 0.152.
 */
package com.github.ulisesbocchio.jar.resources;

import com.github.ulisesbocchio.jar.resources.JarResource;
import com.google.common.io.Files;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class JarResourceLoader
implements ResourceLoader {
    private static final Logger log = LoggerFactory.getLogger(JarResourceLoader.class);
    private ResourceLoader delegate = new DefaultResourceLoader();
    private String extractPath;
    private String resolvedExtractPath;
    private Environment environment;
    private String propertyName;

    public JarResourceLoader(String extractPath) {
        this.extractPath = extractPath;
    }

    public JarResourceLoader() {
    }

    public JarResourceLoader(Environment environment, String propertyName) {
        this.environment = environment;
        this.propertyName = propertyName;
    }

    public Resource getResource(String location) {
        Resource resource = this.delegate.getResource(location);
        String resolvedExtractPath = this.getResolvedExtractPath();
        return new JarResource(resource, resolvedExtractPath);
    }

    private String getResolvedExtractPath() {
        if (this.resolvedExtractPath == null) {
            this.resolvedExtractPath = Optional.ofNullable(this.environment).map(env -> this.environment.getProperty(this.propertyName)).orElse(this.extractPath);
            if (this.extractPath == null) {
                this.extractPath = Files.createTempDir().getAbsolutePath();
                log.debug("TEMP EXTRACT DIR CREATED {}", (Object)this.extractPath);
            }
            log.debug("Resolved JarResource extract path to: {}", (Object)this.resolvedExtractPath);
        }
        return this.resolvedExtractPath;
    }

    public ClassLoader getClassLoader() {
        return this.delegate.getClassLoader();
    }

    public void setDelegate(ResourceLoader delegate) {
        this.delegate = delegate;
    }
}

