/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.rest;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.mashape.unirest.request.BaseRequest;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.iterator.EmptyIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.unipop.query.UniQuery;
import org.unipop.query.controller.SimpleController;
import org.unipop.query.mutation.AddEdgeQuery;
import org.unipop.query.mutation.AddVertexQuery;
import org.unipop.query.mutation.PropertyQuery;
import org.unipop.query.mutation.RemoveQuery;
import org.unipop.query.predicates.PredicateQuery;
import org.unipop.query.search.DeferredVertexQuery;
import org.unipop.query.search.SearchQuery;
import org.unipop.query.search.SearchVertexQuery;
import org.unipop.rest.RestEdgeSchema;
import org.unipop.rest.RestSchema;
import org.unipop.rest.RestVertexSchema;
import org.unipop.schema.element.ElementSchema;
import org.unipop.schema.reference.DeferredVertex;
import org.unipop.structure.UniEdge;
import org.unipop.structure.UniElement;
import org.unipop.structure.UniGraph;
import org.unipop.structure.UniVertex;

public class RestController
implements SimpleController {
    private static final Logger logger = LoggerFactory.getLogger(RestController.class);
    private final UniGraph graph;
    private Set<? extends RestVertexSchema> vertexSchemas = new HashSet<RestVertexSchema>();
    private Set<? extends RestEdgeSchema> edgeSchemas = new HashSet<RestEdgeSchema>();

    public RestController(UniGraph graph, Set<RestSchema> schemas) {
        this.graph = graph;
        Set<RestSchema> documentSchemas = this.collectSchemas(schemas);
        this.vertexSchemas = documentSchemas.stream().filter(schema -> schema instanceof RestVertexSchema).map(schema -> (RestVertexSchema)schema).collect(Collectors.toSet());
        this.edgeSchemas = documentSchemas.stream().filter(schema -> schema instanceof RestEdgeSchema).map(schema -> (RestEdgeSchema)schema).collect(Collectors.toSet());
        logger.debug("Instantiated RestController: {}", (Object)this);
    }

    private Set<RestSchema> collectSchemas(Set<? extends ElementSchema> schemas) {
        HashSet<RestSchema> docSchemas = new HashSet<RestSchema>();
        schemas.forEach(schema -> {
            if (schema instanceof RestSchema) {
                docSchemas.add((RestSchema)schema);
                Set<RestSchema> childSchemas = this.collectSchemas(schema.getChildSchemas());
                docSchemas.addAll(childSchemas);
            }
        });
        return docSchemas;
    }

    public Iterator<Edge> search(SearchVertexQuery uniQuery) {
        RestCollector collector = new RestCollector(schema -> schema.getSearch(uniQuery), (schema, result) -> schema.parseResults((HttpResponse<JsonNode>)result, (PredicateQuery)uniQuery));
        Map schemas = (Map)this.edgeSchemas.stream().collect(collector);
        return this.search((UniQuery)uniQuery, schemas, collector);
    }

    public <E extends Element> Iterator<E> search(SearchQuery<E> uniQuery) {
        RestCollector collector = new RestCollector(schema -> schema.getSearch(uniQuery), (schema, result) -> schema.parseResults((HttpResponse<JsonNode>)result, (PredicateQuery)uniQuery));
        Set<RestSchema<E>> schemas = this.getSchemas(uniQuery.getReturnType());
        Map collect = (Map)schemas.stream().collect(collector);
        return this.search((UniQuery)uniQuery, collect, collector);
    }

    public void fetchProperties(DeferredVertexQuery query) {
        RestCollector collector = new RestCollector(schema -> schema.getSearch(query), (schema, result) -> schema.parseResults((HttpResponse<JsonNode>)result, (PredicateQuery)query));
        Map schemas = (Map)this.vertexSchemas.stream().collect(collector);
        Iterator iterator = this.search((UniQuery)query, schemas, collector);
        Map vertexMap = query.getVertices().stream().collect(Collectors.toMap(UniElement::id, Function.identity(), (a, b) -> a));
        iterator.forEachRemaining(newVertex -> {
            DeferredVertex deferredVertex = (DeferredVertex)vertexMap.get(newVertex.id());
            if (deferredVertex != null) {
                deferredVertex.loadProperties(newVertex);
            }
        });
    }

    public <E extends Element> void remove(RemoveQuery<E> uniQuery) {
        uniQuery.getElements().forEach(element -> {
            Set schemas = this.getSchemas(element.getClass());
            for (RestSchema<Element> restSchema : schemas) {
                BaseRequest delete = restSchema.delete((Element)element);
                try {
                    HttpResponse jsonNodeHttpResponse = delete.asJson();
                    if (jsonNodeHttpResponse.getStatus() != 200) continue;
                    break;
                }
                catch (UnirestException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public Vertex addVertex(AddVertexQuery uniQuery) {
        UniVertex vertex = new UniVertex(uniQuery.getProperties(), this.graph);
        for (RestVertexSchema restVertexSchema : this.vertexSchemas) {
            try {
                BaseRequest baseRequest = restVertexSchema.addElement(vertex);
                if (baseRequest == null) {
                    return vertex;
                }
                baseRequest.asJson();
            }
            catch (UnirestException e) {
                e.printStackTrace();
            }
            catch (NoSuchElementException e) {}
        }
        return vertex;
    }

    public <E extends Element> void property(PropertyQuery<E> uniQuery) {
        Element element = uniQuery.getElement();
        Set<RestSchema<E>> schemas = this.getSchemas(element.getClass());
        for (RestSchema<Element> restSchema : schemas) {
            try {
                BaseRequest baseRequest = restSchema.addElement(element);
                if (baseRequest == null) {
                    return;
                }
                baseRequest.asJson();
            }
            catch (UnirestException e) {
                e.printStackTrace();
            }
            catch (NoSuchElementException e) {}
        }
    }

    private <E extends Element> Set<? extends RestSchema<E>> getSchemas(Class elementClass) {
        if (Vertex.class.isAssignableFrom(elementClass)) {
            return this.vertexSchemas;
        }
        return this.edgeSchemas;
    }

    public Edge addEdge(AddEdgeQuery uniQuery) {
        UniEdge edge = new UniEdge(uniQuery.getProperties(), uniQuery.getOutVertex(), uniQuery.getInVertex(), this.graph);
        for (RestEdgeSchema restEdgeSchema : this.edgeSchemas) {
            try {
                BaseRequest baseRequest = restEdgeSchema.addElement(edge);
                if (baseRequest == null) {
                    return edge;
                }
                baseRequest.asJson();
            }
            catch (UnirestException e) {
                e.printStackTrace();
            }
            catch (NoSuchElementException e) {}
        }
        return edge;
    }

    private <E extends Element, S extends RestSchema<E>> Iterator<E> search(UniQuery query, Map<S, BaseRequest> schemas, RestCollector<S, BaseRequest, E> collector) {
        if (schemas.size() == 0) {
            return EmptyIterator.instance();
        }
        logger.debug("Preparing search. Schemas: {}", schemas);
        List results = schemas.values().stream().map(request -> {
            try {
                return request.asJson();
            }
            catch (UnirestException e) {
                throw new RuntimeException("request: " + request.toString() + " unsuccessful");
            }
        }).collect(Collectors.toList());
        Iterator schemaIterator = schemas.keySet().iterator();
        return results.stream().flatMap(result -> ((Collection)collector.parse.apply(schemaIterator.next(), result)).stream()).iterator();
    }

    public class RestCollector<K, V, R>
    implements Collector<K, Map<K, V>, Map<K, V>> {
        private final Function<? super K, ? extends V> valueMapper;
        private final BiFunction<? super K, HttpResponse<JsonNode>, ? extends Collection<R>> parse;

        private RestCollector(Function<? super K, ? extends V> valueMapper, BiFunction<? super K, HttpResponse<JsonNode>, Collection<R>> parse) {
            this.valueMapper = valueMapper;
            this.parse = parse;
        }

        @Override
        public Supplier<Map<K, V>> supplier() {
            return HashMap::new;
        }

        @Override
        public BiConsumer<Map<K, V>, K> accumulator() {
            return (map, t) -> {
                V value = this.valueMapper.apply(t);
                if (value != null) {
                    map.put(t, value);
                }
            };
        }

        @Override
        public BinaryOperator<Map<K, V>> combiner() {
            return (map1, map2) -> {
                map1.putAll(map2);
                return map1;
            };
        }

        @Override
        public Function<Map<K, V>, Map<K, V>> finisher() {
            return m -> m;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return EnumSet.of(Collector.Characteristics.IDENTITY_FINISH);
        }
    }
}

