/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.rest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import org.unipop.query.controller.SourceProvider;
import org.unipop.query.controller.UniQueryController;
import org.unipop.rest.RestController;
import org.unipop.rest.RestSchema;
import org.unipop.rest.schema.RestEdge;
import org.unipop.rest.schema.RestVertex;
import org.unipop.rest.util.MatcherHolder;
import org.unipop.rest.util.TemplateHolder;
import org.unipop.rest.util.matchers.KeyMatcher;
import org.unipop.rest.util.matchers.Matcher;
import org.unipop.rest.util.matchers.MultiOpMatcher;
import org.unipop.rest.util.matchers.OpMatcher;
import org.unipop.structure.UniGraph;
import org.unipop.util.ConversionUtils;

public class RestSourceProvider
implements SourceProvider {
    private UniGraph graph;
    private String resultPath;
    private JSONObject opTranslator;
    private int maxResultSize;
    private TemplateHolder templateHolder;
    private MatcherHolder complexTranslator;
    private boolean valuesToString;

    public Set<UniQueryController> init(UniGraph graph, JSONObject configuration) throws Exception {
        this.graph = graph;
        String url = configuration.optString("baseUrl");
        this.templateHolder = new TemplateHolder(configuration);
        this.resultPath = configuration.optString("resultPath");
        this.opTranslator = configuration.getJSONObject("opTranslator");
        this.maxResultSize = configuration.optInt("maxResultSize", 10000);
        this.valuesToString = configuration.optBoolean("valuesToString", false);
        ArrayList<Matcher.MatcherBuilder> builders = new ArrayList<Matcher.MatcherBuilder>();
        builders.add(new KeyMatcher.KeyMatcherBuilder());
        builders.add(new OpMatcher.OpMatcherBuilder());
        builders.add(new MultiOpMatcher.MultiOpMatcherBuilder());
        if (configuration.has("builders")) {
            JSONArray builderNames = configuration.getJSONArray("builders");
            for (int i = 0; i < builderNames.length(); ++i) {
                String builderName = builderNames.getString(i);
                builders.add(Class.forName(builderName).asSubclass(Matcher.MatcherBuilder.class).newInstance());
            }
        }
        this.complexTranslator = new MatcherHolder(configuration, builders);
        HashSet<RestSchema> schemas = new HashSet<RestSchema>();
        for (JSONObject json : ConversionUtils.getList((JSONObject)configuration, (String)"vertices")) {
            schemas.add(this.createVertexSchema(json, url));
        }
        for (JSONObject json : ConversionUtils.getList((JSONObject)configuration, (String)"edges")) {
            schemas.add(this.createEdgeSchema(json, url));
        }
        return Collections.singleton(new RestController(graph, schemas));
    }

    private RestSchema createEdgeSchema(JSONObject json, String url) {
        return new RestEdge(json, this.graph, url, this.templateHolder, this.resultPath, this.opTranslator, this.maxResultSize, this.complexTranslator, this.valuesToString);
    }

    private RestSchema createVertexSchema(JSONObject json, String url) {
        return new RestVertex(json, url, this.graph, this.templateHolder, this.resultPath, this.opTranslator, this.maxResultSize, this.complexTranslator, this.valuesToString);
    }

    public void close() {
    }
}

