/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.rest.schema;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.mashape.unirest.request.BaseRequest;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.json.JSONArray;
import org.json.JSONObject;
import org.unipop.query.predicates.PredicateQuery;
import org.unipop.query.predicates.PredicatesHolder;
import org.unipop.query.search.SearchQuery;
import org.unipop.rest.RestSchema;
import org.unipop.rest.util.MatcherHolder;
import org.unipop.rest.util.PredicatesTranslator;
import org.unipop.rest.util.TemplateHolder;
import org.unipop.schema.element.AbstractElementSchema;
import org.unipop.schema.property.PropertySchema;
import org.unipop.structure.UniGraph;

public abstract class AbstractRestSchema<E extends Element>
extends AbstractElementSchema<E>
implements RestSchema<E> {
    protected String baseUrl;
    protected String resource;
    protected TemplateHolder templateHolder;
    protected String resultPath;
    protected JSONObject opTranslator;
    protected int maxResultSize;
    protected List<Map<String, Object>> bulk;
    protected int bulkSize;
    protected MatcherHolder complexTranslator;
    protected boolean valuesToString;

    public AbstractRestSchema(JSONObject configuration, UniGraph graph, String url, TemplateHolder templateHolder, String resultPath, JSONObject opTranslator, int maxResultSize, MatcherHolder complexTranslator, boolean valuesToString) {
        super(configuration, graph);
        this.resource = configuration.optString("resource");
        this.templateHolder = templateHolder;
        this.baseUrl = url;
        this.resultPath = resultPath;
        this.opTranslator = opTranslator;
        this.maxResultSize = maxResultSize;
        this.bulk = new ArrayList<Map<String, Object>>();
        this.bulkSize = 1000;
        this.complexTranslator = complexTranslator;
        this.valuesToString = valuesToString;
    }

    @Override
    public BaseRequest getSearch(SearchQuery<E> query) {
        int limit = query.getOrders() == null || query.getOrders().size() > 0 ? -1 : query.getLimit();
        return this.createSearch(this.toPredicates(query.getPredicates()), limit);
    }

    protected BaseRequest createSearch(PredicatesHolder predicatesHolder, int limit) {
        limit = limit == -1 ? this.maxResultSize : Math.min(this.maxResultSize, limit);
        Map<String, Object> predicates = PredicatesTranslator.translate(predicatesHolder, this.opTranslator, this.complexTranslator, this.valuesToString, limit);
        HashMap<String, String> urlMap = new HashMap<String, String>();
        urlMap.put("resource", this.resource);
        BaseRequest request = this.templateHolder.getSearch().execute(this.baseUrl, urlMap, predicates);
        try {
            if (this.bulk.size() > 0) {
                this.runBulk();
            }
            if (this.templateHolder.isCommit()) {
                this.templateHolder.getCommit().execute(this.baseUrl, urlMap, predicates).asJson();
            }
        }
        catch (UnirestException e) {
            e.printStackTrace();
        }
        return request;
    }

    protected Set<String> toFields() {
        Set keys = this.propertySchemas.stream().map(PropertySchema::getKey).collect(Collectors.toSet());
        return this.toFields(keys);
    }

    @Override
    public List<E> parseResults(HttpResponse<JsonNode> result, PredicateQuery query) {
        String[] path = this.resultPath.split("\\.");
        JSONObject object = ((JsonNode)result.getBody()).getObject();
        JSONArray results = null;
        for (int i = 0; i < path.length; ++i) {
            if (i == path.length - 1) {
                results = object.getJSONArray(path[i]);
                continue;
            }
            object = object.getJSONObject(path[i]);
        }
        ArrayList<E> elements = new ArrayList<E>();
        for (int i = 0; i < results.length(); ++i) {
            JSONObject jsonResult = results.getJSONObject(i);
            Set<String> fields = this.toFields();
            HashMap<String, Object> fieldsMap = new HashMap<String, Object>();
            fields.forEach(field -> {
                String[] fieldPath = field.split("\\.");
                Object data = jsonResult;
                for (String key : fieldPath) {
                    if (!(data instanceof JSONObject)) continue;
                    data = data.opt(key);
                }
                if (data != null) {
                    if (!NumberUtils.isNumber((String)data.toString())) {
                        fieldsMap.put((String)field, data);
                    } else {
                        Number number = NumberUtils.createNumber((String)data.toString());
                        if (number instanceof Float) {
                            number = Double.parseDouble(data.toString());
                        }
                        fieldsMap.put((String)field, number);
                    }
                }
            });
            E element = this.create(fieldsMap);
            if (element == null || !query.test(element, query.getPredicates())) continue;
            elements.add(element);
        }
        return elements;
    }

    protected abstract E create(Map<String, Object> var1);

    private void runBulk() {
        BaseRequest bulk = this.templateHolder.getBulk().execute(this.baseUrl, Collections.singletonMap("resource", this.resource), Collections.singletonMap("bulk", this.bulk));
        try {
            bulk.asJson();
            this.bulk.clear();
        }
        catch (UnirestException e) {
            e.printStackTrace();
        }
    }

    @Override
    public BaseRequest addElement(E element) throws NoSuchElementException {
        Map fields = this.toFields((Element)element);
        if (fields == null) {
            throw new NoSuchElementException();
        }
        Map<String, Object> stringObjectMap = fields.entrySet().stream().map(entry -> {
            String[] split = ((String)entry.getKey()).split("\\.");
            return new AbstractMap.SimpleEntry(split[split.length - 1], entry.getValue());
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        HashMap<String, Object> urlMap = new HashMap<String, Object>();
        urlMap.putAll(stringObjectMap);
        urlMap.put("resource", this.resource);
        return this.insertElement(urlMap, stringObjectMap);
    }

    protected BaseRequest insertElement(Map<String, Object> urlMap, Map<String, Object> object) {
        if (this.templateHolder.isBulk()) {
            HashMap<String, Map<String, Object>> insert = new HashMap<String, Map<String, Object>>();
            insert.put("object", Collections.singletonMap("prop", object.entrySet()));
            insert.put("url", urlMap);
            this.bulk.add(insert);
            if (this.bulk.size() >= this.bulkSize) {
                this.runBulk();
            }
            return null;
        }
        if (this.templateHolder.isAdd()) {
            return this.templateHolder.getAdd().execute(this.baseUrl, urlMap, Collections.singletonMap("prop", object.entrySet()));
        }
        return null;
    }

    @Override
    public BaseRequest delete(E element) {
        if (this.templateHolder.isDelete()) {
            Map fields = this.toFields((Element)element);
            if (fields == null) {
                throw new NoSuchElementException();
            }
            Map<String, Object> stringObjectMap = fields.entrySet().stream().map(entry -> {
                String[] split = ((String)entry.getKey()).split("\\.");
                return new AbstractMap.SimpleEntry(split[split.length - 1], entry.getValue());
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            HashMap<String, Object> urlMap = new HashMap<String, Object>();
            urlMap.putAll(stringObjectMap);
            urlMap.put("resource", this.resource);
            return this.templateHolder.getDelete().execute(this.baseUrl, urlMap, element);
        }
        return null;
    }
}

