/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.rest.schema;

import com.mashape.unirest.request.BaseRequest;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.json.JSONException;
import org.json.JSONObject;
import org.unipop.query.predicates.PredicatesHolder;
import org.unipop.query.predicates.PredicatesHolderFactory;
import org.unipop.query.search.SearchVertexQuery;
import org.unipop.rest.RestEdgeSchema;
import org.unipop.rest.schema.AbstractRestSchema;
import org.unipop.rest.schema.RestVertex;
import org.unipop.rest.util.MatcherHolder;
import org.unipop.rest.util.TemplateHolder;
import org.unipop.schema.element.VertexSchema;
import org.unipop.schema.reference.ReferenceVertexSchema;
import org.unipop.structure.UniEdge;
import org.unipop.structure.UniGraph;

public class RestEdge
extends AbstractRestSchema<Edge>
implements RestEdgeSchema {
    protected VertexSchema outVertexSchema = this.createVertexSchema("outVertex");
    protected VertexSchema inVertexSchema = this.createVertexSchema("inVertex");

    public RestEdge(JSONObject configuration, UniGraph graph, String url, TemplateHolder templateHolder, String resultPath, JSONObject opTranslator, int maxResultSize, MatcherHolder complexTranslator, boolean valuesToString) {
        super(configuration, graph, url, templateHolder, resultPath, opTranslator, maxResultSize, complexTranslator, valuesToString);
    }

    protected VertexSchema createVertexSchema(String key) throws JSONException {
        JSONObject vertexConfiguration = this.json.optJSONObject(key);
        if (vertexConfiguration == null) {
            return null;
        }
        if (vertexConfiguration.optBoolean("ref", false)) {
            return new ReferenceVertexSchema(vertexConfiguration, this.graph);
        }
        return new RestVertex(vertexConfiguration, this.baseUrl, this.graph, this.templateHolder, this.resultPath, this.opTranslator, this.maxResultSize, this.complexTranslator, this.valuesToString);
    }

    @Override
    protected Edge create(Map<String, Object> fields) {
        return new UniEdge(this.getProperties(fields), this.outVertexSchema.createElement(fields), this.inVertexSchema.createElement(fields), this.graph);
    }

    public Collection<Edge> fromFields(Map<String, Object> fields) {
        return Collections.singleton(this.create(fields));
    }

    @Override
    public BaseRequest getSearch(SearchVertexQuery query) {
        int limit = query.getOrders() == null || query.getOrders().size() > 0 ? -1 : query.getLimit();
        PredicatesHolder edgePredicates = this.toPredicates(query.getPredicates());
        PredicatesHolder vertexPredicates = this.getVertexPredicates(query.getVertices(), query.getDirection());
        PredicatesHolder predicatesHolder = PredicatesHolderFactory.and((PredicatesHolder[])new PredicatesHolder[]{edgePredicates, vertexPredicates});
        return this.createSearch(predicatesHolder, limit);
    }

    @Override
    protected Set<String> toFields() {
        Set<String> edgeFields = super.toFields();
        Set outVertexFields = this.outVertexSchema instanceof RestVertex ? ((RestVertex)this.outVertexSchema).toFields() : this.outVertexSchema.toFields(Collections.emptySet());
        Set inVertexFields = this.inVertexSchema instanceof RestVertex ? ((RestVertex)this.inVertexSchema).toFields() : this.inVertexSchema.toFields(Collections.emptySet());
        return Stream.of(edgeFields, outVertexFields, inVertexFields).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public BaseRequest addElement(Edge element) throws NoSuchElementException {
        Map outVertexFields = this.outVertexSchema.toFields((Element)element.outVertex());
        Map inVertexFields = this.inVertexSchema.toFields((Element)element.inVertex());
        Map fields = this.toFields((Element)element);
        if (fields == null || outVertexFields == null || inVertexFields == null) {
            throw new NoSuchElementException();
        }
        Map<String, Object> stringObjectMap = Stream.of(outVertexFields.entrySet(), inVertexFields.entrySet(), fields.entrySet()).flatMap(Collection::stream).map(entry -> {
            String[] split = ((String)entry.getKey()).split("\\.");
            return new AbstractMap.SimpleEntry(split[split.length - 1], entry.getValue());
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        HashMap<String, Object> urlMap = new HashMap<String, Object>();
        urlMap.putAll(stringObjectMap);
        urlMap.put("resource", this.resource);
        return this.insertElement(urlMap, stringObjectMap);
    }

    protected PredicatesHolder getVertexPredicates(List<Vertex> vertices, Direction direction) {
        PredicatesHolder outPredicates = this.outVertexSchema.toPredicates(vertices);
        PredicatesHolder inPredicates = this.inVertexSchema.toPredicates(vertices);
        if (direction.equals((Object)Direction.OUT) && outPredicates.notAborted()) {
            return outPredicates;
        }
        if (direction.equals((Object)Direction.IN) && inPredicates.notAborted()) {
            return inPredicates;
        }
        if (outPredicates.notAborted() && inPredicates.notAborted()) {
            return PredicatesHolderFactory.or((PredicatesHolder[])new PredicatesHolder[]{inPredicates, outPredicates});
        }
        if (outPredicates.isAborted()) {
            return inPredicates;
        }
        if (inPredicates.isAborted()) {
            return outPredicates;
        }
        return PredicatesHolderFactory.abort();
    }
}

