/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.rest.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.json.JSONArray;
import org.json.JSONObject;
import org.unipop.rest.util.matchers.Matcher;

public class MatcherHolder {
    protected List<Matcher> matchers = new ArrayList<Matcher>();

    public MatcherHolder(JSONObject configuration, List<Matcher.MatcherBuilder> builders) {
        if (configuration.has("complexTranslator")) {
            JSONArray complexTranslator = configuration.getJSONArray("complexTranslator");
            for (int i = 0; i < complexTranslator.length(); ++i) {
                JSONObject jsonObject = complexTranslator.getJSONObject(i);
                Optional<Matcher> matcher = builders.stream().map(matcherBuilder -> matcherBuilder.build(jsonObject)).filter(m -> m != null).findFirst();
                if (!matcher.isPresent()) continue;
                this.matchers.add(matcher.get());
            }
        }
    }

    public String match(HasContainer hasContainer) {
        for (Matcher matcher : this.matchers) {
            if (!matcher.match(hasContainer)) continue;
            return matcher.execute(hasContainer);
        }
        return null;
    }
}

