/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.rest.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.json.JSONObject;
import org.unipop.query.predicates.PredicatesHolder;
import org.unipop.rest.util.MatcherHolder;

public class PredicatesTranslator {
    public static Map<String, Object> translate(PredicatesHolder predicatesHolder, JSONObject opTranslator, MatcherHolder complexTranslator, boolean valuesToString, int limit) {
        Map<String, Object> translate = PredicatesTranslator.translate(predicatesHolder, opTranslator, complexTranslator, valuesToString);
        translate.put("limit", limit);
        return translate;
    }

    public static Map<String, Object> translate(PredicatesHolder predicatesHolder, JSONObject opTranslator, MatcherHolder complexTranslator, boolean valuesToString) {
        List predicates = predicatesHolder.getPredicates();
        Map<HasContainer, String> complexOps = predicates.stream().map(hasContainer -> {
            String match = complexTranslator.match((HasContainer)hasContainer);
            if (match != null) {
                return Pair.of((Object)hasContainer, (Object)match);
            }
            return null;
        }).filter(t -> t != null).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        List predicatesMaps = predicates.stream().filter(has -> !complexOps.containsKey(has)).map(has -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            String[] split = has.getKey().split("\\.");
            map.put("key", split[split.length - 1]);
            Object value = has.getValue();
            if (value instanceof String) {
                map.put("value", "\"" + value + "\"");
            } else if (value instanceof Collection) {
                String finalString = "[%s]";
                List values = ((Collection)value).stream().map(v -> "\"" + v.toString() + "\"").collect(Collectors.toList());
                String valuesString = "";
                String join = String.join((CharSequence)",", values);
                map.put("value", String.format(finalString, join));
            } else if (!valuesToString) {
                map.put("value", value);
            } else {
                map.put("value", "\"" + value + "\"");
            }
            if (!opTranslator.has(has.getBiPredicate().toString())) {
                return null;
            }
            map.put("op", opTranslator.getString(has.getBiPredicate().toString()));
            return map;
        }).filter(m -> m != null).collect(Collectors.toList());
        List children = predicatesHolder.getChildren().stream().map(p -> PredicatesTranslator.translate(p, opTranslator, complexTranslator, valuesToString)).collect(Collectors.toList());
        HashMap map = new HashMap();
        HashMap<String, Collection<Object>> predicateChildrenMap = new HashMap<String, Collection<Object>>();
        if (predicatesMaps.size() > 0) {
            predicateChildrenMap.put("predicates", predicatesMaps);
        }
        if (complexOps.values().size() > 0) {
            predicateChildrenMap.put("complex", complexOps.values());
        }
        if (children.size() > 0) {
            predicateChildrenMap.put("children", children);
        }
        if (predicateChildrenMap.size() > 0) {
            map.put(predicatesHolder.getClause().toString().toLowerCase(), predicateChildrenMap);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (map.size() > 0) {
            result.put("predicates", map);
        }
        return result;
    }
}

