/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.rest.util;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import org.json.JSONObject;
import org.unipop.rest.util.TemplateRequest;

public class TemplateHolder {
    private TemplateRequest search;
    private TemplateRequest add;
    private TemplateRequest delete;
    private TemplateRequest commit;
    private TemplateRequest bulk;

    private static Reader getReader(String mustache) {
        if (mustache.contains("{")) {
            return new StringReader(mustache);
        }
        try {
            return new FileReader(mustache);
        }
        catch (FileNotFoundException e) {
            return new StringReader(mustache);
        }
    }

    public static Template createTemplate(String mustache) {
        return Mustache.compiler().compile(TemplateHolder.getReader(mustache));
    }

    public TemplateHolder(JSONObject configuration) {
        JSONObject search = configuration.optJSONObject("search");
        String searchString = search.getString("template");
        Template searchTemplate = Mustache.compiler().escapeHTML(false).standardsMode(true).withLoader(s -> TemplateHolder.getReader(searchString)).compile(TemplateHolder.getReader(searchString));
        Template searchUrlTemplate = TemplateHolder.createTemplate(search.optString("url", ""));
        String searchMethod = search.optString("method", "POST");
        String field = null;
        if (searchMethod.toUpperCase().equals("GET")) {
            field = search.optString("field");
        }
        this.search = new TemplateRequest(searchMethod, searchUrlTemplate, searchTemplate, field);
        JSONObject add = configuration.optJSONObject("add");
        JSONObject delete = configuration.optJSONObject("delete");
        if (add != null) {
            this.add = new TemplateRequest(add.optString("method", "POST"), TemplateHolder.createTemplate(add.optString("url")), TemplateHolder.createTemplate(add.optString("template")));
            JSONObject bulk = add.optJSONObject("bulk");
            JSONObject commit = add.optJSONObject("commit");
            if (commit != null) {
                this.commit = new TemplateRequest(commit.optString("method", "GET"), TemplateHolder.createTemplate(commit.optString("url")), TemplateHolder.createTemplate(commit.optString("template")));
            }
            if (bulk != null) {
                Template bulkUrlTemplate = TemplateHolder.createTemplate(bulk.optString("url"));
                Template bulkTemplate = Mustache.compiler().escapeHTML(false).standardsMode(true).withLoader(s -> TemplateHolder.getReader(add.optString("template"))).compile(TemplateHolder.getReader(bulk.optString("template")));
                this.bulk = new TemplateRequest(bulk.optString("method", "POST"), bulkUrlTemplate, bulkTemplate);
            }
        }
        if (delete != null) {
            this.delete = new TemplateRequest(delete.optString("method", "DELETE"), TemplateHolder.createTemplate(delete.optString("url")), TemplateHolder.createTemplate(delete.optString("body")));
        }
    }

    public TemplateRequest getSearch() {
        return this.search;
    }

    public TemplateRequest getAdd() {
        return this.add;
    }

    public TemplateRequest getDelete() {
        return this.delete;
    }

    public TemplateRequest getCommit() {
        return this.commit;
    }

    public TemplateRequest getBulk() {
        return this.bulk;
    }

    public boolean isBulk() {
        return this.bulk != null;
    }

    public boolean isAdd() {
        return this.add != null;
    }

    public boolean isCommit() {
        return this.commit != null;
    }

    public boolean isDelete() {
        return this.delete != null;
    }
}

