/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.rest.util;

import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.request.BaseRequest;
import com.mashape.unirest.request.GetRequest;
import com.mashape.unirest.request.HttpRequestWithBody;
import com.samskivert.mustache.Template;
import java.util.Map;

public class TemplateRequest {
    protected String method;
    protected Template urlTemplate;
    protected Template bodyTemplate;
    protected String field;

    public TemplateRequest(String method, Template urlTemplate, Template bodyTemplate) {
        this(method, urlTemplate, bodyTemplate, null);
    }

    public TemplateRequest(String method, Template urlTemplate, Template bodyTemplate, String field) {
        this.method = method;
        this.urlTemplate = urlTemplate;
        this.bodyTemplate = bodyTemplate;
        this.field = field;
    }

    public BaseRequest execute(String baseUrl, Object urlMap, Object bodyMap) {
        switch (this.method.toUpperCase()) {
            case "GET": {
                return this.executeGet(baseUrl, urlMap, bodyMap);
            }
            case "POST": {
                return this.executePost(baseUrl, urlMap, bodyMap);
            }
            case "PUT": {
                return this.executePut(baseUrl, urlMap, bodyMap);
            }
            case "PATCH": {
                return this.executePatch(baseUrl, urlMap, bodyMap);
            }
            case "DELETE": {
                return this.executeDelete(baseUrl, urlMap, bodyMap);
            }
        }
        throw new RuntimeException("Method: " + this.method + " not supported");
    }

    public boolean exists() {
        return this.urlTemplate != null;
    }

    private BaseRequest executeDelete(String baseUrl, Object urlMap, Object bodyMap) {
        HttpRequestWithBody delete = Unirest.delete((String)(baseUrl + this.urlTemplate.execute(urlMap)));
        if (this.bodyTemplate != null) {
            return delete.body(this.bodyTemplate.execute(bodyMap));
        }
        return delete;
    }

    private BaseRequest executePatch(String baseUrl, Object urlMap, Object bodyMap) {
        return Unirest.patch((String)(baseUrl + this.urlTemplate.execute(urlMap))).body(this.bodyTemplate.execute(bodyMap));
    }

    private BaseRequest executePut(String baseUrl, Object urlMap, Object bodyMap) {
        return Unirest.put((String)(baseUrl + this.urlTemplate.execute(urlMap))).header("Content-type", "application/json").body(this.bodyTemplate.execute(bodyMap));
    }

    private BaseRequest executePost(String baseUrl, Object urlMap, Object bodyMap) {
        return Unirest.post((String)(baseUrl + this.urlTemplate.execute(urlMap))).body(this.bodyTemplate.execute(bodyMap));
    }

    private BaseRequest executeGet(String baseUrl, Object urlMap, Object bodyMap) {
        GetRequest getRequest = Unirest.get((String)(baseUrl + this.urlTemplate.execute(urlMap)));
        Map map = (Map)bodyMap;
        if (this.field == null || !map.containsKey("predicates")) {
            return getRequest;
        }
        return getRequest.queryString(this.field, (Object)this.bodyTemplate.execute(bodyMap).replace("\n", "").replace("\r", "").replace("\t", ""));
    }
}

