/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.rest.util.matchers;

import com.samskivert.mustache.Template;
import java.util.Map;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.json.JSONObject;
import org.unipop.rest.util.TemplateHolder;
import org.unipop.rest.util.matchers.Matcher;

public class KeyMatcher
implements Matcher {
    protected String key;
    protected Template template;

    public KeyMatcher(String key, Template template) {
        this.key = key;
        this.template = template;
    }

    @Override
    public boolean match(HasContainer hasContainer) {
        String[] split = hasContainer.getKey().split("\\.");
        return split[split.length - 1].equals(this.key);
    }

    @Override
    public String execute(HasContainer hasContainer) {
        Map<String, Object> stringObjectMap = this.toMap(hasContainer);
        return this.template.execute(stringObjectMap);
    }

    public static class KeyMatcherBuilder
    implements Matcher.MatcherBuilder {
        @Override
        public Matcher build(JSONObject object) {
            if (object.has("key")) {
                return new KeyMatcher(object.getString("key"), TemplateHolder.createTemplate(object.getString("template")));
            }
            return null;
        }
    }
}

