/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.imp;

import it.unive.lisa.imp.IMPFrontend;
import it.unive.lisa.imp.ParsingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import org.antlr.v4.runtime.FailedPredicateException;
import org.antlr.v4.runtime.InputMismatchException;
import org.antlr.v4.runtime.LexerNoViableAltException;
import org.antlr.v4.runtime.NoViableAltException;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.Vocabulary;
import org.antlr.v4.runtime.misc.IntervalSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Antlr4Util {
    private static final Logger log = LogManager.getLogger(IMPFrontend.class);

    static ParsingException handleRecognitionException(String file, RecognitionException e) {
        Token problem = e.getOffendingToken();
        StringBuilder message = Antlr4Util.errorHeader(file, problem);
        if (e instanceof InputMismatchException) {
            Antlr4Util.inputMismatch(e, problem, message);
        } else if (e instanceof FailedPredicateException) {
            Antlr4Util.failedPredicate(e, message);
        } else if (e instanceof NoViableAltException || e instanceof LexerNoViableAltException) {
            Antlr4Util.missingAlternative(message);
        } else {
            message.append("an unknown error occurred");
        }
        StringBuilder completeMessage = new StringBuilder(message.toString());
        Antlr4Util.dumpProblem(file, problem, completeMessage);
        log.error("Error while parsing " + file + ":\n" + completeMessage.toString());
        return new ParsingException("Error while parsing " + file + ":\n" + message.toString());
    }

    private static void dumpProblem(String file, Token problem, StringBuilder message) {
        String base = message.toString();
        message.append(" at: ");
        int begin = message.length();
        try {
            List<String> inputLines = Files.readAllLines(Paths.get(file, new String[0]));
            String errorLine = inputLines.get(problem.getLine() - 1);
            String trimmed = errorLine.trim();
            int offset = Math.max(0, errorLine.indexOf(trimmed));
            message.append(trimmed).append("\n");
            for (int i = 0; i < begin + problem.getCharPositionInLine() - offset; ++i) {
                message.append(" ");
            }
            message.append("^");
        }
        catch (IOException e) {
            message.delete(0, message.length());
            message.append(base);
        }
    }

    private static void missingAlternative(StringBuilder message) {
        message.append("could not decide what path to take");
    }

    private static void failedPredicate(RecognitionException e, StringBuilder message) {
        message.append("failed predicate '").append(((FailedPredicateException)e).getPredicate()).append("' ");
    }

    private static void inputMismatch(RecognitionException e, Token problem, StringBuilder message) {
        message.append("matched '").append(problem.getText()).append("' as <").append(Antlr4Util.tokenName(problem.getType(), e.getRecognizer().getVocabulary())).append(">, expecting <").append(Antlr4Util.tokenNames(((InputMismatchException)e).getExpectedTokens(), e.getRecognizer().getVocabulary())).append(">");
    }

    private static StringBuilder errorHeader(String file, Token problem) {
        return new StringBuilder().append(file).append(":").append(problem.getLine()).append(":").append(problem.getCharPositionInLine()).append(" - ");
    }

    private static String tokenName(int type, Vocabulary vocabulary) {
        return type < 0 ? "<EOF>" : vocabulary.getSymbolicName(type);
    }

    private static String tokenNames(IntervalSet types, Vocabulary vocabulary) {
        List typeList = types.toList();
        StringBuilder expectedBuilder = new StringBuilder();
        for (Integer t : typeList) {
            expectedBuilder.append(Antlr4Util.tokenName(t, vocabulary)).append(" ");
        }
        return expectedBuilder.toString().trim();
    }

    static int getLine(ParserRuleContext ctx) {
        return ctx.getStart().getLine();
    }

    static int getCol(ParserRuleContext ctx) {
        return ctx.getStop().getCharPositionInLine();
    }

    static int getLine(Token tok) {
        return tok.getLine();
    }

    static int getCol(Token tok) {
        return tok.getCharPositionInLine();
    }
}

