/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.imp;

import it.unive.lisa.imp.antlr.IMPParser;
import it.unive.lisa.imp.antlr.IMPParserBaseVisitor;
import it.unive.lisa.program.annotations.Annotation;
import it.unive.lisa.program.annotations.AnnotationMember;
import it.unive.lisa.program.annotations.Annotations;
import it.unive.lisa.program.annotations.values.AnnotationValue;
import it.unive.lisa.program.annotations.values.ArrayAnnotationValue;
import it.unive.lisa.program.annotations.values.BasicAnnotationValue;
import it.unive.lisa.program.annotations.values.BoolAnnotationValue;
import it.unive.lisa.program.annotations.values.CompilationUnitAnnotationValue;
import it.unive.lisa.program.annotations.values.FloatAnnotationValue;
import it.unive.lisa.program.annotations.values.IntAnnotationValue;
import it.unive.lisa.program.annotations.values.StringAnnotationValue;
import java.util.ArrayList;
import java.util.List;

public class IMPAnnotationVisitor
extends IMPParserBaseVisitor<Object> {
    @Override
    public Annotations visitAnnotations(IMPParser.AnnotationsContext ctx) {
        if (ctx == null) {
            return new Annotations();
        }
        ArrayList<Annotation> anns = new ArrayList<Annotation>();
        for (int i = 0; i < ctx.annotation().size(); ++i) {
            anns.add(this.visitAnnotation(ctx.annotation(i)));
        }
        return new Annotations(anns);
    }

    @Override
    public Annotation visitAnnotation(IMPParser.AnnotationContext ctx) {
        String annotationName = ctx.name.getText();
        if (annotationName.startsWith("Inherited")) {
            return new Annotation(annotationName, (List)this.visitAnnotationMembers(ctx.annotationMembers()), true);
        }
        return new Annotation(annotationName, (List)this.visitAnnotationMembers(ctx.annotationMembers()), false);
    }

    @Override
    public List<AnnotationMember> visitAnnotationMembers(IMPParser.AnnotationMembersContext ctx) {
        ArrayList<AnnotationMember> arr = new ArrayList<AnnotationMember>();
        if (ctx == null) {
            return arr;
        }
        for (int i = 0; i < ctx.annotationMember().size(); ++i) {
            arr.add(this.visitAnnotationMember(ctx.annotationMember(i)));
        }
        return arr;
    }

    @Override
    public AnnotationMember visitAnnotationMember(IMPParser.AnnotationMemberContext ctx) {
        return new AnnotationMember(ctx.IDENTIFIER().getText(), this.visitAnnotationValue(ctx.annotationValue()));
    }

    @Override
    public AnnotationValue visitAnnotationValue(IMPParser.AnnotationValueContext ctx) {
        if (ctx.basicAnnotationValue() != null) {
            return this.visitBasicAnnotationValue(ctx.basicAnnotationValue());
        }
        return this.visitArrayAnnotationValue(ctx.arrayAnnotationValue());
    }

    @Override
    public BasicAnnotationValue visitBasicAnnotationValue(IMPParser.BasicAnnotationValueContext ctx) {
        if (ctx.LITERAL_DECIMAL() != null) {
            if (ctx.SUB() != null) {
                return new IntAnnotationValue(Integer.parseInt(ctx.LITERAL_DECIMAL().getText()));
            }
            return new IntAnnotationValue(-Integer.parseInt(ctx.LITERAL_DECIMAL().getText()));
        }
        if (ctx.LITERAL_FLOAT() != null) {
            if (ctx.SUB() != null) {
                return new FloatAnnotationValue(Float.parseFloat(ctx.LITERAL_FLOAT().getText()));
            }
            return new FloatAnnotationValue(-Float.parseFloat(ctx.LITERAL_FLOAT().getText()));
        }
        if (ctx.LITERAL_BOOL() != null) {
            return new BoolAnnotationValue(Boolean.parseBoolean(ctx.LITERAL_BOOL().getText()));
        }
        if (ctx.LITERAL_STRING() != null) {
            return new StringAnnotationValue(ctx.LITERAL_STRING().getText());
        }
        if (ctx.unit_name != null) {
            return new CompilationUnitAnnotationValue(ctx.unit_name.getText());
        }
        throw new UnsupportedOperationException("Annotation value not supported: " + ctx);
    }

    @Override
    public ArrayAnnotationValue visitArrayAnnotationValue(IMPParser.ArrayAnnotationValueContext ctx) {
        if (ctx.basicAnnotationValue() == null) {
            return new ArrayAnnotationValue(new BasicAnnotationValue[0]);
        }
        BasicAnnotationValue[] arr = new BasicAnnotationValue[ctx.basicAnnotationValue().size()];
        for (int i = 0; i < ctx.basicAnnotationValue().size(); ++i) {
            arr[i] = this.visitBasicAnnotationValue(ctx.basicAnnotationValue(i));
        }
        return new ArrayAnnotationValue(arr);
    }
}

