/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.imp;

import it.unive.lisa.imp.Antlr4Util;
import it.unive.lisa.imp.IMPAnnotationVisitor;
import it.unive.lisa.imp.IMPFrontend;
import it.unive.lisa.imp.IMPSyntaxException;
import it.unive.lisa.imp.antlr.IMPParser;
import it.unive.lisa.imp.antlr.IMPParserBaseVisitor;
import it.unive.lisa.imp.constructs.StringConcat;
import it.unive.lisa.imp.constructs.StringContains;
import it.unive.lisa.imp.constructs.StringEndsWith;
import it.unive.lisa.imp.constructs.StringEquals;
import it.unive.lisa.imp.constructs.StringIndexOf;
import it.unive.lisa.imp.constructs.StringLength;
import it.unive.lisa.imp.constructs.StringReplace;
import it.unive.lisa.imp.constructs.StringStartsWith;
import it.unive.lisa.imp.constructs.StringSubstring;
import it.unive.lisa.imp.expressions.IMPAddOrConcat;
import it.unive.lisa.imp.expressions.IMPArrayAccess;
import it.unive.lisa.imp.expressions.IMPAssert;
import it.unive.lisa.imp.expressions.IMPNewArray;
import it.unive.lisa.imp.expressions.IMPNewObj;
import it.unive.lisa.imp.types.ClassType;
import it.unive.lisa.program.Global;
import it.unive.lisa.program.SourceCodeLocation;
import it.unive.lisa.program.annotations.Annotations;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CFGDescriptor;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.VariableTableEntry;
import it.unive.lisa.program.cfg.controlFlow.ControlFlowStructure;
import it.unive.lisa.program.cfg.controlFlow.IfThenElse;
import it.unive.lisa.program.cfg.controlFlow.Loop;
import it.unive.lisa.program.cfg.edge.Edge;
import it.unive.lisa.program.cfg.edge.FalseEdge;
import it.unive.lisa.program.cfg.edge.SequentialEdge;
import it.unive.lisa.program.cfg.edge.TrueEdge;
import it.unive.lisa.program.cfg.statement.Assignment;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.NoOp;
import it.unive.lisa.program.cfg.statement.PluggableStatement;
import it.unive.lisa.program.cfg.statement.Ret;
import it.unive.lisa.program.cfg.statement.Return;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.program.cfg.statement.Throw;
import it.unive.lisa.program.cfg.statement.VariableRef;
import it.unive.lisa.program.cfg.statement.call.Call;
import it.unive.lisa.program.cfg.statement.call.UnresolvedCall;
import it.unive.lisa.program.cfg.statement.comparison.Equal;
import it.unive.lisa.program.cfg.statement.comparison.GreaterOrEqual;
import it.unive.lisa.program.cfg.statement.comparison.GreaterThan;
import it.unive.lisa.program.cfg.statement.comparison.LessOrEqual;
import it.unive.lisa.program.cfg.statement.comparison.LessThan;
import it.unive.lisa.program.cfg.statement.comparison.NotEqual;
import it.unive.lisa.program.cfg.statement.global.AccessInstanceGlobal;
import it.unive.lisa.program.cfg.statement.literal.FalseLiteral;
import it.unive.lisa.program.cfg.statement.literal.Float32Literal;
import it.unive.lisa.program.cfg.statement.literal.Int32Literal;
import it.unive.lisa.program.cfg.statement.literal.Literal;
import it.unive.lisa.program.cfg.statement.literal.NullLiteral;
import it.unive.lisa.program.cfg.statement.literal.StringLiteral;
import it.unive.lisa.program.cfg.statement.literal.TrueLiteral;
import it.unive.lisa.program.cfg.statement.logic.And;
import it.unive.lisa.program.cfg.statement.logic.Not;
import it.unive.lisa.program.cfg.statement.logic.Or;
import it.unive.lisa.program.cfg.statement.numeric.Division;
import it.unive.lisa.program.cfg.statement.numeric.Multiplication;
import it.unive.lisa.program.cfg.statement.numeric.Negation;
import it.unive.lisa.program.cfg.statement.numeric.Remainder;
import it.unive.lisa.program.cfg.statement.numeric.Subtraction;
import it.unive.lisa.type.Type;
import it.unive.lisa.type.Untyped;
import it.unive.lisa.type.common.BoolType;
import it.unive.lisa.type.common.Float32;
import it.unive.lisa.type.common.Int32;
import it.unive.lisa.util.datastructures.graph.AdjacencyMatrix;
import it.unive.lisa.util.datastructures.graph.Node;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

class IMPCodeMemberVisitor
extends IMPParserBaseVisitor<Object> {
    private final String file;
    private final AdjacencyMatrix<Statement, Edge, CFG> matrix;
    private final Collection<Statement> entrypoints;
    private final Collection<ControlFlowStructure> cfs;
    private final Map<String, Pair<VariableRef, Annotations>> visibleIds;
    private final CFG cfg;
    private final CFGDescriptor descriptor;

    IMPCodeMemberVisitor(String file, CFGDescriptor descriptor) {
        this.file = file;
        this.descriptor = descriptor;
        this.matrix = new AdjacencyMatrix();
        this.entrypoints = new HashSet<Statement>();
        this.cfs = new LinkedList<ControlFlowStructure>();
        this.cfg = new CFG(descriptor, this.entrypoints, this.matrix);
        this.visibleIds = new HashMap<String, Pair<VariableRef, Annotations>>();
        for (VariableTableEntry par : descriptor.getVariables()) {
            this.visibleIds.put(par.getName(), (Pair<VariableRef, Annotations>)Pair.of((Object)par.createReference(this.cfg), (Object)par.getAnnotations()));
        }
    }

    CFG visitCodeMember(IMPParser.BlockContext ctx) {
        Triple<Statement, AdjacencyMatrix<Statement, Edge, CFG>, Statement> visited = this.visitBlock(ctx);
        this.entrypoints.add((Statement)visited.getLeft());
        this.matrix.mergeWith((AdjacencyMatrix)visited.getMiddle());
        this.cfs.forEach(cf -> this.cfg.addControlFlowStructure(cf));
        if (this.cfg.getAllExitpoints().isEmpty()) {
            Ret ret = new Ret(this.cfg, this.descriptor.getLocation());
            if (this.cfg.getNodesCount() == 0) {
                this.matrix.addNode((Node)ret);
                this.entrypoints.add((Statement)ret);
            } else {
                LinkedList<Statement> preExits = new LinkedList<Statement>();
                for (Statement st : this.matrix.getNodes()) {
                    if (st.stopsExecution() || !this.matrix.followersOf((Node)st).isEmpty()) continue;
                    preExits.add(st);
                }
                this.matrix.addNode((Node)ret);
                for (Statement st : preExits) {
                    this.matrix.addEdge((it.unive.lisa.util.datastructures.graph.Edge)new SequentialEdge(st, (Statement)ret));
                }
                for (VariableTableEntry entry : this.descriptor.getVariables()) {
                    if (!preExits.contains(entry.getScopeEnd())) continue;
                    entry.setScopeEnd((Statement)ret);
                }
            }
        }
        this.cfg.simplify();
        return this.cfg;
    }

    @Override
    public Triple<Statement, AdjacencyMatrix<Statement, Edge, CFG>, Statement> visitBlock(IMPParser.BlockContext ctx) {
        HashMap<String, Pair<VariableRef, Annotations>> backup = new HashMap<String, Pair<VariableRef, Annotations>>(this.visibleIds);
        AdjacencyMatrix block = new AdjacencyMatrix();
        Statement first = null;
        Statement last = null;
        for (int i = 0; i < ctx.blockOrStatement().size(); ++i) {
            Triple<Statement, AdjacencyMatrix<Statement, Edge, CFG>, Statement> st = this.visitBlockOrStatement(ctx.blockOrStatement(i));
            block.mergeWith((AdjacencyMatrix)st.getMiddle());
            if (first == null) {
                first = (Statement)st.getLeft();
            }
            if (last != null) {
                block.addEdge((it.unive.lisa.util.datastructures.graph.Edge)new SequentialEdge(last, (Statement)st.getLeft()));
            }
            last = (Statement)st.getRight();
        }
        HashSet<String> toRemove = new HashSet<String>();
        for (Map.Entry entry : this.visibleIds.entrySet()) {
            if (backup.containsKey(entry.getKey())) continue;
            VariableRef ref = (VariableRef)((Pair)entry.getValue()).getLeft();
            this.descriptor.addVariable(new VariableTableEntry(ref.getLocation(), 0, ref.getRootStatement(), last, (String)entry.getKey(), (Type)Untyped.INSTANCE, (Annotations)((Pair)entry.getValue()).getRight()));
            toRemove.add((String)entry.getKey());
        }
        if (!toRemove.isEmpty()) {
            toRemove.forEach(this.visibleIds::remove);
        }
        if (first == null && last == null) {
            NoOp instrumented = new NoOp(this.cfg, (CodeLocation)new SourceCodeLocation(this.file, Antlr4Util.getLine(ctx), Antlr4Util.getCol(ctx)));
            first = last = instrumented;
            block.addNode((Node)instrumented);
        }
        return Triple.of((Object)first, (Object)block, (Object)last);
    }

    @Override
    public Triple<Statement, AdjacencyMatrix<Statement, Edge, CFG>, Statement> visitBlockOrStatement(IMPParser.BlockOrStatementContext ctx) {
        if (ctx.statement() != null) {
            return this.visitStatement(ctx.statement());
        }
        return this.visitBlock(ctx.block());
    }

    @Override
    public Triple<Statement, AdjacencyMatrix<Statement, Edge, CFG>, Statement> visitStatement(IMPParser.StatementContext ctx) {
        Object st;
        if (ctx.localDeclaration() != null) {
            st = this.visitLocalDeclaration(ctx.localDeclaration());
        } else if (ctx.ASSERT() != null) {
            st = new IMPAssert(this.cfg, this.file, Antlr4Util.getLine(ctx), Antlr4Util.getCol(ctx), this.visitExpression(ctx.expression()));
        } else if (ctx.RETURN() != null) {
            st = ctx.expression() != null ? new Return(this.cfg, (CodeLocation)new SourceCodeLocation(this.file, Antlr4Util.getLine(ctx), Antlr4Util.getCol(ctx)), this.visitExpression(ctx.expression())) : new Ret(this.cfg, (CodeLocation)new SourceCodeLocation(this.file, Antlr4Util.getLine(ctx), Antlr4Util.getCol(ctx)));
        } else if (ctx.THROW() != null) {
            st = new Throw(this.cfg, (CodeLocation)new SourceCodeLocation(this.file, Antlr4Util.getLine(ctx), Antlr4Util.getCol(ctx)), this.visitExpression(ctx.expression()));
        } else if (ctx.skip != null) {
            st = new NoOp(this.cfg, (CodeLocation)new SourceCodeLocation(this.file, Antlr4Util.getLine(ctx), Antlr4Util.getCol(ctx)));
        } else {
            if (ctx.IF() != null) {
                return this.visitIf(ctx);
            }
            if (ctx.loop() != null) {
                return this.visitLoop(ctx.loop());
            }
            if (ctx.command != null) {
                st = this.visitExpression(ctx.command);
            } else {
                throw new IllegalArgumentException("Statement '" + ctx.toString() + "' cannot be parsed");
            }
        }
        AdjacencyMatrix adj = new AdjacencyMatrix();
        adj.addNode((Node)st);
        return Triple.of((Object)st, (Object)adj, (Object)st);
    }

    private Triple<Statement, AdjacencyMatrix<Statement, Edge, CFG>, Statement> visitIf(IMPParser.StatementContext ctx) {
        AdjacencyMatrix ite = new AdjacencyMatrix();
        Expression condition = this.visitParExpr(ctx.parExpr());
        ite.addNode((Node)condition);
        Triple<Statement, AdjacencyMatrix<Statement, Edge, CFG>, Statement> then = this.visitBlockOrStatement(ctx.then);
        ite.mergeWith((AdjacencyMatrix)then.getMiddle());
        ite.addEdge((it.unive.lisa.util.datastructures.graph.Edge)new TrueEdge((Statement)condition, (Statement)then.getLeft()));
        Triple<Statement, AdjacencyMatrix<Statement, Edge, CFG>, Statement> otherwise = null;
        if (ctx.otherwise != null) {
            otherwise = this.visitBlockOrStatement(ctx.otherwise);
            ite.mergeWith((AdjacencyMatrix)otherwise.getMiddle());
            ite.addEdge((it.unive.lisa.util.datastructures.graph.Edge)new FalseEdge((Statement)condition, (Statement)otherwise.getLeft()));
        }
        NoOp noop = new NoOp(this.cfg, condition.getLocation());
        ite.addNode((Node)noop);
        ite.addEdge((it.unive.lisa.util.datastructures.graph.Edge)new SequentialEdge((Statement)then.getRight(), (Statement)noop));
        if (otherwise != null) {
            ite.addEdge((it.unive.lisa.util.datastructures.graph.Edge)new SequentialEdge((Statement)otherwise.getRight(), (Statement)noop));
        } else {
            ite.addEdge((it.unive.lisa.util.datastructures.graph.Edge)new FalseEdge((Statement)condition, (Statement)noop));
        }
        this.cfs.add((ControlFlowStructure)new IfThenElse(this.matrix, (Statement)condition, (Statement)noop, ((AdjacencyMatrix)then.getMiddle()).getNodes(), otherwise == null ? Collections.emptyList() : ((AdjacencyMatrix)otherwise.getMiddle()).getNodes()));
        return Triple.of((Object)condition, (Object)ite, (Object)noop);
    }

    @Override
    public Expression visitParExpr(IMPParser.ParExprContext ctx) {
        return this.visitExpression(ctx.expression());
    }

    @Override
    public Assignment visitLocalDeclaration(IMPParser.LocalDeclarationContext ctx) {
        Expression expression = this.visitExpression(ctx.expression());
        VariableRef ref = this.visitVar(ctx.IDENTIFIER(), false);
        if (this.visibleIds.containsKey(ref.getName())) {
            throw new IMPSyntaxException("Duplicate variable '" + ref.getName() + "' declared at " + ref.getLocation());
        }
        this.visibleIds.put(ref.getName(), (Pair<VariableRef, Annotations>)Pair.of((Object)ref, (Object)new IMPAnnotationVisitor().visitAnnotations(ctx.annotations())));
        return new Assignment(this.cfg, (CodeLocation)new SourceCodeLocation(this.file, Antlr4Util.getLine(ctx), Antlr4Util.getCol(ctx)), (Expression)ref, expression);
    }

    @Override
    public Triple<Statement, AdjacencyMatrix<Statement, Edge, CFG>, Statement> visitLoop(IMPParser.LoopContext ctx) {
        if (ctx.whileLoop() != null) {
            return this.visitWhileLoop(ctx.whileLoop());
        }
        return this.visitForLoop(ctx.forLoop());
    }

    @Override
    public Triple<Statement, AdjacencyMatrix<Statement, Edge, CFG>, Statement> visitWhileLoop(IMPParser.WhileLoopContext ctx) {
        AdjacencyMatrix loop = new AdjacencyMatrix();
        Expression condition = this.visitParExpr(ctx.parExpr());
        loop.addNode((Node)condition);
        Triple<Statement, AdjacencyMatrix<Statement, Edge, CFG>, Statement> body = this.visitBlockOrStatement(ctx.blockOrStatement());
        loop.mergeWith((AdjacencyMatrix)body.getMiddle());
        loop.addEdge((it.unive.lisa.util.datastructures.graph.Edge)new TrueEdge((Statement)condition, (Statement)body.getLeft()));
        loop.addEdge((it.unive.lisa.util.datastructures.graph.Edge)new SequentialEdge((Statement)body.getRight(), (Statement)condition));
        NoOp noop = new NoOp(this.cfg, condition.getLocation());
        loop.addNode((Node)noop);
        loop.addEdge((it.unive.lisa.util.datastructures.graph.Edge)new FalseEdge((Statement)condition, (Statement)noop));
        this.cfs.add((ControlFlowStructure)new Loop(this.matrix, (Statement)condition, (Statement)noop, ((AdjacencyMatrix)body.getMiddle()).getNodes()));
        return Triple.of((Object)condition, (Object)loop, (Object)noop);
    }

    @Override
    public Triple<Statement, AdjacencyMatrix<Statement, Edge, CFG>, Statement> visitForLoop(IMPParser.ForLoopContext ctx) {
        Assignment init;
        AdjacencyMatrix loop = new AdjacencyMatrix();
        IMPParser.LocalDeclarationContext initDecl = ctx.forDeclaration().initDecl;
        IMPParser.ExpressionContext initExpr = ctx.forDeclaration().initExpr;
        IMPParser.ExpressionContext cond = ctx.forDeclaration().condition;
        IMPParser.ExpressionContext post = ctx.forDeclaration().post;
        Assignment first = null;
        Statement last = null;
        if (initDecl != null) {
            init = this.visitLocalDeclaration(initDecl);
            loop.addNode((Node)init);
            first = init;
        } else if (initExpr != null) {
            init = this.visitExpression(initExpr);
            loop.addNode((Node)init);
            first = init;
        }
        Object condition = cond != null ? this.visitExpression(cond) : new TrueLiteral(this.cfg, (CodeLocation)new SourceCodeLocation(this.file, Antlr4Util.getLine(ctx), Antlr4Util.getCol(ctx)));
        loop.addNode((Node)condition);
        if (first == null) {
            first = condition;
        } else {
            loop.addEdge((it.unive.lisa.util.datastructures.graph.Edge)new SequentialEdge((Statement)first, (Statement)condition));
        }
        Triple<Statement, AdjacencyMatrix<Statement, Edge, CFG>, Statement> body = this.visitBlockOrStatement(ctx.blockOrStatement());
        loop.mergeWith((AdjacencyMatrix)body.getMiddle());
        loop.addEdge((it.unive.lisa.util.datastructures.graph.Edge)new TrueEdge((Statement)condition, (Statement)body.getLeft()));
        last = (Statement)body.getRight();
        if (post != null) {
            Expression inc = this.visitExpression(post);
            loop.addNode((Node)inc);
            loop.addEdge((it.unive.lisa.util.datastructures.graph.Edge)new SequentialEdge((Statement)body.getRight(), (Statement)inc));
            last = inc;
        }
        loop.addEdge((it.unive.lisa.util.datastructures.graph.Edge)new SequentialEdge(last, (Statement)condition));
        NoOp noop = new NoOp(this.cfg, condition.getLocation());
        loop.addNode((Node)noop);
        loop.addEdge((it.unive.lisa.util.datastructures.graph.Edge)new FalseEdge((Statement)condition, (Statement)noop));
        if (post == null) {
            this.cfs.add((ControlFlowStructure)new Loop(this.matrix, (Statement)condition, (Statement)noop, ((AdjacencyMatrix)body.getMiddle()).getNodes()));
        } else {
            AdjacencyMatrix tmp = new AdjacencyMatrix((AdjacencyMatrix)body.getMiddle());
            tmp.addNode((Node)last);
            loop.addEdge((it.unive.lisa.util.datastructures.graph.Edge)new SequentialEdge((Statement)body.getRight(), last));
            this.cfs.add((ControlFlowStructure)new Loop(this.matrix, (Statement)condition, (Statement)noop, tmp.getNodes()));
        }
        return Triple.of((Object)first, (Object)loop, (Object)noop);
    }

    @Override
    public Assignment visitAssignment(IMPParser.AssignmentContext ctx) {
        Expression expression = this.visitExpression(ctx.expression());
        Object target = null;
        if (ctx.IDENTIFIER() != null) {
            target = this.visitVar(ctx.IDENTIFIER(), true);
        } else if (ctx.fieldAccess() != null) {
            target = this.visitFieldAccess(ctx.fieldAccess());
        } else if (ctx.arrayAccess() != null) {
            target = this.visitArrayAccess(ctx.arrayAccess());
        } else {
            throw new IMPSyntaxException("Target of the assignment at " + expression.getLocation() + " is neither an identifier, a field access or an array access");
        }
        return new Assignment(this.cfg, (CodeLocation)new SourceCodeLocation(this.file, Antlr4Util.getLine(ctx), Antlr4Util.getCol(ctx)), (Expression)target, expression);
    }

    private VariableRef visitVar(TerminalNode identifier, boolean localReference) {
        VariableRef ref = new VariableRef(this.cfg, (CodeLocation)new SourceCodeLocation(this.file, Antlr4Util.getLine(identifier.getSymbol()), Antlr4Util.getCol(identifier.getSymbol())), identifier.getText(), (Type)Untyped.INSTANCE);
        if (localReference && !this.visibleIds.containsKey(ref.getName())) {
            throw new IMPSyntaxException("Referencing undeclared variable '" + ref.getName() + "' at " + ref.getLocation());
        }
        return ref;
    }

    @Override
    public AccessInstanceGlobal visitFieldAccess(IMPParser.FieldAccessContext ctx) {
        Expression receiver = this.visitReceiver(ctx.receiver());
        Global id = new Global((CodeLocation)new SourceCodeLocation(this.file, Antlr4Util.getLine(ctx.name), Antlr4Util.getCol(ctx.name)), ctx.name.getText(), (Type)Untyped.INSTANCE);
        return new AccessInstanceGlobal(this.cfg, (CodeLocation)new SourceCodeLocation(this.file, Antlr4Util.getLine(ctx), Antlr4Util.getCol(ctx)), receiver, id);
    }

    @Override
    public Expression visitReceiver(IMPParser.ReceiverContext ctx) {
        if (ctx.THIS() != null) {
            return this.visitVar(ctx.THIS(), false);
        }
        if (ctx.SUPER() != null) {
            return this.visitVar(ctx.SUPER(), false);
        }
        return this.visitVar(ctx.IDENTIFIER(), true);
    }

    @Override
    public IMPArrayAccess visitArrayAccess(IMPParser.ArrayAccessContext ctx) {
        Expression receiver;
        Object result = receiver = this.visitReceiver(ctx.receiver());
        for (IMPParser.IndexContext i : ctx.index()) {
            result = new IMPArrayAccess(this.cfg, this.file, Antlr4Util.getLine(i), Antlr4Util.getCol(i), (Expression)result, this.visitIndex(i));
        }
        return (IMPArrayAccess)((Object)result);
    }

    @Override
    public Expression visitIndex(IMPParser.IndexContext ctx) {
        if (ctx.IDENTIFIER() != null) {
            return this.visitVar(ctx.IDENTIFIER(), true);
        }
        return new Int32Literal(this.cfg, (CodeLocation)new SourceCodeLocation(this.file, Antlr4Util.getLine(ctx), Antlr4Util.getCol(ctx)), Integer.parseInt(ctx.LITERAL_DECIMAL().getText()));
    }

    @Override
    public Expression visitExpression(IMPParser.ExpressionContext ctx) {
        int line = Antlr4Util.getLine(ctx);
        int col = Antlr4Util.getCol(ctx);
        if (ctx.paren != null) {
            return this.visitExpression(ctx.paren);
        }
        if (ctx.assignment() != null) {
            return this.visitAssignment(ctx.assignment());
        }
        if (ctx.basicExpr() != null) {
            return this.visitBasicExpr(ctx.basicExpr());
        }
        if (ctx.nested != null) {
            if (ctx.NOT() != null) {
                return new Not(this.cfg, (CodeLocation)new SourceCodeLocation(this.file, line, col), this.visitExpression(ctx.nested));
            }
            return new Negation(this.cfg, (CodeLocation)new SourceCodeLocation(this.file, line, col), this.visitExpression(ctx.nested));
        }
        if (ctx.left != null && ctx.right != null) {
            if (ctx.MUL() != null) {
                return new Multiplication(this.cfg, (CodeLocation)new SourceCodeLocation(this.file, line, col), this.visitExpression(ctx.left), this.visitExpression(ctx.right));
            }
            if (ctx.DIV() != null) {
                return new Division(this.cfg, (CodeLocation)new SourceCodeLocation(this.file, line, col), this.visitExpression(ctx.left), this.visitExpression(ctx.right));
            }
            if (ctx.MOD() != null) {
                return new Remainder(this.cfg, (CodeLocation)new SourceCodeLocation(this.file, line, col), this.visitExpression(ctx.left), this.visitExpression(ctx.right));
            }
            if (ctx.ADD() != null) {
                return new IMPAddOrConcat(this.cfg, this.file, line, col, this.visitExpression(ctx.left), this.visitExpression(ctx.right));
            }
            if (ctx.SUB() != null) {
                return new Subtraction(this.cfg, (CodeLocation)new SourceCodeLocation(this.file, line, col), this.visitExpression(ctx.left), this.visitExpression(ctx.right));
            }
            if (ctx.GT() != null) {
                return new GreaterThan(this.cfg, (CodeLocation)new SourceCodeLocation(this.file, line, col), this.visitExpression(ctx.left), this.visitExpression(ctx.right));
            }
            if (ctx.GE() != null) {
                return new GreaterOrEqual(this.cfg, (CodeLocation)new SourceCodeLocation(this.file, line, col), this.visitExpression(ctx.left), this.visitExpression(ctx.right));
            }
            if (ctx.LT() != null) {
                return new LessThan(this.cfg, (CodeLocation)new SourceCodeLocation(this.file, line, col), this.visitExpression(ctx.left), this.visitExpression(ctx.right));
            }
            if (ctx.LE() != null) {
                return new LessOrEqual(this.cfg, (CodeLocation)new SourceCodeLocation(this.file, line, col), this.visitExpression(ctx.left), this.visitExpression(ctx.right));
            }
            if (ctx.EQUAL() != null) {
                return new Equal(this.cfg, (CodeLocation)new SourceCodeLocation(this.file, line, col), this.visitExpression(ctx.left), this.visitExpression(ctx.right));
            }
            if (ctx.NOTEQUAL() != null) {
                return new NotEqual(this.cfg, (CodeLocation)new SourceCodeLocation(this.file, line, col), this.visitExpression(ctx.left), this.visitExpression(ctx.right));
            }
            if (ctx.AND() != null) {
                return new And(this.cfg, (CodeLocation)new SourceCodeLocation(this.file, line, col), this.visitExpression(ctx.left), this.visitExpression(ctx.right));
            }
            return new Or(this.cfg, (CodeLocation)new SourceCodeLocation(this.file, line, col), this.visitExpression(ctx.left), this.visitExpression(ctx.right));
        }
        if (ctx.NEW() != null) {
            if (ctx.newBasicArrayExpr() != null) {
                return this.visitNewBasicArrayExpr(ctx.newBasicArrayExpr());
            }
            return this.visitNewReferenceType(ctx.newReferenceType());
        }
        if (ctx.arrayAccess() != null) {
            return this.visitArrayAccess(ctx.arrayAccess());
        }
        if (ctx.fieldAccess() != null) {
            return this.visitFieldAccess(ctx.fieldAccess());
        }
        if (ctx.methodCall() != null) {
            return this.visitMethodCall(ctx.methodCall());
        }
        if (ctx.stringExpr() != null) {
            return this.visitStringExpr(ctx.stringExpr());
        }
        throw new UnsupportedOperationException("Type of expression not supported: " + ctx);
    }

    @Override
    public Expression visitStringExpr(IMPParser.StringExprContext ctx) {
        Expression returned = null;
        if (ctx.unaryStringExpr() != null) {
            returned = this.visitUnaryStringExpr(ctx.unaryStringExpr());
        } else if (ctx.binaryStringExpr() != null) {
            returned = this.visitBinaryStringExpr(ctx.binaryStringExpr());
        } else if (ctx.ternaryStringExpr() != null) {
            returned = this.visitTernaryStringExpr(ctx.ternaryStringExpr());
        } else {
            throw new UnsupportedOperationException("Type of string expression not supported: " + ctx);
        }
        if (returned instanceof PluggableStatement) {
            ((PluggableStatement)returned).setOriginatingStatement((Statement)returned);
        }
        return returned;
    }

    @Override
    public Expression visitUnaryStringExpr(IMPParser.UnaryStringExprContext ctx) {
        if (ctx.STRLEN() != null) {
            return new StringLength.IMPStringLength(this.cfg, this.file, Antlr4Util.getLine(ctx), Antlr4Util.getCol(ctx), this.visitExpression(ctx.op));
        }
        throw new UnsupportedOperationException("Type of string expression not supported: " + ctx);
    }

    @Override
    public Expression visitBinaryStringExpr(IMPParser.BinaryStringExprContext ctx) {
        if (ctx.STRCAT() != null) {
            return new StringConcat.IMPStringConcat(this.cfg, this.file, Antlr4Util.getLine(ctx), Antlr4Util.getCol(ctx), this.visitExpression(ctx.left), this.visitExpression(ctx.right));
        }
        if (ctx.STRCONTAINS() != null) {
            return new StringContains.IMPStringContains(this.cfg, this.file, Antlr4Util.getLine(ctx), Antlr4Util.getCol(ctx), this.visitExpression(ctx.left), this.visitExpression(ctx.right));
        }
        if (ctx.STRENDS() != null) {
            return new StringEndsWith.IMPStringEndsWith(this.cfg, this.file, Antlr4Util.getLine(ctx), Antlr4Util.getCol(ctx), this.visitExpression(ctx.left), this.visitExpression(ctx.right));
        }
        if (ctx.STREQ() != null) {
            return new StringEquals.IMPStringEquals(this.cfg, this.file, Antlr4Util.getLine(ctx), Antlr4Util.getCol(ctx), this.visitExpression(ctx.left), this.visitExpression(ctx.right));
        }
        if (ctx.STRINDEXOF() != null) {
            return new StringIndexOf.IMPStringIndexOf(this.cfg, this.file, Antlr4Util.getLine(ctx), Antlr4Util.getCol(ctx), this.visitExpression(ctx.left), this.visitExpression(ctx.right));
        }
        if (ctx.STRSTARTS() != null) {
            return new StringStartsWith.IMPStringStartsWith(this.cfg, this.file, Antlr4Util.getLine(ctx), Antlr4Util.getCol(ctx), this.visitExpression(ctx.left), this.visitExpression(ctx.right));
        }
        throw new UnsupportedOperationException("Type of string expression not supported: " + ctx);
    }

    @Override
    public Expression visitTernaryStringExpr(IMPParser.TernaryStringExprContext ctx) {
        if (ctx.STRREPLACE() != null) {
            return new StringReplace.IMPStringReplace(this.cfg, this.file, Antlr4Util.getLine(ctx), Antlr4Util.getCol(ctx), this.visitExpression(ctx.left), this.visitExpression(ctx.middle), this.visitExpression(ctx.right));
        }
        if (ctx.STRSUB() != null) {
            return new StringSubstring.IMPStringSubstring(this.cfg, this.file, Antlr4Util.getLine(ctx), Antlr4Util.getCol(ctx), this.visitExpression(ctx.left), this.visitExpression(ctx.middle), this.visitExpression(ctx.right));
        }
        throw new UnsupportedOperationException("Type of string expression not supported: " + ctx);
    }

    @Override
    public Expression visitNewBasicArrayExpr(IMPParser.NewBasicArrayExprContext ctx) {
        return new IMPNewArray(this.cfg, this.file, Antlr4Util.getLine(ctx), Antlr4Util.getCol(ctx), this.visitPrimitiveType(ctx.primitiveType()), this.visitArrayCreatorRest(ctx.arrayCreatorRest()));
    }

    @Override
    public Expression[] visitArrayCreatorRest(IMPParser.ArrayCreatorRestContext ctx) {
        Expression[] result = new Expression[ctx.index().size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.visitIndex(ctx.index(i));
        }
        return result;
    }

    @Override
    public Type visitPrimitiveType(IMPParser.PrimitiveTypeContext ctx) {
        if (ctx.BOOLEAN() != null) {
            return BoolType.INSTANCE;
        }
        if (ctx.INT() != null) {
            return Int32.INSTANCE;
        }
        return Float32.INSTANCE;
    }

    @Override
    public Expression visitNewReferenceType(IMPParser.NewReferenceTypeContext ctx) {
        ClassType base = ClassType.lookup(ctx.IDENTIFIER().getText(), null);
        if (ctx.arrayCreatorRest() != null) {
            return new IMPNewArray(this.cfg, this.file, Antlr4Util.getLine(ctx), Antlr4Util.getCol(ctx), (Type)base, this.visitArrayCreatorRest(ctx.arrayCreatorRest()));
        }
        return new IMPNewObj(this.cfg, this.file, Antlr4Util.getLine(ctx), Antlr4Util.getCol(ctx), (Type)base, this.visitArguments(ctx.arguments()));
    }

    @Override
    public Expression[] visitArguments(IMPParser.ArgumentsContext ctx) {
        Expression[] args = new Expression[ctx.arg().size()];
        int i = 0;
        for (IMPParser.ArgContext arg : ctx.arg()) {
            args[i++] = this.visitArg(arg);
        }
        return args;
    }

    @Override
    public Expression visitArg(IMPParser.ArgContext ctx) {
        if (ctx.literal() != null) {
            return this.visitLiteral(ctx.literal());
        }
        if (ctx.fieldAccess() != null) {
            return this.visitFieldAccess(ctx.fieldAccess());
        }
        if (ctx.arrayAccess() != null) {
            return this.visitArrayAccess(ctx.arrayAccess());
        }
        if (ctx.methodCall() != null) {
            return this.visitMethodCall(ctx.methodCall());
        }
        if (ctx.IDENTIFIER() != null) {
            return this.visitVar(ctx.IDENTIFIER(), true);
        }
        return this.visitVar(ctx.THIS(), false);
    }

    @Override
    public Expression visitMethodCall(IMPParser.MethodCallContext ctx) {
        Expression receiver = this.visitReceiver(ctx.receiver());
        String name = ctx.name.getText();
        Expression[] args = (Expression[])ArrayUtils.insert((int)0, (Object[])this.visitArguments(ctx.arguments()), (Object[])new Expression[]{receiver});
        return new UnresolvedCall(this.cfg, (CodeLocation)new SourceCodeLocation(this.file, Antlr4Util.getLine(ctx), Antlr4Util.getCol(ctx)), IMPFrontend.ASSIGN_STRATEGY, IMPFrontend.MATCHING_STRATEGY, IMPFrontend.TRAVERSAL_STRATEGY, Call.CallType.INSTANCE, null, name, args);
    }

    @Override
    public Expression visitBasicExpr(IMPParser.BasicExprContext ctx) {
        if (ctx.literal() != null) {
            return this.visitLiteral(ctx.literal());
        }
        if (ctx.THIS() != null) {
            return this.visitVar(ctx.THIS(), false);
        }
        if (ctx.SUPER() != null) {
            return this.visitVar(ctx.SUPER(), false);
        }
        return this.visitVar(ctx.IDENTIFIER(), true);
    }

    @Override
    public Literal<?> visitLiteral(IMPParser.LiteralContext ctx) {
        int line = Antlr4Util.getLine(ctx);
        int col = Antlr4Util.getCol(ctx);
        if (ctx.LITERAL_NULL() != null) {
            return new NullLiteral(this.cfg, (CodeLocation)new SourceCodeLocation(this.file, line, col));
        }
        if (ctx.LITERAL_BOOL() != null) {
            if (ctx.LITERAL_BOOL().getText().equals("true")) {
                return new TrueLiteral(this.cfg, (CodeLocation)new SourceCodeLocation(this.file, line, col));
            }
            return new FalseLiteral(this.cfg, (CodeLocation)new SourceCodeLocation(this.file, line, col));
        }
        if (ctx.LITERAL_STRING() != null) {
            return new StringLiteral(this.cfg, (CodeLocation)new SourceCodeLocation(this.file, line, col), ctx.LITERAL_STRING().getText());
        }
        if (ctx.LITERAL_FLOAT() != null) {
            if (ctx.SUB() != null) {
                return new Float32Literal(this.cfg, (CodeLocation)new SourceCodeLocation(this.file, line, col), -Float.parseFloat(ctx.LITERAL_FLOAT().getText()));
            }
            return new Float32Literal(this.cfg, (CodeLocation)new SourceCodeLocation(this.file, line, col), Float.parseFloat(ctx.LITERAL_FLOAT().getText()));
        }
        if (ctx.LITERAL_DECIMAL() != null) {
            if (ctx.SUB() != null) {
                return new Int32Literal(this.cfg, (CodeLocation)new SourceCodeLocation(this.file, line, col), -Integer.parseInt(ctx.LITERAL_DECIMAL().getText()));
            }
            return new Int32Literal(this.cfg, (CodeLocation)new SourceCodeLocation(this.file, line, col), Integer.parseInt(ctx.LITERAL_DECIMAL().getText()));
        }
        throw new UnsupportedOperationException("Type of literal not supported: " + ctx);
    }
}

