/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.imp;

import it.unive.lisa.imp.Antlr4Util;
import it.unive.lisa.imp.IMPAnnotationVisitor;
import it.unive.lisa.imp.IMPCodeMemberVisitor;
import it.unive.lisa.imp.IMPSyntaxException;
import it.unive.lisa.imp.ParsingException;
import it.unive.lisa.imp.antlr.IMPLexer;
import it.unive.lisa.imp.antlr.IMPParser;
import it.unive.lisa.imp.antlr.IMPParserBaseVisitor;
import it.unive.lisa.imp.constructs.StringContains;
import it.unive.lisa.imp.constructs.StringEndsWith;
import it.unive.lisa.imp.constructs.StringEquals;
import it.unive.lisa.imp.constructs.StringIndexOf;
import it.unive.lisa.imp.constructs.StringLength;
import it.unive.lisa.imp.constructs.StringReplace;
import it.unive.lisa.imp.constructs.StringStartsWith;
import it.unive.lisa.imp.constructs.StringSubstring;
import it.unive.lisa.imp.types.ArrayType;
import it.unive.lisa.imp.types.ClassType;
import it.unive.lisa.program.CompilationUnit;
import it.unive.lisa.program.Global;
import it.unive.lisa.program.Program;
import it.unive.lisa.program.SourceCodeLocation;
import it.unive.lisa.program.Unit;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CFGDescriptor;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.NativeCFG;
import it.unive.lisa.program.cfg.Parameter;
import it.unive.lisa.program.cfg.statement.call.assignment.ParameterAssigningStrategy;
import it.unive.lisa.program.cfg.statement.call.assignment.PythonLikeAssigningStrategy;
import it.unive.lisa.program.cfg.statement.call.resolution.JavaLikeMatchingStrategy;
import it.unive.lisa.program.cfg.statement.call.resolution.ParameterMatchingStrategy;
import it.unive.lisa.program.cfg.statement.call.traversal.HierarcyTraversalStrategy;
import it.unive.lisa.program.cfg.statement.call.traversal.SingleInheritanceTraversalStrategy;
import it.unive.lisa.type.ReferenceType;
import it.unive.lisa.type.Type;
import it.unive.lisa.type.Untyped;
import it.unive.lisa.type.common.BoolType;
import it.unive.lisa.type.common.Float32;
import it.unive.lisa.type.common.Int32;
import it.unive.lisa.type.common.StringType;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IMPFrontend
extends IMPParserBaseVisitor<Object> {
    private static final Logger log = LogManager.getLogger(IMPFrontend.class);
    public static final ParameterMatchingStrategy MATCHING_STRATEGY = JavaLikeMatchingStrategy.INSTANCE;
    public static final HierarcyTraversalStrategy TRAVERSAL_STRATEGY = SingleInheritanceTraversalStrategy.INSTANCE;
    public static final ParameterAssigningStrategy ASSIGN_STRATEGY = PythonLikeAssigningStrategy.INSTANCE;
    private final String file;
    private final Map<String, Pair<CompilationUnit, String>> inheritanceMap;
    private final Program program;
    private CompilationUnit currentUnit;
    private final boolean onlyMain;

    public static Program processFile(String file) throws ParsingException {
        return new IMPFrontend(file, false).work(null);
    }

    public static Program processFile(String file, boolean onlyMain) throws ParsingException {
        return new IMPFrontend(file, onlyMain).work(null);
    }

    public static Program processText(String text) throws ParsingException {
        return IMPFrontend.processText(text, false);
    }

    public static Program processText(String text, boolean onlyMain) throws ParsingException {
        Program program;
        ByteArrayInputStream is = new ByteArrayInputStream(text.getBytes());
        try {
            program = new IMPFrontend("in-memory.imp", onlyMain).work(is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ParsingException("Exception while parsing the input text", e);
            }
        }
        ((InputStream)is).close();
        return program;
    }

    private IMPFrontend(String file, boolean onlyMain) {
        this.file = file;
        this.inheritanceMap = new HashMap<String, Pair<CompilationUnit, String>>();
        this.program = new Program();
        this.onlyMain = onlyMain;
    }

    private Program work(InputStream inputStream) throws ParsingException {
        ClassType.clearAll();
        ArrayType.clearAll();
        try {
            IMPLexer lexer;
            log.info("Reading file... " + this.file);
            if (inputStream == null) {
                try (FileInputStream stream = new FileInputStream(this.file);){
                    lexer = new IMPLexer(CharStreams.fromStream((InputStream)stream, (Charset)StandardCharsets.UTF_8));
                }
            } else {
                lexer = new IMPLexer(CharStreams.fromStream((InputStream)inputStream, (Charset)StandardCharsets.UTF_8));
            }
            IMPParser parser = new IMPParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
            parser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
            ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
            Program p = this.visitFile(parser.file());
            SourceCodeLocation unknownLocation = new SourceCodeLocation("imp-runtime", 0, 0);
            CompilationUnit str = new CompilationUnit((CodeLocation)unknownLocation, "string", true);
            str.addInstanceConstruct((NativeCFG)new StringContains((CodeLocation)unknownLocation, str));
            str.addInstanceConstruct((NativeCFG)new StringEndsWith((CodeLocation)unknownLocation, str));
            str.addInstanceConstruct((NativeCFG)new StringEquals((CodeLocation)unknownLocation, str));
            str.addInstanceConstruct((NativeCFG)new StringIndexOf((CodeLocation)unknownLocation, str));
            str.addInstanceConstruct((NativeCFG)new StringLength((CodeLocation)unknownLocation, str));
            str.addInstanceConstruct((NativeCFG)new StringReplace((CodeLocation)unknownLocation, str));
            str.addInstanceConstruct((NativeCFG)new StringStartsWith((CodeLocation)unknownLocation, str));
            str.addInstanceConstruct((NativeCFG)new StringSubstring((CodeLocation)unknownLocation, str));
            p.registerType((Type)BoolType.INSTANCE);
            p.registerType((Type)Float32.INSTANCE);
            p.registerType((Type)Int32.INSTANCE);
            p.registerType((Type)StringType.INSTANCE);
            ClassType.all().forEach(arg_0 -> ((Program)p).registerType(arg_0));
            ArrayType.all().forEach(arg_0 -> ((Program)p).registerType(arg_0));
            return p;
        }
        catch (FileNotFoundException e) {
            log.fatal(this.file + " does not exist", (Throwable)e);
            throw new ParsingException("Target file '" + this.file + "' does not exist", e);
        }
        catch (IOException e) {
            log.fatal("Unable to open " + this.file, (Throwable)e);
            throw new ParsingException("Unable to open " + this.file, e);
        }
        catch (IMPSyntaxException e) {
            log.fatal(this.file + " is not well-formed", (Throwable)e);
            throw new ParsingException("Incorrect IMP file: " + this.file, e);
        }
        catch (RecognitionException e) {
            throw Antlr4Util.handleRecognitionException(this.file, e);
        }
        catch (Exception e) {
            if (e.getCause() instanceof RecognitionException) {
                throw Antlr4Util.handleRecognitionException(this.file, (RecognitionException)e.getCause());
            }
            log.error("Parser thrown an exception while parsing " + this.file, (Throwable)e);
            throw new ParsingException("Parser thrown an exception while parsing " + this.file, e);
        }
    }

    @Override
    public Program visitFile(IMPParser.FileContext ctx) {
        for (IMPParser.UnitContext unitContext : ctx.unit()) {
            CompilationUnit u = new CompilationUnit((CodeLocation)new SourceCodeLocation(this.file, Antlr4Util.getLine(ctx), Antlr4Util.getCol(ctx)), unitContext.name.getText(), false);
            this.program.addCompilationUnit(u);
            ClassType.lookup(u.getName(), u);
        }
        for (IMPParser.UnitContext unitContext : ctx.unit()) {
            this.visitUnit(unitContext);
        }
        for (Pair pair : this.inheritanceMap.values()) {
            if (pair.getRight() == null) continue;
            ((CompilationUnit)pair.getLeft()).addSuperUnit((CompilationUnit)this.inheritanceMap.get(pair.getRight()).getLeft());
        }
        return this.program;
    }

    @Override
    public CompilationUnit visitUnit(IMPParser.UnitContext ctx) {
        this.currentUnit = this.program.getUnit(ctx.name.getText());
        if (ctx.superclass != null) {
            this.inheritanceMap.put(this.currentUnit.getName(), (Pair<CompilationUnit, String>)Pair.of((Object)this.currentUnit, (Object)ctx.superclass.getText()));
        } else {
            this.inheritanceMap.put(this.currentUnit.getName(), (Pair<CompilationUnit, String>)Pair.of((Object)this.currentUnit, null));
        }
        for (IMPParser.MethodDeclarationContext methodDeclarationContext : ctx.memberDeclarations().methodDeclaration()) {
            this.currentUnit.addInstanceCFG(this.visitMethodDeclaration(methodDeclarationContext));
        }
        for (IMPParser.ConstructorDeclarationContext constructorDeclarationContext : ctx.memberDeclarations().constructorDeclaration()) {
            this.currentUnit.addInstanceCFG(this.visitConstructorDeclaration(constructorDeclarationContext));
        }
        for (CFG cFG : this.currentUnit.getInstanceCFGs(false)) {
            if (this.currentUnit.getInstanceCFGs(false).stream().anyMatch(c -> c != cfg && c.getDescriptor().matchesSignature(cfg.getDescriptor()) && cfg.getDescriptor().matchesSignature(c.getDescriptor()))) {
                throw new IMPSyntaxException("Duplicate cfg: " + cFG);
            }
            if (!this.isEntryPoint(cFG)) continue;
            this.program.addEntryPoint(cFG);
        }
        for (IMPParser.FieldDeclarationContext fieldDeclarationContext : ctx.memberDeclarations().fieldDeclaration()) {
            this.currentUnit.addInstanceGlobal(this.visitFieldDeclaration(fieldDeclarationContext));
        }
        for (Global global : this.currentUnit.getInstanceGlobals(false)) {
            if (!this.currentUnit.getInstanceGlobals(false).stream().anyMatch(g -> g != global && g.getName().equals(global.getName()))) continue;
            throw new IMPSyntaxException("Duplicate global: " + global);
        }
        return this.currentUnit;
    }

    private boolean isEntryPoint(CFG cfg) {
        if (!this.onlyMain) {
            return true;
        }
        return cfg.getDescriptor().getName().equals("main");
    }

    @Override
    public Global visitFieldDeclaration(IMPParser.FieldDeclarationContext ctx) {
        return new Global((CodeLocation)new SourceCodeLocation(this.file, Antlr4Util.getLine(ctx), Antlr4Util.getCol(ctx)), ctx.name.getText(), (Type)Untyped.INSTANCE, new IMPAnnotationVisitor().visitAnnotations(ctx.annotations()));
    }

    @Override
    public CFG visitConstructorDeclaration(IMPParser.ConstructorDeclarationContext ctx) {
        CFGDescriptor descr = this.mkDescriptor(ctx);
        if (!this.currentUnit.getName().equals(descr.getName())) {
            throw new IMPSyntaxException("Constructor does not have the same name as its containing class");
        }
        return new IMPCodeMemberVisitor(this.file, descr).visitCodeMember(ctx.block());
    }

    @Override
    public CFG visitMethodDeclaration(IMPParser.MethodDeclarationContext ctx) {
        CFGDescriptor descr = this.mkDescriptor(ctx);
        return new IMPCodeMemberVisitor(this.file, descr).visitCodeMember(ctx.block());
    }

    private CFGDescriptor mkDescriptor(IMPParser.ConstructorDeclarationContext ctx) {
        CFGDescriptor descriptor = new CFGDescriptor((CodeLocation)new SourceCodeLocation(this.file, Antlr4Util.getLine(ctx), Antlr4Util.getCol(ctx)), (Unit)this.currentUnit, true, ctx.name.getText(), (Type)Untyped.INSTANCE, new IMPAnnotationVisitor().visitAnnotations(ctx.annotations()), this.visitFormals(ctx.formals()));
        descriptor.setOverridable(false);
        return descriptor;
    }

    private CFGDescriptor mkDescriptor(IMPParser.MethodDeclarationContext ctx) {
        CFGDescriptor descriptor = new CFGDescriptor((CodeLocation)new SourceCodeLocation(this.file, Antlr4Util.getLine(ctx), Antlr4Util.getCol(ctx)), (Unit)this.currentUnit, true, ctx.name.getText(), (Type)Untyped.INSTANCE, new IMPAnnotationVisitor().visitAnnotations(ctx.annotations()), this.visitFormals(ctx.formals()));
        if (ctx.FINAL() != null) {
            descriptor.setOverridable(false);
        } else {
            descriptor.setOverridable(true);
        }
        return descriptor;
    }

    @Override
    public Parameter[] visitFormals(IMPParser.FormalsContext ctx) {
        Parameter[] formals = new Parameter[ctx.formal().size() + 1];
        formals[0] = new Parameter((CodeLocation)new SourceCodeLocation(this.file, Antlr4Util.getLine(ctx), Antlr4Util.getCol(ctx)), "this", (Type)new ReferenceType((Type)ClassType.lookup(this.currentUnit.getName(), this.currentUnit)));
        int i = 1;
        for (IMPParser.FormalContext f : ctx.formal()) {
            formals[i++] = this.visitFormal(f);
        }
        return formals;
    }

    @Override
    public Parameter visitFormal(IMPParser.FormalContext ctx) {
        return new Parameter((CodeLocation)new SourceCodeLocation(this.file, Antlr4Util.getLine(ctx), Antlr4Util.getCol(ctx)), ctx.name.getText(), (Type)Untyped.INSTANCE, null, new IMPAnnotationVisitor().visitAnnotations(ctx.annotations()));
    }
}

