/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.imp.expressions;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.value.TypeDomain;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.caches.Caches;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.program.SourceCodeLocation;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.program.cfg.statement.BinaryExpression;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.heap.AccessChild;
import it.unive.lisa.symbolic.heap.HeapDereference;
import it.unive.lisa.type.ArrayType;
import it.unive.lisa.type.Type;
import it.unive.lisa.util.collections.externalSet.ExternalSet;

public class IMPArrayAccess
extends BinaryExpression {
    public IMPArrayAccess(CFG cfg, String sourceFile, int line, int col, Expression container, Expression location) {
        super(cfg, (CodeLocation)new SourceCodeLocation(sourceFile, line, col), "[]", container, location);
    }

    protected <A extends AbstractState<A, H, V, T>, H extends HeapDomain<H>, V extends ValueDomain<V>, T extends TypeDomain<T>> AnalysisState<A, H, V, T> binarySemantics(InterproceduralAnalysis<A, H, V, T> interprocedural, AnalysisState<A, H, V, T> state, SymbolicExpression left, SymbolicExpression right, StatementStore<A, H, V, T> expressions) throws SemanticException {
        ExternalSet arraytypes = Caches.types().mkEmptySet();
        for (Type t2 : left.getRuntimeTypes()) {
            if (!t2.isPointerType() || !t2.asPointerType().getInnerTypes().anyMatch(Type::isArrayType)) continue;
            arraytypes.addAll(t2.asPointerType().getInnerTypes().filter(Type::isArrayType));
        }
        if (arraytypes.isEmpty()) {
            return state.bottom();
        }
        ArrayType arraytype = ((Type)arraytypes.reduce((Object)((Type)arraytypes.first()), (r, t) -> r.commonSupertype(t))).asArrayType();
        HeapDereference container = new HeapDereference((Type)arraytype, left, this.getLocation());
        container.setRuntimeTypes(arraytypes);
        return state.smallStepSemantics((SymbolicExpression)new AccessChild(arraytype.getInnerType(), (SymbolicExpression)container, right, this.getLocation()), (ProgramPoint)this);
    }
}

