/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.imp.types;

import it.unive.lisa.type.Type;
import it.unive.lisa.type.Untyped;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public final class ArrayType
implements it.unive.lisa.type.ArrayType {
    private static final Map<Pair<Type, Integer>, ArrayType> types = new HashMap<Pair<Type, Integer>, ArrayType>();
    private final Type base;
    private final int dimensions;

    public static void clearAll() {
        types.clear();
    }

    public static Collection<ArrayType> all() {
        return types.values();
    }

    public static ArrayType lookup(Type base, int dimensions) {
        return types.computeIfAbsent((Pair<Type, Integer>)Pair.of((Object)base, (Object)dimensions), x -> new ArrayType(base, dimensions));
    }

    private ArrayType(Type base, int dimensions) {
        this.base = base;
        this.dimensions = dimensions;
    }

    public final boolean canBeAssignedTo(Type other) {
        return other instanceof ArrayType && this.getInnerType().canBeAssignedTo(other.asArrayType().getInnerType());
    }

    public Type commonSupertype(Type other) {
        if (this.canBeAssignedTo(other)) {
            return other;
        }
        if (other.canBeAssignedTo((Type)this)) {
            return this;
        }
        if (other.isNullType()) {
            return this;
        }
        if (!other.isArrayType()) {
            return Untyped.INSTANCE;
        }
        return this.getInnerType().commonSupertype(other.asArrayType().getInnerType());
    }

    public String toString() {
        return this.base + "[]".repeat(this.dimensions);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.base == null ? 0 : this.base.hashCode());
        result = 31 * result + this.dimensions;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArrayType other = (ArrayType)obj;
        if (this.base == null ? other.base != null : !this.base.equals(other.base)) {
            return false;
        }
        return this.dimensions == other.dimensions;
    }

    public Type getInnerType() {
        if (this.dimensions == 0) {
            return this.base;
        }
        return ArrayType.lookup(this.base, this.dimensions - 1);
    }

    public Type getBaseType() {
        return this.base;
    }

    public Collection<Type> allInstances() {
        return Collections.singleton(this);
    }
}

