/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.imp.types;

import it.unive.lisa.program.CompilationUnit;
import it.unive.lisa.type.InMemoryType;
import it.unive.lisa.type.Type;
import it.unive.lisa.type.UnitType;
import it.unive.lisa.type.Untyped;
import it.unive.lisa.util.collections.workset.FIFOWorkingSet;
import it.unive.lisa.util.collections.workset.WorkingSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;

public final class ClassType
implements InMemoryType,
UnitType {
    private static final Map<String, ClassType> types = new HashMap<String, ClassType>();
    private final String name;
    private final CompilationUnit unit;

    public static void clearAll() {
        types.clear();
    }

    public static Collection<ClassType> all() {
        return types.values();
    }

    public static ClassType lookup(String name, CompilationUnit unit) {
        return types.computeIfAbsent(name, x -> new ClassType(name, unit));
    }

    private ClassType(String name, CompilationUnit unit) {
        Objects.requireNonNull(name, "The name of a class type cannot be null");
        Objects.requireNonNull(unit, "The unit of a class type cannot be null");
        this.name = name;
        this.unit = unit;
    }

    public CompilationUnit getUnit() {
        return this.unit;
    }

    public final boolean canBeAssignedTo(Type other) {
        return other instanceof ClassType && this.subclass((ClassType)other);
    }

    private boolean subclass(ClassType other) {
        return this == other || this.unit.isInstanceOf(other.unit);
    }

    public Type commonSupertype(Type other) {
        if (other.isNullType()) {
            return this;
        }
        if (!other.isUnitType()) {
            return Untyped.INSTANCE;
        }
        if (this.canBeAssignedTo(other)) {
            return other;
        }
        if (other.canBeAssignedTo((Type)this)) {
            return this;
        }
        return this.scanForSupertypeOf((UnitType)other);
    }

    private Type scanForSupertypeOf(UnitType other) {
        FIFOWorkingSet ws = FIFOWorkingSet.mk();
        HashSet<ClassType> seen = new HashSet<ClassType>();
        ws.push((Object)this);
        while (!ws.isEmpty()) {
            ClassType current = (ClassType)ws.pop();
            if (!seen.add(current)) continue;
            if (other.canBeAssignedTo((Type)current)) {
                return current;
            }
            current.unit.getSuperUnits().forEach(arg_0 -> ClassType.lambda$scanForSupertypeOf$1((WorkingSet)ws, arg_0));
        }
        return Untyped.INSTANCE;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassType other = (ClassType)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.unit == null ? other.unit != null : !this.unit.equals(other.unit));
    }

    public Collection<Type> allInstances() {
        HashSet<Type> instances = new HashSet<Type>();
        for (CompilationUnit in : this.unit.getInstances()) {
            instances.add((Type)ClassType.lookup(in.getName(), null));
        }
        return instances;
    }

    private static /* synthetic */ void lambda$scanForSupertypeOf$1(WorkingSet ws, CompilationUnit u) {
        ws.push((Object)ClassType.lookup(u.getName(), null));
    }
}

