/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.ScopeToken;
import it.unive.lisa.analysis.SemanticDomain;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.representation.DomainRepresentation;
import it.unive.lisa.analysis.representation.SetRepresentation;
import it.unive.lisa.analysis.representation.StringRepresentation;
import it.unive.lisa.analysis.symbols.Symbol;
import it.unive.lisa.analysis.symbols.SymbolAliasing;
import it.unive.lisa.analysis.value.TypeDomain;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.ValueExpression;
import java.util.HashSet;
import java.util.Set;

public class AnalysisState<A extends AbstractState<A, H, V, T>, H extends HeapDomain<H>, V extends ValueDomain<V>, T extends TypeDomain<T>>
extends BaseLattice<AnalysisState<A, H, V, T>>
implements SemanticDomain<AnalysisState<A, H, V, T>, SymbolicExpression, Identifier> {
    private final A state;
    private final SymbolAliasing aliasing;
    private final ExpressionSet<SymbolicExpression> computedExpressions;

    public AnalysisState(A state, SymbolicExpression computedExpression) {
        this(state, new ExpressionSet<SymbolicExpression>(computedExpression), new SymbolAliasing());
    }

    public AnalysisState(A state, SymbolicExpression computedExpression, SymbolAliasing aliasing) {
        this(state, new ExpressionSet<SymbolicExpression>(computedExpression), aliasing);
    }

    public AnalysisState(A state, ExpressionSet<SymbolicExpression> computedExpressions) {
        this(state, computedExpressions, new SymbolAliasing());
    }

    public AnalysisState(A state, ExpressionSet<SymbolicExpression> computedExpressions, SymbolAliasing aliasing) {
        this.state = state;
        this.computedExpressions = computedExpressions;
        this.aliasing = aliasing;
    }

    public A getState() {
        return this.state;
    }

    public SymbolAliasing getAliasing() {
        return this.aliasing;
    }

    public ExpressionSet<SymbolicExpression> getComputedExpressions() {
        return this.computedExpressions;
    }

    public AnalysisState<A, H, V, T> alias(Symbol toAlias, Symbol alias) {
        SymbolAliasing aliasing = this.aliasing.putState(toAlias, alias);
        return new AnalysisState<A, H, V, T>(this.state, this.computedExpressions, aliasing);
    }

    @Override
    public AnalysisState<A, H, V, T> assign(Identifier id, SymbolicExpression value, ProgramPoint pp) throws SemanticException {
        AbstractState s = (AbstractState)this.state.assign((Identifier)id, (SymbolicExpression)value, pp);
        return new AnalysisState<AbstractState, H, V, T>(s, new ExpressionSet<SymbolicExpression>(id), this.aliasing);
    }

    @Override
    public AnalysisState<A, H, V, T> assign(SymbolicExpression id, SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        if (id instanceof Identifier) {
            return this.assign((Identifier)id, expression, pp);
        }
        AbstractState s = (AbstractState)this.state.bottom();
        ExpressionSet<SymbolicExpression> rewritten = this.rewrite(id, pp);
        for (SymbolicExpression i : rewritten) {
            s = s.lub((AbstractState)this.state.assign((Identifier)((Identifier)i), (SymbolicExpression)expression, pp));
        }
        return new AnalysisState<AbstractState, H, V, T>(s, rewritten, this.aliasing);
    }

    @Override
    public AnalysisState<A, H, V, T> smallStepSemantics(SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        AbstractState s = (AbstractState)this.state.smallStepSemantics((SymbolicExpression)expression, pp);
        return new AnalysisState<AbstractState, H, V, T>(s, new ExpressionSet<SymbolicExpression>(expression), this.aliasing);
    }

    private ExpressionSet<SymbolicExpression> rewrite(SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        HashSet rewritten = new HashSet();
        ExpressionSet<ValueExpression> tmp = this.getState().getDomainInstance(HeapDomain.class).rewrite(expression, pp);
        tmp.elements().stream().map(SymbolicExpression.class::cast).forEach(rewritten::add);
        return new ExpressionSet<SymbolicExpression>(rewritten);
    }

    @Override
    public AnalysisState<A, H, V, T> assume(SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        return new AnalysisState<AbstractState, H, V, T>((AbstractState)this.state.assume((SymbolicExpression)expression, pp), this.computedExpressions, this.aliasing);
    }

    @Override
    public SemanticDomain.Satisfiability satisfies(SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        return this.state.satisfies((SymbolicExpression)expression, pp);
    }

    @Override
    public AnalysisState<A, H, V, T> pushScope(ScopeToken scope) throws SemanticException {
        return new AnalysisState<AbstractState, H, V, T>((AbstractState)this.state.pushScope(scope), AnalysisState.onAllExpressions(this.computedExpressions, scope, true), this.aliasing);
    }

    private static ExpressionSet<SymbolicExpression> onAllExpressions(ExpressionSet<SymbolicExpression> computedExpressions, ScopeToken scope, boolean push) throws SemanticException {
        HashSet<SymbolicExpression> result = new HashSet<SymbolicExpression>();
        for (SymbolicExpression exp : computedExpressions) {
            result.add(push ? exp.pushScope(scope) : exp.popScope(scope));
        }
        return new ExpressionSet<SymbolicExpression>((Set<SymbolicExpression>)result);
    }

    @Override
    public AnalysisState<A, H, V, T> popScope(ScopeToken scope) throws SemanticException {
        return new AnalysisState<AbstractState, H, V, T>((AbstractState)this.state.popScope(scope), AnalysisState.onAllExpressions(this.computedExpressions, scope, false), this.aliasing);
    }

    @Override
    public AnalysisState<A, H, V, T> lubAux(AnalysisState<A, H, V, T> other) throws SemanticException {
        return new AnalysisState<AbstractState, H, V, T>((AbstractState)this.state.lub(other.state), this.computedExpressions.lub(other.computedExpressions), this.aliasing.lub(other.aliasing));
    }

    @Override
    public AnalysisState<A, H, V, T> wideningAux(AnalysisState<A, H, V, T> other) throws SemanticException {
        return new AnalysisState<AbstractState, H, V, T>((AbstractState)this.state.widening(other.state), this.computedExpressions.lub(other.computedExpressions), this.aliasing.widening(other.aliasing));
    }

    @Override
    public boolean lessOrEqualAux(AnalysisState<A, H, V, T> other) throws SemanticException {
        return this.state.lessOrEqual(other.state) && this.computedExpressions.lessOrEqual(other.computedExpressions) && this.aliasing.lessOrEqual(other.aliasing);
    }

    @Override
    public AnalysisState<A, H, V, T> top() {
        return new AnalysisState<AbstractState, H, V, T>((AbstractState)this.state.top(), new ExpressionSet<SymbolicExpression>(), this.aliasing.top());
    }

    @Override
    public AnalysisState<A, H, V, T> bottom() {
        return new AnalysisState<AbstractState, H, V, T>((AbstractState)this.state.bottom(), new ExpressionSet<SymbolicExpression>(), this.aliasing.bottom());
    }

    @Override
    public boolean isTop() {
        return this.state.isTop();
    }

    @Override
    public boolean isBottom() {
        return this.state.isBottom();
    }

    @Override
    public AnalysisState<A, H, V, T> forgetIdentifier(Identifier id) throws SemanticException {
        return new AnalysisState<AbstractState, H, V, T>((AbstractState)this.state.forgetIdentifier(id), this.computedExpressions, this.aliasing);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.aliasing == null ? 0 : this.aliasing.hashCode());
        result = 31 * result + (this.computedExpressions == null ? 0 : this.computedExpressions.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnalysisState other = (AnalysisState)obj;
        if (this.aliasing == null ? other.aliasing != null : !this.aliasing.equals(other.aliasing)) {
            return false;
        }
        if (this.computedExpressions == null ? other.computedExpressions != null : !this.computedExpressions.equals(other.computedExpressions)) {
            return false;
        }
        return !(this.state == null ? other.state != null : !this.state.equals(other.state));
    }

    @Override
    public DomainRepresentation representation() {
        return new AnalysisStateRepresentation(this.state.representation(), new SetRepresentation(this.computedExpressions.elements(), StringRepresentation::new));
    }

    public DomainRepresentation typeRepresentation() {
        return new AnalysisStateRepresentation(this.state.typeRepresentation(), new SetRepresentation(this.computedExpressions.elements(), StringRepresentation::new));
    }

    @Override
    public String toString() {
        return this.representation().toString();
    }

    @Override
    public <D> D getDomainInstance(Class<D> domain) {
        if (domain.isAssignableFrom(this.getClass())) {
            return (D)this;
        }
        return this.state.getDomainInstance(domain);
    }

    private static final class AnalysisStateRepresentation
    extends DomainRepresentation {
        private final DomainRepresentation state;
        private final DomainRepresentation expressions;

        private AnalysisStateRepresentation(DomainRepresentation state, DomainRepresentation expressions) {
            this.state = state;
            this.expressions = expressions;
        }

        @Override
        public String toString() {
            return "{{\n" + this.state + "\n}} -> " + this.expressions;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.expressions == null ? 0 : this.expressions.hashCode());
            result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AnalysisStateRepresentation other = (AnalysisStateRepresentation)obj;
            if (this.expressions == null ? other.expressions != null : !this.expressions.equals(other.expressions)) {
                return false;
            }
            return !(this.state == null ? other.state != null : !this.state.equals(other.state));
        }
    }
}

