/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis;

import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticException;

public abstract class BaseLattice<L extends BaseLattice<L>>
implements Lattice<L> {
    @Override
    public L lub(L other) throws SemanticException {
        if (other == null || other.isBottom() || this.isTop() || this == other || this.equals(other)) {
            return (L)this;
        }
        if (this.isBottom() || other.isTop()) {
            return other;
        }
        return this.lubAux(other);
    }

    protected abstract L lubAux(L var1) throws SemanticException;

    @Override
    public L widening(L other) throws SemanticException {
        if (other == null || other.isBottom() || this.isTop() || this == other || this.equals(other)) {
            return (L)this;
        }
        if (this.isBottom() || other.isTop()) {
            return other;
        }
        return this.wideningAux(other);
    }

    protected abstract L wideningAux(L var1) throws SemanticException;

    @Override
    public boolean lessOrEqual(L other) throws SemanticException {
        if (other == null) {
            return false;
        }
        if (this == other || this.isBottom() || other.isTop() || this.equals(other)) {
            return true;
        }
        if (this.isTop() || other.isBottom()) {
            return false;
        }
        return this.lessOrEqualAux(other);
    }

    protected abstract boolean lessOrEqualAux(L var1) throws SemanticException;

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();
}

