/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.value.TypeDomain;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.outputs.DotCFG;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;

public class CFGWithAnalysisResults<A extends AbstractState<A, H, V, T>, H extends HeapDomain<H>, V extends ValueDomain<V>, T extends TypeDomain<T>>
extends CFG
implements Lattice<CFGWithAnalysisResults<A, H, V, T>> {
    private static final String CANNOT_JOIN_ERROR = "Cannot join graphs with different IDs: '%s' and '%s'";
    private static final String CANNOT_LUB_ERROR = "Cannot perform the least upper bound of two graphs with different descriptor";
    private final StatementStore<A, H, V, T> results;
    private final StatementStore<A, H, V, T> entryStates;
    private String id;

    public CFGWithAnalysisResults(CFG cfg, AnalysisState<A, H, V, T> singleton) {
        this(cfg, singleton, Collections.emptyMap(), Collections.emptyMap());
    }

    public CFGWithAnalysisResults(CFG cfg, AnalysisState<A, H, V, T> singleton, Map<Statement, AnalysisState<A, H, V, T>> entryStates, Map<Statement, AnalysisState<A, H, V, T>> results) {
        super(cfg);
        this.results = new StatementStore<A, H, V, T>(singleton);
        results.forEach(this.results::put);
        this.entryStates = new StatementStore<A, H, V, T>(singleton);
        entryStates.forEach(this.entryStates::put);
    }

    private CFGWithAnalysisResults(CFG cfg, StatementStore<A, H, V, T> entryStates, StatementStore<A, H, V, T> results) {
        super(cfg);
        this.results = results;
        this.entryStates = entryStates;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AnalysisState<A, H, V, T> getAnalysisStateBefore(Statement st) throws SemanticException {
        Statement target;
        Statement pred = st.getEvaluationPredecessor();
        if (pred != null) {
            this.results.getState(pred);
        }
        Statement statement = target = st instanceof Expression ? ((Expression)st).getRootStatement() : st;
        if (this.getEntrypoints().contains(target)) {
            return (AnalysisState)this.entryStates.getState(target);
        }
        return this.lub(this.predecessorsOf(target), false);
    }

    public AnalysisState<A, H, V, T> getAnalysisStateAfter(Statement st) {
        return (AnalysisState)this.results.getState(st);
    }

    public AnalysisState<A, H, V, T> getEntryState() throws SemanticException {
        return this.lub(this.getEntrypoints(), true);
    }

    public AnalysisState<A, H, V, T> getExitState() throws SemanticException {
        return this.lub(this.getNormalExitpoints(), false);
    }

    private AnalysisState<A, H, V, T> lub(Collection<Statement> statements, boolean entry) throws SemanticException {
        AnalysisState<A, H, V, T> result = ((AnalysisState)this.entryStates.lattice).bottom();
        for (Statement st : statements) {
            result = result.lub(entry ? this.getAnalysisStateBefore(st) : this.getAnalysisStateAfter(st));
        }
        return result;
    }

    public CFGWithAnalysisResults<A, H, V, T> join(CFGWithAnalysisResults<A, H, V, T> other) throws SemanticException {
        if (!this.getDescriptor().equals(other.getDescriptor())) {
            throw new SemanticException(CANNOT_LUB_ERROR);
        }
        return new CFGWithAnalysisResults<A, H, V, T>(this, this.entryStates.lub(other.entryStates), this.results.lub(other.results));
    }

    @Override
    public CFGWithAnalysisResults<A, H, V, T> lub(CFGWithAnalysisResults<A, H, V, T> other) throws SemanticException {
        if (!this.getDescriptor().equals(other.getDescriptor())) {
            throw new SemanticException(CANNOT_LUB_ERROR);
        }
        CFGWithAnalysisResults<A, H, V, T> lub = new CFGWithAnalysisResults<A, H, V, T>(this, this.entryStates.lub(other.entryStates), this.results.lub(other.results));
        lub.setId(this.joinIDs(other));
        return lub;
    }

    @Override
    public CFGWithAnalysisResults<A, H, V, T> widening(CFGWithAnalysisResults<A, H, V, T> other) throws SemanticException {
        if (!this.getDescriptor().equals(other.getDescriptor())) {
            throw new SemanticException(CANNOT_LUB_ERROR);
        }
        CFGWithAnalysisResults<A, H, V, T> widen = new CFGWithAnalysisResults<A, H, V, T>(this, this.entryStates.widening(other.entryStates), this.results.widening(other.results));
        widen.setId(this.joinIDs(other));
        return widen;
    }

    private String joinIDs(CFGWithAnalysisResults<A, H, V, T> other) throws SemanticException {
        if (this.id == null) {
            if (other.id == null) {
                return null;
            }
            throw new SemanticException(String.format(CANNOT_JOIN_ERROR, String.valueOf(this.id), String.valueOf(other.id)));
        }
        if (other.id == null) {
            throw new SemanticException(String.format(CANNOT_JOIN_ERROR, String.valueOf(this.id), String.valueOf(other.id)));
        }
        if (!this.id.equals(other.id)) {
            throw new SemanticException(String.format(CANNOT_JOIN_ERROR, String.valueOf(this.id), String.valueOf(other.id)));
        }
        return this.id;
    }

    @Override
    public boolean lessOrEqual(CFGWithAnalysisResults<A, H, V, T> other) throws SemanticException {
        if (!this.getDescriptor().equals(other.getDescriptor())) {
            throw new SemanticException(CANNOT_LUB_ERROR);
        }
        return this.entryStates.lessOrEqual(other.entryStates) && this.results.lessOrEqual(other.results);
    }

    @Override
    public CFGWithAnalysisResults<A, H, V, T> top() {
        return new CFGWithAnalysisResults<A, H, V, T>(this, this.entryStates.top(), this.results.top());
    }

    @Override
    public boolean isTop() {
        return this.entryStates.isTop() && this.results.isTop();
    }

    @Override
    public CFGWithAnalysisResults<A, H, V, T> bottom() {
        return new CFGWithAnalysisResults<A, H, V, T>(this, this.entryStates.bottom(), this.results.bottom());
    }

    @Override
    public boolean isBottom() {
        return this.entryStates.isBottom() && this.results.isBottom();
    }

    @Override
    protected DotCFG toDot(Function<Statement, String> labelGenerator) {
        return DotCFG.fromCFG(this, this.id, labelGenerator);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entryStates == null ? 0 : this.entryStates.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.results == null ? 0 : this.results.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CFGWithAnalysisResults other = (CFGWithAnalysisResults)obj;
        if (this.entryStates == null ? other.entryStates != null : !this.entryStates.equals(other.entryStates)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.results == null ? other.results != null : !this.results.equals(other.results));
    }
}

