/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.ScopeToken;
import it.unive.lisa.analysis.SemanticDomain;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.representation.DomainRepresentation;
import it.unive.lisa.analysis.value.TypeDomain;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.type.Type;
import it.unive.lisa.util.collections.externalSet.ExternalSet;

public class SimpleAbstractState<H extends HeapDomain<H>, V extends ValueDomain<V>, T extends TypeDomain<T>>
extends BaseLattice<SimpleAbstractState<H, V, T>>
implements AbstractState<SimpleAbstractState<H, V, T>, H, V, T> {
    private final H heapState;
    private final V valueState;
    private final T typeState;

    public SimpleAbstractState(H heapState, V valueState, T typeState) {
        this.heapState = heapState;
        this.valueState = valueState;
        this.typeState = typeState;
    }

    @Override
    public H getHeapState() {
        return this.heapState;
    }

    @Override
    public V getValueState() {
        return this.valueState;
    }

    @Override
    public T getTypeState() {
        return this.typeState;
    }

    @Override
    public SimpleAbstractState<H, V, T> assign(Identifier id, SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        HeapDomain heap = (HeapDomain)this.heapState.assign((Identifier)id, (SymbolicExpression)expression, pp);
        ExpressionSet<ValueExpression> exprs = heap.rewrite(expression, pp);
        Object type = this.typeState;
        Object value = this.valueState;
        if (heap.getSubstitution() != null && !heap.getSubstitution().isEmpty()) {
            type = (TypeDomain)type.applySubstitution(heap.getSubstitution(), pp);
            value = value.applySubstitution(heap.getSubstitution(), pp);
        }
        for (ValueExpression expr : exprs) {
            type = (TypeDomain)type.assign((Identifier)id, (ValueExpression)expr, pp);
            ExternalSet<Type> rt = type.getInferredRuntimeTypes();
            id.setRuntimeTypes(rt);
            expr.setRuntimeTypes(rt);
            value = (ValueDomain)value.assign((Identifier)id, (ValueExpression)expr, pp);
        }
        return new SimpleAbstractState<HeapDomain, V, T>(heap, value, type);
    }

    @Override
    public SimpleAbstractState<H, V, T> smallStepSemantics(SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        HeapDomain heap = (HeapDomain)this.heapState.smallStepSemantics((SymbolicExpression)expression, pp);
        ExpressionSet<ValueExpression> exprs = heap.rewrite(expression, pp);
        Object type = this.typeState;
        Object value = this.valueState;
        if (heap.getSubstitution() != null && !heap.getSubstitution().isEmpty()) {
            type = (TypeDomain)type.applySubstitution(heap.getSubstitution(), pp);
            value = value.applySubstitution(heap.getSubstitution(), pp);
        }
        for (ValueExpression expr : exprs) {
            type = (TypeDomain)type.smallStepSemantics((ValueExpression)expr, pp);
            ExternalSet<Type> rt = type.getInferredRuntimeTypes();
            expr.setRuntimeTypes(rt);
            value = (ValueDomain)value.smallStepSemantics((ValueExpression)expr, pp);
        }
        return new SimpleAbstractState<HeapDomain, V, T>(heap, value, type);
    }

    @Override
    public SimpleAbstractState<H, V, T> assume(SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        HeapDomain heap = (HeapDomain)this.heapState.assume((SymbolicExpression)expression, pp);
        ExpressionSet<ValueExpression> exprs = heap.rewrite(expression, pp);
        Object type = this.typeState;
        Object value = this.valueState;
        if (heap.getSubstitution() != null && !heap.getSubstitution().isEmpty()) {
            type = (TypeDomain)type.applySubstitution(heap.getSubstitution(), pp);
            value = value.applySubstitution(heap.getSubstitution(), pp);
        }
        for (ValueExpression expr : exprs) {
            TypeDomain tmp = (TypeDomain)type.smallStepSemantics((ValueExpression)expr, pp);
            ExternalSet<Type> rt = tmp.getInferredRuntimeTypes();
            expr.setRuntimeTypes(rt);
            type = (TypeDomain)type.assume(expr, pp);
            value = (ValueDomain)value.assume((ValueExpression)expr, pp);
        }
        return new SimpleAbstractState<HeapDomain, V, T>(heap, value, type);
    }

    @Override
    public SemanticDomain.Satisfiability satisfies(SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        ExpressionSet<ValueExpression> rewritten = this.heapState.rewrite(expression, pp);
        SemanticDomain.Satisfiability typeResult = SemanticDomain.Satisfiability.BOTTOM;
        SemanticDomain.Satisfiability valueResult = SemanticDomain.Satisfiability.BOTTOM;
        for (ValueExpression expr : rewritten) {
            TypeDomain tmp = (TypeDomain)this.typeState.smallStepSemantics((ValueExpression)expr, pp);
            ExternalSet<Type> rt = tmp.getInferredRuntimeTypes();
            expr.setRuntimeTypes(rt);
            typeResult = typeResult.lub(this.typeState.satisfies((ValueExpression)expr, pp));
            valueResult = valueResult.lub(this.valueState.satisfies((ValueExpression)expr, pp));
        }
        return this.heapState.satisfies((SymbolicExpression)expression, pp).glb(typeResult).glb(valueResult);
    }

    @Override
    public SimpleAbstractState<H, V, T> pushScope(ScopeToken scope) throws SemanticException {
        return new SimpleAbstractState<HeapDomain, ValueDomain, TypeDomain>((HeapDomain)this.heapState.pushScope(scope), (ValueDomain)this.valueState.pushScope(scope), (TypeDomain)this.typeState.pushScope(scope));
    }

    @Override
    public SimpleAbstractState<H, V, T> popScope(ScopeToken scope) throws SemanticException {
        return new SimpleAbstractState<HeapDomain, ValueDomain, TypeDomain>((HeapDomain)this.heapState.popScope(scope), (ValueDomain)this.valueState.popScope(scope), (TypeDomain)this.typeState.popScope(scope));
    }

    @Override
    public SimpleAbstractState<H, V, T> lubAux(SimpleAbstractState<H, V, T> other) throws SemanticException {
        return new SimpleAbstractState<HeapDomain, ValueDomain, TypeDomain>((HeapDomain)this.heapState.lub(other.heapState), (ValueDomain)this.valueState.lub(other.valueState), (TypeDomain)this.typeState.lub(other.typeState));
    }

    @Override
    public SimpleAbstractState<H, V, T> wideningAux(SimpleAbstractState<H, V, T> other) throws SemanticException {
        return new SimpleAbstractState<HeapDomain, ValueDomain, TypeDomain>((HeapDomain)this.heapState.widening(other.heapState), (ValueDomain)this.valueState.widening(other.valueState), (TypeDomain)this.typeState.widening(other.typeState));
    }

    @Override
    public boolean lessOrEqualAux(SimpleAbstractState<H, V, T> other) throws SemanticException {
        return this.heapState.lessOrEqual(other.heapState) && this.valueState.lessOrEqual(other.valueState) && this.typeState.lessOrEqual(other.typeState);
    }

    @Override
    public SimpleAbstractState<H, V, T> top() {
        return new SimpleAbstractState<HeapDomain, ValueDomain, TypeDomain>((HeapDomain)this.heapState.top(), (ValueDomain)this.valueState.top(), (TypeDomain)this.typeState.top());
    }

    @Override
    public SimpleAbstractState<H, V, T> bottom() {
        return new SimpleAbstractState<HeapDomain, ValueDomain, TypeDomain>((HeapDomain)this.heapState.bottom(), (ValueDomain)this.valueState.bottom(), (TypeDomain)this.typeState.bottom());
    }

    @Override
    public boolean isTop() {
        return this.heapState.isTop() && this.valueState.isTop() && this.typeState.isTop();
    }

    @Override
    public boolean isBottom() {
        return this.heapState.isBottom() && this.valueState.isBottom() && this.typeState.isBottom();
    }

    @Override
    public SimpleAbstractState<H, V, T> forgetIdentifier(Identifier id) throws SemanticException {
        return new SimpleAbstractState<HeapDomain, ValueDomain, TypeDomain>((HeapDomain)this.heapState.forgetIdentifier(id), (ValueDomain)this.valueState.forgetIdentifier(id), (TypeDomain)this.typeState.forgetIdentifier(id));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.heapState == null ? 0 : this.heapState.hashCode());
        result = 31 * result + (this.valueState == null ? 0 : this.valueState.hashCode());
        result = 31 * result + (this.typeState == null ? 0 : this.typeState.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleAbstractState other = (SimpleAbstractState)obj;
        if (this.heapState == null ? other.heapState != null : !this.heapState.equals(other.heapState)) {
            return false;
        }
        if (this.valueState == null ? other.valueState != null : !this.valueState.equals(other.valueState)) {
            return false;
        }
        return !(this.typeState == null ? other.typeState != null : !this.typeState.equals(other.typeState));
    }

    @Override
    public DomainRepresentation representation() {
        return new StateRepresentation(this.heapState.representation(), this.valueState.representation());
    }

    @Override
    public DomainRepresentation typeRepresentation() {
        return new StateRepresentation(this.heapState.representation(), this.typeState.representation());
    }

    @Override
    public String toString() {
        return this.representation().toString();
    }

    @Override
    public <D> D getDomainInstance(Class<D> domain) {
        if (domain.isAssignableFrom(this.getClass())) {
            return (D)this;
        }
        D di = this.heapState.getDomainInstance(domain);
        if (di != null) {
            return di;
        }
        di = this.typeState.getDomainInstance(domain);
        if (di != null) {
            return di;
        }
        return this.valueState.getDomainInstance(domain);
    }

    private static final class StateRepresentation
    extends DomainRepresentation {
        private final DomainRepresentation heap;
        private final DomainRepresentation value;

        private StateRepresentation(DomainRepresentation heap, DomainRepresentation value) {
            this.heap = heap;
            this.value = value;
        }

        @Override
        public String toString() {
            return "heap [[ " + this.heap + " ]]\nvalue [[ " + this.value + " ]]";
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.heap == null ? 0 : this.heap.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StateRepresentation other = (StateRepresentation)obj;
            if (this.heap == null ? other.heap != null : !this.heap.equals(other.heap)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }
}

