/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.heap;

import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.ScopeToken;
import it.unive.lisa.analysis.SemanticDomain;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.ExpressionVisitor;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.heap.HeapExpression;
import it.unive.lisa.symbolic.value.BinaryExpression;
import it.unive.lisa.symbolic.value.Constant;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.PushAny;
import it.unive.lisa.symbolic.value.Skip;
import it.unive.lisa.symbolic.value.TernaryExpression;
import it.unive.lisa.symbolic.value.UnaryExpression;
import it.unive.lisa.symbolic.value.ValueExpression;
import java.util.HashSet;
import java.util.Set;

public abstract class BaseHeapDomain<H extends BaseHeapDomain<H>>
extends BaseLattice<H>
implements HeapDomain<H> {
    @Override
    public final String toString() {
        return this.representation().toString();
    }

    @Override
    public H smallStepSemantics(SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        if (expression instanceof HeapExpression) {
            return this.semanticsOf((HeapExpression)expression, pp);
        }
        if (expression instanceof UnaryExpression) {
            UnaryExpression unary = (UnaryExpression)expression;
            return (H)this.smallStepSemantics(unary.getExpression(), pp);
        }
        if (expression instanceof BinaryExpression) {
            BinaryExpression binary = (BinaryExpression)expression;
            SemanticDomain sem = this.smallStepSemantics(binary.getLeft(), pp);
            if (sem.isBottom()) {
                return (H)sem;
            }
            return (H)((BaseHeapDomain)sem).smallStepSemantics(binary.getRight(), pp);
        }
        if (expression instanceof TernaryExpression) {
            TernaryExpression ternary = (TernaryExpression)expression;
            SemanticDomain sem1 = this.smallStepSemantics(ternary.getLeft(), pp);
            if (sem1.isBottom()) {
                return (H)sem1;
            }
            SemanticDomain sem2 = ((BaseHeapDomain)sem1).smallStepSemantics(ternary.getMiddle(), pp);
            if (sem2.isBottom()) {
                return (H)sem2;
            }
            return (H)((BaseHeapDomain)sem2).smallStepSemantics(ternary.getRight(), pp);
        }
        if (expression instanceof ValueExpression) {
            return (H)this.mk(this);
        }
        return (H)((BaseHeapDomain)this.top());
    }

    protected abstract H mk(H var1);

    @Override
    public H pushScope(ScopeToken scope) throws SemanticException {
        return (H)this;
    }

    @Override
    public H popScope(ScopeToken scope) throws SemanticException {
        return (H)this;
    }

    protected abstract H semanticsOf(HeapExpression var1, ProgramPoint var2) throws SemanticException;

    protected static abstract class Rewriter
    implements ExpressionVisitor<ExpressionSet<ValueExpression>> {
        protected Rewriter() {
        }

        @Override
        public ExpressionSet<ValueExpression> visit(UnaryExpression expression, ExpressionSet<ValueExpression> arg, Object ... params) throws SemanticException {
            HashSet<UnaryExpression> result = new HashSet<UnaryExpression>();
            for (ValueExpression expr : arg) {
                UnaryExpression e = new UnaryExpression(expression.getStaticType(), expr, expression.getOperator(), expression.getCodeLocation());
                if (expr.hasRuntimeTypes()) {
                    e.setRuntimeTypes(expr.getRuntimeTypes());
                }
                result.add(e);
            }
            return new ExpressionSet<ValueExpression>((Set<ValueExpression>)result);
        }

        @Override
        public ExpressionSet<ValueExpression> visit(BinaryExpression expression, ExpressionSet<ValueExpression> left, ExpressionSet<ValueExpression> right, Object ... params) throws SemanticException {
            HashSet<BinaryExpression> result = new HashSet<BinaryExpression>();
            for (ValueExpression l : left) {
                for (ValueExpression r : right) {
                    BinaryExpression e = new BinaryExpression(expression.getStaticType(), l, r, expression.getOperator(), expression.getCodeLocation());
                    if (expression.hasRuntimeTypes()) {
                        e.setRuntimeTypes(expression.getRuntimeTypes());
                    }
                    result.add(e);
                }
            }
            return new ExpressionSet<ValueExpression>((Set<ValueExpression>)result);
        }

        @Override
        public ExpressionSet<ValueExpression> visit(TernaryExpression expression, ExpressionSet<ValueExpression> left, ExpressionSet<ValueExpression> middle, ExpressionSet<ValueExpression> right, Object ... params) throws SemanticException {
            HashSet<TernaryExpression> result = new HashSet<TernaryExpression>();
            for (ValueExpression l : left) {
                for (ValueExpression m : middle) {
                    for (ValueExpression r : right) {
                        TernaryExpression e = new TernaryExpression(expression.getStaticType(), l, m, r, expression.getOperator(), expression.getCodeLocation());
                        if (expression.hasRuntimeTypes()) {
                            e.setRuntimeTypes(expression.getRuntimeTypes());
                        }
                        result.add(e);
                    }
                }
            }
            return new ExpressionSet<ValueExpression>((Set<ValueExpression>)result);
        }

        @Override
        public ExpressionSet<ValueExpression> visit(Skip expression, Object ... params) throws SemanticException {
            return new ExpressionSet<ValueExpression>(expression);
        }

        @Override
        public ExpressionSet<ValueExpression> visit(PushAny expression, Object ... params) throws SemanticException {
            return new ExpressionSet<ValueExpression>(expression);
        }

        @Override
        public ExpressionSet<ValueExpression> visit(Constant expression, Object ... params) throws SemanticException {
            return new ExpressionSet<ValueExpression>(expression);
        }

        @Override
        public ExpressionSet<ValueExpression> visit(Identifier expression, Object ... params) throws SemanticException {
            return new ExpressionSet<ValueExpression>(expression);
        }
    }
}

