/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.nonrelational;

import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.ScopeToken;
import it.unive.lisa.analysis.SemanticDomain;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.lattices.FunctionalLattice;
import it.unive.lisa.analysis.nonrelational.NonRelationalElement;
import it.unive.lisa.analysis.representation.DomainRepresentation;
import it.unive.lisa.analysis.representation.MapRepresentation;
import it.unive.lisa.analysis.representation.StringRepresentation;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.util.collections.CollectionsDiffBuilder;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import org.apache.commons.lang3.tuple.Pair;

public abstract class Environment<M extends Environment<M, E, T, V>, E extends SymbolicExpression, T extends NonRelationalElement<T, E, M>, V extends Lattice<V>>
extends FunctionalLattice<M, Identifier, T>
implements SemanticDomain<M, E, Identifier> {
    protected Environment(T domain) {
        super(domain);
    }

    protected Environment(T domain, Map<Identifier, T> function) {
        super(domain, function);
    }

    protected abstract M copy();

    @Override
    public M assign(Identifier id, E expression, ProgramPoint pp) throws SemanticException {
        if (this.isBottom()) {
            return (M)this;
        }
        if (!((NonRelationalElement)this.lattice).canProcess((SymbolicExpression)expression) || !((NonRelationalElement)this.lattice).tracksIdentifiers(id)) {
            return (M)this;
        }
        Map func = this.mkNewFunction(this.function);
        Pair<T, V> eval = this.eval(expression, pp);
        NonRelationalElement value = (NonRelationalElement)eval.getLeft();
        Object v = ((NonRelationalElement)this.lattice).variable(id, pp);
        if (!v.isBottom()) {
            value = v;
        }
        if (id.isWeak() && this.function != null && this.function.containsKey(id)) {
            value = value.lub((NonRelationalElement)this.getState(id));
        }
        func.put(id, value);
        return this.assignAux(id, expression, func, value, (Lattice)eval.getRight(), pp);
    }

    protected abstract Pair<T, V> eval(E var1, ProgramPoint var2) throws SemanticException;

    protected abstract M assignAux(Identifier var1, E var2, Map<Identifier, T> var3, T var4, V var5, ProgramPoint var6) throws SemanticException;

    @Override
    public M assume(E expression, ProgramPoint pp) throws SemanticException {
        if (((NonRelationalElement)this.lattice).satisfies(expression, this, pp) == SemanticDomain.Satisfiability.NOT_SATISFIED) {
            return (M)((Environment)this.bottom());
        }
        if (((NonRelationalElement)this.lattice).satisfies(expression, this, pp) == SemanticDomain.Satisfiability.SATISFIED) {
            return this.assumeSatisfied((Lattice)this.eval(expression, pp).getRight());
        }
        return (M)this.glb(((NonRelationalElement)this.lattice).assume(this, expression, pp));
    }

    protected abstract M assumeSatisfied(V var1) throws SemanticException;

    public M glb(M other) throws SemanticException {
        if (other == null || this.isBottom() || ((Environment)other).isTop() || this == other || this.equals(other) || this.lessOrEqual(other)) {
            return this.glbAux((NonRelationalElement)this.lattice, this.function, other);
        }
        if (((Environment)other).isBottom() || this.isTop() || ((BaseLattice)other).lessOrEqual((Environment)this)) {
            return this.glbAux((NonRelationalElement)((Environment)other).lattice, ((Environment)other).function, other);
        }
        Environment lift = (Environment)this.functionalLift(other, this::glbKeys, (o1, o2) -> o1 == null ? o2 : o1.glb(o2));
        return this.glbAux((NonRelationalElement)lift.lattice, lift.function, other);
    }

    protected abstract M glbAux(T var1, Map<Identifier, T> var2, M var3) throws SemanticException;

    @Override
    public SemanticDomain.Satisfiability satisfies(E expression, ProgramPoint pp) throws SemanticException {
        return ((NonRelationalElement)this.lattice).satisfies(expression, this, pp);
    }

    @Override
    public boolean isTop() {
        return ((NonRelationalElement)this.lattice).isTop() && this.function == null;
    }

    @Override
    public boolean isBottom() {
        return ((NonRelationalElement)this.lattice).isBottom() && this.function == null;
    }

    @Override
    public M pushScope(ScopeToken scope) throws SemanticException {
        AtomicReference holder = new AtomicReference();
        M result = this.liftIdentifiers(id -> {
            try {
                return (Identifier)id.pushScope(scope);
            }
            catch (SemanticException e) {
                holder.set(e);
                return null;
            }
        });
        if (holder.get() != null) {
            throw new SemanticException("Pushing the scope '" + scope + "' raised an error", (Throwable)holder.get());
        }
        return result;
    }

    @Override
    public M popScope(ScopeToken scope) throws SemanticException {
        AtomicReference holder = new AtomicReference();
        M result = this.liftIdentifiers(id -> {
            try {
                return (Identifier)id.popScope(scope);
            }
            catch (SemanticException e) {
                holder.set(e);
                return null;
            }
        });
        if (holder.get() != null) {
            throw new SemanticException("Popping the scope '" + scope + "' raised an error", (Throwable)holder.get());
        }
        return result;
    }

    private M liftIdentifiers(UnaryOperator<Identifier> lifter) throws SemanticException {
        if (this.isBottom() || this.isTop()) {
            return (M)this;
        }
        Map<Identifier, NonRelationalElement> function = this.mkNewFunction(null);
        for (Identifier id : this.getKeys()) {
            Identifier lifted = (Identifier)lifter.apply(id);
            if (lifted == null) continue;
            if (!function.containsKey(lifted)) {
                function.put(lifted, (NonRelationalElement)this.getState(id));
                continue;
            }
            function.put(lifted, ((NonRelationalElement)this.getState(id)).lub((NonRelationalElement)function.get(lifted)));
        }
        return (M)((Environment)this.mk((NonRelationalElement)this.lattice, function));
    }

    @Override
    public M forgetIdentifier(Identifier id) throws SemanticException {
        if (this.isTop() || this.isBottom()) {
            return (M)this;
        }
        M result = this.copy();
        if (((Environment)result).function.containsKey(id)) {
            ((Environment)result).function.remove(id);
        }
        return result;
    }

    @Override
    public DomainRepresentation representation() {
        if (this.isTop()) {
            return Lattice.TOP_REPR;
        }
        if (this.isBottom()) {
            return Lattice.BOTTOM_REPR;
        }
        return new MapRepresentation(this.function, StringRepresentation::new, NonRelationalElement::representation);
    }

    @Override
    protected Set<Identifier> lubKeys(Set<Identifier> k1, Set<Identifier> k2) throws SemanticException {
        HashSet<Identifier> keys = new HashSet<Identifier>();
        CollectionsDiffBuilder<Identifier> builder = new CollectionsDiffBuilder<Identifier>(Identifier.class, k1, k2);
        builder.compute(Comparator.comparing(Identifier::getName));
        keys.addAll(builder.getOnlyFirst());
        keys.addAll(builder.getOnlySecond());
        for (Pair<Identifier, Identifier> pair : builder.getCommons()) {
            try {
                keys.add(((Identifier)pair.getLeft()).lub((Identifier)pair.getRight()));
            }
            catch (SemanticException e) {
                throw new SemanticException("Unable to lub " + pair.getLeft() + " and " + pair.getRight(), e);
            }
        }
        return keys;
    }
}

