/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.nonrelational.heap;

import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.heap.HeapSemanticOperation;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.nonrelational.Environment;
import it.unive.lisa.analysis.nonrelational.heap.NonRelationalHeapDomain;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.ValueExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class HeapEnvironment<T extends NonRelationalHeapDomain<T>>
extends Environment<HeapEnvironment<T>, SymbolicExpression, T, T>
implements HeapDomain<HeapEnvironment<T>> {
    private final List<HeapSemanticOperation.HeapReplacement> substitution;

    public HeapEnvironment(T domain) {
        super(domain);
        this.substitution = Collections.emptyList();
    }

    public HeapEnvironment(T domain, Map<Identifier, T> function) {
        this(domain, function, Collections.emptyList());
    }

    private HeapEnvironment(T domain, Map<Identifier, T> function, List<HeapSemanticOperation.HeapReplacement> substitution) {
        super(domain, function);
        this.substitution = substitution;
    }

    @Override
    protected HeapEnvironment<T> mk(T lattice, Map<Identifier, T> function) {
        return new HeapEnvironment<T>(lattice, function);
    }

    @Override
    public ExpressionSet<ValueExpression> rewrite(SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        return ((NonRelationalHeapDomain)this.lattice).rewrite(expression, this, pp);
    }

    @Override
    public List<HeapSemanticOperation.HeapReplacement> getSubstitution() {
        return this.substitution;
    }

    @Override
    protected HeapEnvironment<T> copy() {
        return new HeapEnvironment<NonRelationalHeapDomain>((NonRelationalHeapDomain)this.lattice, this.mkNewFunction(this.function), new ArrayList<HeapSemanticOperation.HeapReplacement>(this.substitution));
    }

    @Override
    protected Pair<T, T> eval(SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        NonRelationalHeapDomain eval = (NonRelationalHeapDomain)((NonRelationalHeapDomain)this.lattice).eval(expression, this, pp);
        return Pair.of((Object)eval, (Object)eval);
    }

    @Override
    public HeapEnvironment<T> assignAux(Identifier id, SymbolicExpression expression, Map<Identifier, T> function, T value, T eval, ProgramPoint pp) {
        return new HeapEnvironment<NonRelationalHeapDomain>((NonRelationalHeapDomain)this.lattice, function, eval.getSubstitution());
    }

    @Override
    protected HeapEnvironment<T> assumeSatisfied(T eval) {
        return new HeapEnvironment<NonRelationalHeapDomain>((NonRelationalHeapDomain)this.lattice, this.function, eval.getSubstitution());
    }

    @Override
    protected HeapEnvironment<T> glbAux(T lattice, Map<Identifier, T> function, HeapEnvironment<T> other) {
        return new HeapEnvironment<T>(lattice, function, other.substitution);
    }

    @Override
    public HeapEnvironment<T> smallStepSemantics(SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        NonRelationalHeapDomain eval = (NonRelationalHeapDomain)((NonRelationalHeapDomain)this.lattice).eval(expression, this, pp);
        return new HeapEnvironment<NonRelationalHeapDomain>((NonRelationalHeapDomain)this.lattice, this.function, eval.getSubstitution());
    }

    @Override
    public HeapEnvironment<T> top() {
        return this.isTop() ? this : new HeapEnvironment<NonRelationalHeapDomain>((NonRelationalHeapDomain)((NonRelationalHeapDomain)this.lattice).top(), null, Collections.emptyList());
    }

    @Override
    public HeapEnvironment<T> bottom() {
        return this.isBottom() ? this : new HeapEnvironment<NonRelationalHeapDomain>((NonRelationalHeapDomain)((NonRelationalHeapDomain)this.lattice).bottom(), null, Collections.emptyList());
    }

    @Override
    protected HeapEnvironment<T> lubAux(HeapEnvironment<T> other) throws SemanticException {
        HeapEnvironment<T> lub = super.lubAux(other);
        if (lub.isTop() || lub.isBottom()) {
            return lub;
        }
        return new HeapEnvironment<NonRelationalHeapDomain>((NonRelationalHeapDomain)lub.lattice, lub.function, other.substitution);
    }

    @Override
    protected HeapEnvironment<T> wideningAux(HeapEnvironment<T> other) throws SemanticException {
        HeapEnvironment<T> widen = super.wideningAux(other);
        if (widen.isTop() || widen.isBottom()) {
            return widen;
        }
        return new HeapEnvironment<NonRelationalHeapDomain>((NonRelationalHeapDomain)widen.lattice, widen.function, other.substitution);
    }

    @Override
    protected boolean lessOrEqualAux(HeapEnvironment<T> other) throws SemanticException {
        return super.lessOrEqualAux(other);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.substitution == null ? 0 : this.substitution.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HeapEnvironment other = (HeapEnvironment)obj;
        return !(this.substitution == null ? other.substitution != null : !this.substitution.equals(other.substitution));
    }
}

