/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.nonrelational.inference;

import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.SemanticDomain;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.nonrelational.inference.InferenceSystem;
import it.unive.lisa.analysis.nonrelational.inference.InferredValue;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.ExpressionVisitor;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.heap.AccessChild;
import it.unive.lisa.symbolic.heap.HeapAllocation;
import it.unive.lisa.symbolic.heap.HeapDereference;
import it.unive.lisa.symbolic.heap.HeapReference;
import it.unive.lisa.symbolic.value.BinaryExpression;
import it.unive.lisa.symbolic.value.Constant;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.NullConstant;
import it.unive.lisa.symbolic.value.PushAny;
import it.unive.lisa.symbolic.value.Skip;
import it.unive.lisa.symbolic.value.TernaryExpression;
import it.unive.lisa.symbolic.value.UnaryExpression;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.symbolic.value.operator.binary.BinaryOperator;
import it.unive.lisa.symbolic.value.operator.binary.LogicalAnd;
import it.unive.lisa.symbolic.value.operator.binary.LogicalOr;
import it.unive.lisa.symbolic.value.operator.binary.TypeCast;
import it.unive.lisa.symbolic.value.operator.binary.TypeConv;
import it.unive.lisa.symbolic.value.operator.ternary.TernaryOperator;
import it.unive.lisa.symbolic.value.operator.unary.LogicalNegation;
import it.unive.lisa.symbolic.value.operator.unary.UnaryOperator;

public abstract class BaseInferredValue<T extends BaseInferredValue<T>>
extends BaseLattice<T>
implements InferredValue<T> {
    @Override
    public SemanticDomain.Satisfiability satisfies(ValueExpression expression, InferenceSystem<T> environment, ProgramPoint pp) throws SemanticException {
        if (expression instanceof Identifier) {
            InferredValue.InferredPair<T> eval = this.evalIdentifier((Identifier)expression, environment, pp);
            return this.satisfiesAbstractValue((BaseInferredValue)eval.getInferred(), (BaseInferredValue)eval.getState(), pp);
        }
        if (expression instanceof NullConstant) {
            return this.satisfiesNullConstant((BaseInferredValue)environment.getExecutionState(), pp);
        }
        if (expression instanceof Constant) {
            return this.satisfiesNonNullConstant((Constant)expression, (BaseInferredValue)environment.getExecutionState(), pp);
        }
        if (expression instanceof PushAny) {
            return this.satisfiesPushAny((PushAny)expression, (BaseInferredValue)environment.getExecutionState());
        }
        if (expression instanceof UnaryExpression) {
            UnaryExpression unary = (UnaryExpression)expression;
            if (unary.getOperator() == LogicalNegation.INSTANCE) {
                return this.satisfies((ValueExpression)unary.getExpression(), environment, pp).negate();
            }
            InferredValue.InferredPair<T> arg = this.eval((ValueExpression)unary.getExpression(), environment, pp);
            if (arg.isBottom()) {
                return SemanticDomain.Satisfiability.BOTTOM;
            }
            return this.satisfiesUnaryExpression(unary.getOperator(), (BaseInferredValue)arg.getInferred(), (BaseInferredValue)environment.getExecutionState(), pp);
        }
        if (expression instanceof BinaryExpression) {
            BinaryExpression binary = (BinaryExpression)expression;
            if (binary.getOperator() == LogicalAnd.INSTANCE) {
                return this.satisfies((ValueExpression)binary.getLeft(), environment, pp).and(this.satisfies((ValueExpression)binary.getRight(), environment, pp));
            }
            if (binary.getOperator() == LogicalOr.INSTANCE) {
                return this.satisfies((ValueExpression)binary.getLeft(), environment, pp).or(this.satisfies((ValueExpression)binary.getRight(), environment, pp));
            }
            InferredValue.InferredPair<T> left = this.eval((ValueExpression)binary.getLeft(), environment, pp);
            if (left.isBottom()) {
                return SemanticDomain.Satisfiability.BOTTOM;
            }
            InferredValue.InferredPair<T> right = this.eval((ValueExpression)binary.getRight(), environment, pp);
            if (right.isBottom()) {
                return SemanticDomain.Satisfiability.BOTTOM;
            }
            return this.satisfiesBinaryExpression(binary.getOperator(), (BaseInferredValue)left.getInferred(), (BaseInferredValue)right.getInferred(), (BaseInferredValue)environment.getExecutionState(), pp);
        }
        if (expression instanceof TernaryExpression) {
            TernaryExpression ternary = (TernaryExpression)expression;
            InferredValue.InferredPair<T> left = this.eval((ValueExpression)ternary.getLeft(), environment, pp);
            if (left.isBottom()) {
                return SemanticDomain.Satisfiability.BOTTOM;
            }
            InferredValue.InferredPair<T> middle = this.eval((ValueExpression)ternary.getMiddle(), environment, pp);
            if (middle.isBottom()) {
                return SemanticDomain.Satisfiability.BOTTOM;
            }
            InferredValue.InferredPair<T> right = this.eval((ValueExpression)ternary.getRight(), environment, pp);
            if (right.isBottom()) {
                return SemanticDomain.Satisfiability.BOTTOM;
            }
            return this.satisfiesTernaryExpression(ternary.getOperator(), (BaseInferredValue)left.getInferred(), (BaseInferredValue)middle.getInferred(), (BaseInferredValue)right.getInferred(), (BaseInferredValue)environment.getExecutionState(), pp);
        }
        return SemanticDomain.Satisfiability.UNKNOWN;
    }

    @Override
    public InferredValue.InferredPair<T> eval(ValueExpression expression, InferenceSystem<T> environment, ProgramPoint pp) throws SemanticException {
        return (InferredValue.InferredPair)expression.accept(new EvaluationVisitor(), environment, pp);
    }

    protected InferredValue.InferredPair<T> evalIdentifier(Identifier id, InferenceSystem<T> environment, ProgramPoint pp) throws SemanticException {
        return new InferredValue.InferredPair<BaseInferredValue>(this, (BaseInferredValue)environment.getState(id), (BaseInferredValue)environment.getExecutionState());
    }

    protected InferredValue.InferredPair<T> evalPushAny(PushAny pushAny, T state, ProgramPoint pp) throws SemanticException {
        BaseInferredValue top = (BaseInferredValue)this.top();
        return new InferredValue.InferredPair<BaseInferredValue>(top, top, top);
    }

    protected InferredValue.InferredPair<T> evalNullConstant(T state, ProgramPoint pp) throws SemanticException {
        BaseInferredValue top = (BaseInferredValue)this.top();
        return new InferredValue.InferredPair<BaseInferredValue>(top, top, top);
    }

    protected InferredValue.InferredPair<T> evalNonNullConstant(Constant constant, T state, ProgramPoint pp) throws SemanticException {
        BaseInferredValue top = (BaseInferredValue)this.top();
        return new InferredValue.InferredPair<BaseInferredValue>(top, top, top);
    }

    protected InferredValue.InferredPair<T> evalUnaryExpression(UnaryOperator operator, T arg, T state, ProgramPoint pp) throws SemanticException {
        BaseInferredValue top = (BaseInferredValue)this.top();
        return new InferredValue.InferredPair<BaseInferredValue>(top, top, top);
    }

    protected InferredValue.InferredPair<T> evalBinaryExpression(BinaryOperator operator, T left, T right, T state, ProgramPoint pp) throws SemanticException {
        BaseInferredValue top = (BaseInferredValue)this.top();
        return new InferredValue.InferredPair<BaseInferredValue>(top, top, top);
    }

    protected InferredValue.InferredPair<T> evalTypeConv(BinaryExpression conv, T left, T right, T state, ProgramPoint pp) throws SemanticException {
        BaseInferredValue bot = (BaseInferredValue)this.bottom();
        return conv.getRuntimeTypes().isEmpty() ? new InferredValue.InferredPair<BaseInferredValue>(bot, bot, bot) : new InferredValue.InferredPair<BaseInferredValue>(this, (BaseInferredValue)left, (BaseInferredValue)state);
    }

    protected InferredValue.InferredPair<T> evalTypeCast(BinaryExpression cast, T left, T right, T state, ProgramPoint pp) throws SemanticException {
        BaseInferredValue bot = (BaseInferredValue)this.bottom();
        return cast.getRuntimeTypes().isEmpty() ? new InferredValue.InferredPair<BaseInferredValue>(bot, bot, bot) : new InferredValue.InferredPair<BaseInferredValue>(this, (BaseInferredValue)left, (BaseInferredValue)state);
    }

    protected InferredValue.InferredPair<T> evalTernaryExpression(TernaryOperator operator, T left, T middle, T right, T state, ProgramPoint pp) throws SemanticException {
        BaseInferredValue top = (BaseInferredValue)this.top();
        return new InferredValue.InferredPair<BaseInferredValue>(top, top, top);
    }

    protected SemanticDomain.Satisfiability satisfiesAbstractValue(T value, T state, ProgramPoint pp) throws SemanticException {
        return SemanticDomain.Satisfiability.UNKNOWN;
    }

    protected SemanticDomain.Satisfiability satisfiesPushAny(PushAny pushAny, T state) throws SemanticException {
        return SemanticDomain.Satisfiability.UNKNOWN;
    }

    protected SemanticDomain.Satisfiability satisfiesNullConstant(T state, ProgramPoint pp) throws SemanticException {
        return SemanticDomain.Satisfiability.UNKNOWN;
    }

    protected SemanticDomain.Satisfiability satisfiesNonNullConstant(Constant constant, T state, ProgramPoint pp) throws SemanticException {
        return SemanticDomain.Satisfiability.UNKNOWN;
    }

    protected SemanticDomain.Satisfiability satisfiesUnaryExpression(UnaryOperator operator, T arg, T state, ProgramPoint pp) throws SemanticException {
        return SemanticDomain.Satisfiability.UNKNOWN;
    }

    protected SemanticDomain.Satisfiability satisfiesBinaryExpression(BinaryOperator operator, T left, T right, T state, ProgramPoint pp) throws SemanticException {
        return SemanticDomain.Satisfiability.UNKNOWN;
    }

    protected SemanticDomain.Satisfiability satisfiesTernaryExpression(TernaryOperator operator, T left, T middle, T right, T state, ProgramPoint pp) throws SemanticException {
        return SemanticDomain.Satisfiability.UNKNOWN;
    }

    @Override
    public final String toString() {
        return this.representation().toString();
    }

    @Override
    public boolean tracksIdentifiers(Identifier id) {
        return this.canProcess(id);
    }

    @Override
    public boolean canProcess(SymbolicExpression expression) {
        return expression.getRuntimeTypes().anyMatch(t -> !t.isPointerType() && !t.isInMemoryType());
    }

    @Override
    public InferenceSystem<T> assume(InferenceSystem<T> environment, ValueExpression expression, ProgramPoint pp) throws SemanticException {
        return environment;
    }

    @Override
    public T glb(T other) throws SemanticException {
        if (other == null || this.isBottom() || other.isTop() || this == other || this.equals(other) || this.lessOrEqual(other)) {
            return (T)this;
        }
        if (other.isBottom() || this.isTop() || ((BaseLattice)other).lessOrEqual((BaseInferredValue)this)) {
            return other;
        }
        return this.glbAux(other);
    }

    protected T glbAux(T other) throws SemanticException {
        return (T)((BaseInferredValue)this.bottom());
    }

    private class EvaluationVisitor
    implements ExpressionVisitor<InferredValue.InferredPair<T>> {
        private static final String CANNOT_PROCESS_ERROR = "Cannot process a heap expression with an inferred value domain";

        private EvaluationVisitor() {
        }

        @Override
        public InferredValue.InferredPair<T> visit(AccessChild expression, InferredValue.InferredPair<T> receiver, InferredValue.InferredPair<T> child, Object ... params) throws SemanticException {
            throw new SemanticException(CANNOT_PROCESS_ERROR);
        }

        @Override
        public InferredValue.InferredPair<T> visit(HeapAllocation expression, Object ... params) throws SemanticException {
            throw new SemanticException(CANNOT_PROCESS_ERROR);
        }

        @Override
        public InferredValue.InferredPair<T> visit(HeapReference expression, InferredValue.InferredPair<T> arg, Object ... params) throws SemanticException {
            throw new SemanticException(CANNOT_PROCESS_ERROR);
        }

        @Override
        public InferredValue.InferredPair<T> visit(HeapDereference expression, InferredValue.InferredPair<T> arg, Object ... params) throws SemanticException {
            throw new SemanticException(CANNOT_PROCESS_ERROR);
        }

        @Override
        public InferredValue.InferredPair<T> visit(UnaryExpression expression, InferredValue.InferredPair<T> arg, Object ... params) throws SemanticException {
            if (((BaseInferredValue)arg.getInferred()).isBottom()) {
                return arg;
            }
            return BaseInferredValue.this.evalUnaryExpression(expression.getOperator(), (BaseInferredValue)arg.getInferred(), (BaseInferredValue)((InferenceSystem)params[0]).getExecutionState(), (ProgramPoint)params[1]);
        }

        @Override
        public InferredValue.InferredPair<T> visit(BinaryExpression expression, InferredValue.InferredPair<T> left, InferredValue.InferredPair<T> right, Object ... params) throws SemanticException {
            if (((BaseInferredValue)left.getInferred()).isBottom()) {
                return left;
            }
            if (((BaseInferredValue)right.getInferred()).isBottom()) {
                return right;
            }
            if (expression.getOperator() == TypeCast.INSTANCE) {
                return BaseInferredValue.this.evalTypeCast(expression, (BaseInferredValue)left.getInferred(), (BaseInferredValue)right.getInferred(), (BaseInferredValue)((InferenceSystem)params[0]).getExecutionState(), (ProgramPoint)params[1]);
            }
            if (expression.getOperator() == TypeConv.INSTANCE) {
                return BaseInferredValue.this.evalTypeConv(expression, (BaseInferredValue)left.getInferred(), (BaseInferredValue)right.getInferred(), (BaseInferredValue)((InferenceSystem)params[0]).getExecutionState(), (ProgramPoint)params[1]);
            }
            return BaseInferredValue.this.evalBinaryExpression(expression.getOperator(), (BaseInferredValue)left.getInferred(), (BaseInferredValue)right.getInferred(), (BaseInferredValue)((InferenceSystem)params[0]).getExecutionState(), (ProgramPoint)params[1]);
        }

        @Override
        public InferredValue.InferredPair<T> visit(TernaryExpression expression, InferredValue.InferredPair<T> left, InferredValue.InferredPair<T> middle, InferredValue.InferredPair<T> right, Object ... params) throws SemanticException {
            if (((BaseInferredValue)left.getInferred()).isBottom()) {
                return left;
            }
            if (((BaseInferredValue)middle.getInferred()).isBottom()) {
                return middle;
            }
            if (((BaseInferredValue)right.getInferred()).isBottom()) {
                return right;
            }
            return BaseInferredValue.this.evalTernaryExpression(expression.getOperator(), (BaseInferredValue)left.getInferred(), (BaseInferredValue)middle.getInferred(), (BaseInferredValue)right.getInferred(), (BaseInferredValue)((InferenceSystem)params[0]).getExecutionState(), (ProgramPoint)params[1]);
        }

        @Override
        public InferredValue.InferredPair<T> visit(Skip expression, Object ... params) throws SemanticException {
            BaseInferredValue bot = (BaseInferredValue)BaseInferredValue.this.bottom();
            return new InferredValue.InferredPair<BaseInferredValue>(bot, bot, bot);
        }

        @Override
        public InferredValue.InferredPair<T> visit(PushAny expression, Object ... params) throws SemanticException {
            return BaseInferredValue.this.evalPushAny(expression, (BaseInferredValue)((InferenceSystem)params[0]).getExecutionState(), (ProgramPoint)params[1]);
        }

        @Override
        public InferredValue.InferredPair<T> visit(Constant expression, Object ... params) throws SemanticException {
            if (expression instanceof NullConstant) {
                return BaseInferredValue.this.evalNullConstant((BaseInferredValue)((InferenceSystem)params[0]).getExecutionState(), (ProgramPoint)params[1]);
            }
            return BaseInferredValue.this.evalNonNullConstant(expression, (BaseInferredValue)((InferenceSystem)params[0]).getExecutionState(), (ProgramPoint)params[1]);
        }

        @Override
        public InferredValue.InferredPair<T> visit(Identifier expression, Object ... params) throws SemanticException {
            return BaseInferredValue.this.evalIdentifier(expression, (InferenceSystem)params[0], (ProgramPoint)params[1]);
        }
    }
}

