/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.nonrelational.inference;

import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.nonrelational.Environment;
import it.unive.lisa.analysis.nonrelational.inference.InferredValue;
import it.unive.lisa.analysis.representation.DomainRepresentation;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.ValueExpression;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class InferenceSystem<T extends InferredValue<T>>
extends Environment<InferenceSystem<T>, ValueExpression, T, InferredValue.InferredPair<T>>
implements ValueDomain<InferenceSystem<T>> {
    private final InferredValue.InferredPair<T> inferred;

    public InferenceSystem(T domain) {
        super(domain);
        this.inferred = new InferredValue.InferredPair<InferredValue>((InferredValue)domain.bottom(), (InferredValue)domain.bottom(), (InferredValue)domain.bottom());
    }

    public InferenceSystem(InferenceSystem<T> other, T state) {
        this((InferredValue)other.lattice, other.function, new InferredValue.InferredPair<InferredValue>((InferredValue)other.lattice, (InferredValue)other.inferred.getInferred(), (InferredValue)state));
    }

    private InferenceSystem(T domain, Map<Identifier, T> function, InferredValue.InferredPair<T> inferred) {
        super(domain, function);
        this.inferred = inferred;
    }

    @Override
    protected InferenceSystem<T> mk(T lattice, Map<Identifier, T> function) {
        return new InferenceSystem<T>(lattice, function, this.inferred);
    }

    public T getExecutionState() {
        return this.inferred.getState();
    }

    public T getInferredValue() {
        return this.inferred.getInferred();
    }

    @Override
    protected InferenceSystem<T> copy() {
        return new InferenceSystem<InferredValue>((InferredValue)this.lattice, this.mkNewFunction(this.function), this.inferred);
    }

    @Override
    protected Pair<T, InferredValue.InferredPair<T>> eval(ValueExpression expression, ProgramPoint pp) throws SemanticException {
        InferredValue.InferredPair eval = ((InferredValue)this.lattice).eval(expression, this, pp);
        return Pair.of(eval.getInferred(), eval);
    }

    @Override
    protected InferenceSystem<T> assignAux(Identifier id, ValueExpression expression, Map<Identifier, T> function, T value, InferredValue.InferredPair<T> eval, ProgramPoint pp) {
        return new InferenceSystem<InferredValue>((InferredValue)this.lattice, function, new InferredValue.InferredPair<InferredValue>((InferredValue)this.lattice, (InferredValue)value, (InferredValue)eval.getState()));
    }

    @Override
    public InferenceSystem<T> smallStepSemantics(ValueExpression expression, ProgramPoint pp) throws SemanticException {
        return new InferenceSystem<InferredValue>((InferredValue)this.lattice, this.function, ((InferredValue)this.lattice).eval(expression, this, pp));
    }

    @Override
    public InferenceSystem<T> top() {
        return new InferenceSystem<InferredValue>((InferredValue)((InferredValue)this.lattice).top(), (Map<Identifier, InferredValue>)null, (InferredValue.InferredPair<InferredValue>)this.inferred.top());
    }

    @Override
    public InferenceSystem<T> bottom() {
        return new InferenceSystem<InferredValue>((InferredValue)((InferredValue)this.lattice).bottom(), (Map<Identifier, InferredValue>)null, (InferredValue.InferredPair<InferredValue>)this.inferred.bottom());
    }

    @Override
    protected InferenceSystem<T> lubAux(InferenceSystem<T> other) throws SemanticException {
        InferenceSystem<T> lub = super.lubAux(other);
        if (lub.isTop() || lub.isBottom()) {
            return lub;
        }
        return new InferenceSystem<InferredValue>((InferredValue)lub.lattice, lub.function, this.inferred.lub(other.inferred));
    }

    @Override
    protected InferenceSystem<T> wideningAux(InferenceSystem<T> other) throws SemanticException {
        InferenceSystem<T> widen = super.wideningAux(other);
        if (widen.isTop() || widen.isBottom()) {
            return widen;
        }
        return new InferenceSystem<InferredValue>((InferredValue)widen.lattice, widen.function, this.inferred.widening(other.inferred));
    }

    @Override
    protected boolean lessOrEqualAux(InferenceSystem<T> other) throws SemanticException {
        if (!super.lessOrEqualAux(other)) {
            return false;
        }
        return this.inferred.lessOrEqual(other.inferred);
    }

    @Override
    protected InferenceSystem<T> assumeSatisfied(InferredValue.InferredPair<T> eval) {
        return new InferenceSystem<InferredValue>((InferredValue)this.lattice, this.function, new InferredValue.InferredPair<InferredValue>((InferredValue)this.lattice, (InferredValue)eval.getInferred(), (InferredValue)eval.getState()));
    }

    @Override
    protected InferenceSystem<T> glbAux(T lattice, Map<Identifier, T> function, InferenceSystem<T> other) {
        return new InferenceSystem<T>(lattice, function, new InferredValue.InferredPair<T>(lattice, this.getInferredValue(), other.getExecutionState()));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.inferred == null ? 0 : this.inferred.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InferenceSystem other = (InferenceSystem)obj;
        return !(this.inferred == null ? other.inferred != null : !this.inferred.equals(other.inferred));
    }

    @Override
    public DomainRepresentation representation() {
        if (this.isBottom() || this.isTop()) {
            return super.representation();
        }
        return new SystemRepresentation(super.representation(), this.inferred.representation());
    }

    private static class SystemRepresentation
    extends DomainRepresentation {
        private final DomainRepresentation map;
        private final DomainRepresentation inferred;

        public SystemRepresentation(DomainRepresentation map, DomainRepresentation inferred) {
            this.map = map;
            this.inferred = inferred;
        }

        @Override
        public String toString() {
            return this.map + "\n[" + this.inferred + "]";
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.inferred == null ? 0 : this.inferred.hashCode());
            result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SystemRepresentation other = (SystemRepresentation)obj;
            if (this.inferred == null ? other.inferred != null : !this.inferred.equals(other.inferred)) {
                return false;
            }
            return !(this.map == null ? other.map != null : !this.map.equals(other.map));
        }
    }
}

