/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.nonrelational.value;

import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.SemanticDomain;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.nonrelational.value.NonRelationalValueDomain;
import it.unive.lisa.analysis.nonrelational.value.ValueEnvironment;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.ExpressionVisitor;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.heap.AccessChild;
import it.unive.lisa.symbolic.heap.HeapAllocation;
import it.unive.lisa.symbolic.heap.HeapDereference;
import it.unive.lisa.symbolic.heap.HeapReference;
import it.unive.lisa.symbolic.value.BinaryExpression;
import it.unive.lisa.symbolic.value.Constant;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.NullConstant;
import it.unive.lisa.symbolic.value.PushAny;
import it.unive.lisa.symbolic.value.Skip;
import it.unive.lisa.symbolic.value.TernaryExpression;
import it.unive.lisa.symbolic.value.UnaryExpression;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.symbolic.value.operator.binary.BinaryOperator;
import it.unive.lisa.symbolic.value.operator.binary.LogicalAnd;
import it.unive.lisa.symbolic.value.operator.binary.LogicalOr;
import it.unive.lisa.symbolic.value.operator.binary.TypeCast;
import it.unive.lisa.symbolic.value.operator.binary.TypeConv;
import it.unive.lisa.symbolic.value.operator.ternary.TernaryOperator;
import it.unive.lisa.symbolic.value.operator.unary.LogicalNegation;
import it.unive.lisa.symbolic.value.operator.unary.UnaryOperator;

public abstract class BaseNonRelationalValueDomain<T extends BaseNonRelationalValueDomain<T>>
extends BaseLattice<T>
implements NonRelationalValueDomain<T> {
    @Override
    public SemanticDomain.Satisfiability satisfies(ValueExpression expression, ValueEnvironment<T> environment, ProgramPoint pp) throws SemanticException {
        if (expression instanceof Identifier) {
            return this.satisfiesAbstractValue((BaseNonRelationalValueDomain)environment.getState((Identifier)expression), pp);
        }
        if (expression instanceof NullConstant) {
            return this.satisfiesNullConstant(pp);
        }
        if (expression instanceof Constant) {
            return this.satisfiesNonNullConstant((Constant)expression, pp);
        }
        if (expression instanceof UnaryExpression) {
            UnaryExpression unary = (UnaryExpression)expression;
            if (unary.getOperator() == LogicalNegation.INSTANCE) {
                return this.satisfies((ValueExpression)unary.getExpression(), environment, pp).negate();
            }
            T arg = this.eval((ValueExpression)unary.getExpression(), environment, pp);
            if (arg.isBottom()) {
                return SemanticDomain.Satisfiability.BOTTOM;
            }
            return this.satisfiesUnaryExpression(unary.getOperator(), arg, pp);
        }
        if (expression instanceof BinaryExpression) {
            BinaryExpression binary = (BinaryExpression)expression;
            if (binary.getOperator() == LogicalAnd.INSTANCE) {
                return this.satisfies((ValueExpression)binary.getLeft(), environment, pp).and(this.satisfies((ValueExpression)binary.getRight(), environment, pp));
            }
            if (binary.getOperator() == LogicalOr.INSTANCE) {
                return this.satisfies((ValueExpression)binary.getLeft(), environment, pp).or(this.satisfies((ValueExpression)binary.getRight(), environment, pp));
            }
            T left = this.eval((ValueExpression)binary.getLeft(), environment, pp);
            if (left.isBottom()) {
                return SemanticDomain.Satisfiability.BOTTOM;
            }
            T right = this.eval((ValueExpression)binary.getRight(), environment, pp);
            if (right.isBottom()) {
                return SemanticDomain.Satisfiability.BOTTOM;
            }
            return this.satisfiesBinaryExpression(binary.getOperator(), left, right, pp);
        }
        if (expression instanceof TernaryExpression) {
            TernaryExpression ternary = (TernaryExpression)expression;
            T left = this.eval((ValueExpression)ternary.getLeft(), environment, pp);
            if (left.isBottom()) {
                return SemanticDomain.Satisfiability.BOTTOM;
            }
            T middle = this.eval((ValueExpression)ternary.getMiddle(), environment, pp);
            if (middle.isBottom()) {
                return SemanticDomain.Satisfiability.BOTTOM;
            }
            T right = this.eval((ValueExpression)ternary.getRight(), environment, pp);
            if (right.isBottom()) {
                return SemanticDomain.Satisfiability.BOTTOM;
            }
            return this.satisfiesTernaryExpression(ternary.getOperator(), left, middle, right, pp);
        }
        return SemanticDomain.Satisfiability.UNKNOWN;
    }

    @Override
    public T eval(ValueExpression expression, ValueEnvironment<T> environment, ProgramPoint pp) throws SemanticException {
        return (T)((BaseNonRelationalValueDomain)expression.accept(new EvaluationVisitor(), environment, pp));
    }

    @Override
    public boolean tracksIdentifiers(Identifier id) {
        return this.canProcess(id);
    }

    @Override
    public boolean canProcess(SymbolicExpression expression) {
        return expression.getRuntimeTypes().anyMatch(t -> !t.isPointerType() && !t.isInMemoryType());
    }

    protected T evalIdentifier(Identifier id, ValueEnvironment<T> environment, ProgramPoint pp) throws SemanticException {
        return (T)((BaseNonRelationalValueDomain)environment.getState(id));
    }

    protected T evalPushAny(PushAny pushAny, ProgramPoint pp) throws SemanticException {
        return (T)((BaseNonRelationalValueDomain)this.top());
    }

    protected T evalTypeConv(BinaryExpression conv, T left, T right, ProgramPoint pp) throws SemanticException {
        return (T)(conv.getRuntimeTypes().isEmpty() ? (BaseNonRelationalValueDomain)this.bottom() : left);
    }

    protected T evalTypeCast(BinaryExpression cast, T left, T right, ProgramPoint pp) throws SemanticException {
        return (T)(cast.getRuntimeTypes().isEmpty() ? (BaseNonRelationalValueDomain)this.bottom() : left);
    }

    protected T evalNullConstant(ProgramPoint pp) throws SemanticException {
        return (T)((BaseNonRelationalValueDomain)this.top());
    }

    protected T evalNonNullConstant(Constant constant, ProgramPoint pp) throws SemanticException {
        return (T)((BaseNonRelationalValueDomain)this.top());
    }

    protected T evalUnaryExpression(UnaryOperator operator, T arg, ProgramPoint pp) throws SemanticException {
        return (T)((BaseNonRelationalValueDomain)this.top());
    }

    protected T evalBinaryExpression(BinaryOperator operator, T left, T right, ProgramPoint pp) throws SemanticException {
        return (T)((BaseNonRelationalValueDomain)this.top());
    }

    protected T evalTernaryExpression(TernaryOperator operator, T left, T middle, T right, ProgramPoint pp) throws SemanticException {
        return (T)((BaseNonRelationalValueDomain)this.top());
    }

    protected SemanticDomain.Satisfiability satisfiesAbstractValue(T value, ProgramPoint pp) throws SemanticException {
        return SemanticDomain.Satisfiability.UNKNOWN;
    }

    protected SemanticDomain.Satisfiability satisfiesNullConstant(ProgramPoint pp) throws SemanticException {
        return SemanticDomain.Satisfiability.UNKNOWN;
    }

    protected SemanticDomain.Satisfiability satisfiesNonNullConstant(Constant constant, ProgramPoint pp) throws SemanticException {
        return SemanticDomain.Satisfiability.UNKNOWN;
    }

    protected SemanticDomain.Satisfiability satisfiesUnaryExpression(UnaryOperator operator, T arg, ProgramPoint pp) throws SemanticException {
        return SemanticDomain.Satisfiability.UNKNOWN;
    }

    protected SemanticDomain.Satisfiability satisfiesBinaryExpression(BinaryOperator operator, T left, T right, ProgramPoint pp) throws SemanticException {
        return SemanticDomain.Satisfiability.UNKNOWN;
    }

    protected SemanticDomain.Satisfiability satisfiesTernaryExpression(TernaryOperator operator, T left, T middle, T right, ProgramPoint pp) throws SemanticException {
        return SemanticDomain.Satisfiability.UNKNOWN;
    }

    @Override
    public final String toString() {
        return this.representation().toString();
    }

    @Override
    public ValueEnvironment<T> assume(ValueEnvironment<T> environment, ValueExpression expression, ProgramPoint pp) throws SemanticException {
        if (expression instanceof UnaryExpression) {
            ValueExpression rewritten;
            UnaryExpression unary = (UnaryExpression)expression;
            if (unary.getOperator() == LogicalNegation.INSTANCE && (rewritten = unary.removeNegations()) != unary) {
                return this.assume(environment, rewritten, pp);
            }
            return this.assumeUnaryExpression(environment, unary.getOperator(), (ValueExpression)unary.getExpression(), pp);
        }
        if (expression instanceof BinaryExpression) {
            BinaryExpression binary = (BinaryExpression)expression;
            if (binary.getOperator() == LogicalAnd.INSTANCE) {
                return this.assume(environment, (ValueExpression)binary.getLeft(), pp).glb(this.assume(environment, (ValueExpression)binary.getRight(), pp));
            }
            if (binary.getOperator() == LogicalOr.INSTANCE) {
                return this.assume(environment, (ValueExpression)binary.getLeft(), pp).lub(this.assume(environment, (ValueExpression)binary.getRight(), pp));
            }
            return this.assumeBinaryExpression(environment, binary.getOperator(), (ValueExpression)binary.getLeft(), (ValueExpression)binary.getRight(), pp);
        }
        if (expression instanceof TernaryExpression) {
            TernaryExpression ternary = (TernaryExpression)expression;
            return this.assumeTernaryExpression(environment, ternary.getOperator(), (ValueExpression)ternary.getLeft(), (ValueExpression)ternary.getMiddle(), (ValueExpression)ternary.getRight(), pp);
        }
        return environment;
    }

    protected ValueEnvironment<T> assumeTernaryExpression(ValueEnvironment<T> environment, TernaryOperator operator, ValueExpression left, ValueExpression middle, ValueExpression right, ProgramPoint pp) throws SemanticException {
        return environment;
    }

    protected ValueEnvironment<T> assumeBinaryExpression(ValueEnvironment<T> environment, BinaryOperator operator, ValueExpression left, ValueExpression right, ProgramPoint pp) throws SemanticException {
        return environment;
    }

    protected ValueEnvironment<T> assumeUnaryExpression(ValueEnvironment<T> environment, UnaryOperator operator, ValueExpression expression, ProgramPoint pp) throws SemanticException {
        return environment;
    }

    @Override
    public T glb(T other) throws SemanticException {
        if (other == null || this.isBottom() || other.isTop() || this == other || this.equals(other) || this.lessOrEqual(other)) {
            return (T)this;
        }
        if (other.isBottom() || this.isTop() || ((BaseLattice)other).lessOrEqual((BaseNonRelationalValueDomain)this)) {
            return other;
        }
        return this.glbAux(other);
    }

    protected T glbAux(T other) throws SemanticException {
        return (T)((BaseNonRelationalValueDomain)this.bottom());
    }

    private class EvaluationVisitor
    implements ExpressionVisitor<T> {
        private static final String CANNOT_PROCESS_ERROR = "Cannot process a heap expression with a non-relational value domain";

        private EvaluationVisitor() {
        }

        @Override
        public T visit(AccessChild expression, T receiver, T child, Object ... params) throws SemanticException {
            throw new SemanticException(CANNOT_PROCESS_ERROR);
        }

        @Override
        public T visit(HeapAllocation expression, Object ... params) throws SemanticException {
            throw new SemanticException(CANNOT_PROCESS_ERROR);
        }

        @Override
        public T visit(HeapReference expression, T arg, Object ... params) throws SemanticException {
            throw new SemanticException(CANNOT_PROCESS_ERROR);
        }

        @Override
        public T visit(HeapDereference expression, T arg, Object ... params) throws SemanticException {
            throw new SemanticException(CANNOT_PROCESS_ERROR);
        }

        @Override
        public T visit(UnaryExpression expression, T arg, Object ... params) throws SemanticException {
            if (arg.isBottom()) {
                return arg;
            }
            return BaseNonRelationalValueDomain.this.evalUnaryExpression(expression.getOperator(), arg, (ProgramPoint)params[1]);
        }

        @Override
        public T visit(BinaryExpression expression, T left, T right, Object ... params) throws SemanticException {
            if (left.isBottom()) {
                return left;
            }
            if (right.isBottom()) {
                return right;
            }
            if (expression.getOperator() == TypeCast.INSTANCE) {
                return BaseNonRelationalValueDomain.this.evalTypeCast(expression, left, right, (ProgramPoint)params[1]);
            }
            if (expression.getOperator() == TypeConv.INSTANCE) {
                return BaseNonRelationalValueDomain.this.evalTypeConv(expression, left, right, (ProgramPoint)params[1]);
            }
            return BaseNonRelationalValueDomain.this.evalBinaryExpression(expression.getOperator(), left, right, (ProgramPoint)params[1]);
        }

        @Override
        public T visit(TernaryExpression expression, T left, T middle, T right, Object ... params) throws SemanticException {
            if (left.isBottom()) {
                return left;
            }
            if (middle.isBottom()) {
                return middle;
            }
            if (right.isBottom()) {
                return right;
            }
            return BaseNonRelationalValueDomain.this.evalTernaryExpression(expression.getOperator(), left, middle, right, (ProgramPoint)params[1]);
        }

        @Override
        public T visit(Skip expression, Object ... params) throws SemanticException {
            return (BaseNonRelationalValueDomain)BaseNonRelationalValueDomain.this.bottom();
        }

        @Override
        public T visit(PushAny expression, Object ... params) throws SemanticException {
            return BaseNonRelationalValueDomain.this.evalPushAny(expression, (ProgramPoint)params[1]);
        }

        @Override
        public T visit(Constant expression, Object ... params) throws SemanticException {
            if (expression instanceof NullConstant) {
                return BaseNonRelationalValueDomain.this.evalNullConstant((ProgramPoint)params[1]);
            }
            return BaseNonRelationalValueDomain.this.evalNonNullConstant(expression, (ProgramPoint)params[1]);
        }

        @Override
        public T visit(Identifier expression, Object ... params) throws SemanticException {
            return BaseNonRelationalValueDomain.this.evalIdentifier(expression, (ValueEnvironment)params[0], (ProgramPoint)params[1]);
        }
    }
}

