/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.nonrelational.value;

import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.nonrelational.Environment;
import it.unive.lisa.analysis.nonrelational.value.NonRelationalTypeDomain;
import it.unive.lisa.analysis.representation.DomainRepresentation;
import it.unive.lisa.analysis.value.TypeDomain;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.type.Type;
import it.unive.lisa.type.Untyped;
import it.unive.lisa.util.collections.externalSet.ExternalSet;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class TypeEnvironment<T extends NonRelationalTypeDomain<T>>
extends Environment<TypeEnvironment<T>, ValueExpression, T, T>
implements TypeDomain<TypeEnvironment<T>> {
    private final T stack;

    public TypeEnvironment(T domain) {
        super(domain);
        this.stack = (NonRelationalTypeDomain)domain.bottom();
    }

    private TypeEnvironment(T domain, Map<Identifier, T> function, T stack) {
        super(domain, function);
        this.stack = stack;
    }

    @Override
    protected TypeEnvironment<T> mk(T lattice, Map<Identifier, T> function) {
        return new TypeEnvironment<T>(lattice, function, this.stack);
    }

    @Override
    protected TypeEnvironment<T> copy() {
        return new TypeEnvironment<NonRelationalTypeDomain>((NonRelationalTypeDomain)this.lattice, this.mkNewFunction(this.function), (NonRelationalTypeDomain)this.stack);
    }

    @Override
    protected Pair<T, T> eval(ValueExpression expression, ProgramPoint pp) throws SemanticException {
        NonRelationalTypeDomain eval = (NonRelationalTypeDomain)((NonRelationalTypeDomain)this.lattice).eval(expression, this, pp);
        return Pair.of((Object)eval, (Object)eval);
    }

    @Override
    protected TypeEnvironment<T> assignAux(Identifier id, ValueExpression expression, Map<Identifier, T> function, T value, T eval, ProgramPoint pp) {
        return new TypeEnvironment<NonRelationalTypeDomain>((NonRelationalTypeDomain)this.lattice, (Map<Identifier, NonRelationalTypeDomain>)function, (NonRelationalTypeDomain)value);
    }

    @Override
    public TypeEnvironment<T> smallStepSemantics(ValueExpression expression, ProgramPoint pp) throws SemanticException {
        return new TypeEnvironment<NonRelationalTypeDomain>((NonRelationalTypeDomain)this.lattice, this.function, (NonRelationalTypeDomain)((NonRelationalTypeDomain)this.lattice).eval(expression, this, pp));
    }

    @Override
    protected TypeEnvironment<T> assumeSatisfied(T eval) {
        return this;
    }

    @Override
    protected TypeEnvironment<T> glbAux(T lattice, Map<Identifier, T> function, TypeEnvironment<T> other) throws SemanticException {
        return new TypeEnvironment<NonRelationalTypeDomain>((NonRelationalTypeDomain)lattice, (Map<Identifier, NonRelationalTypeDomain>)function, (NonRelationalTypeDomain)this.stack.glb(other.stack));
    }

    @Override
    public TypeEnvironment<T> top() {
        return this.isTop() ? this : new TypeEnvironment<NonRelationalTypeDomain>((NonRelationalTypeDomain)((NonRelationalTypeDomain)this.lattice).top(), null, (NonRelationalTypeDomain)((NonRelationalTypeDomain)this.lattice).top());
    }

    @Override
    public TypeEnvironment<T> bottom() {
        return this.isBottom() ? this : new TypeEnvironment<NonRelationalTypeDomain>((NonRelationalTypeDomain)((NonRelationalTypeDomain)this.lattice).bottom(), null, (NonRelationalTypeDomain)((NonRelationalTypeDomain)this.lattice).bottom());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.stack == null ? 0 : this.stack.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof TypeEnvironment)) {
            return false;
        }
        TypeEnvironment other = (TypeEnvironment)obj;
        return !(this.stack == null ? other.stack != null : !this.stack.equals(other.stack));
    }

    @Override
    public DomainRepresentation representation() {
        if (this.isBottom() || this.isTop()) {
            return super.representation();
        }
        return new ValueRepresentation(super.representation(), this.stack.representation());
    }

    @Override
    public ExternalSet<Type> getInferredRuntimeTypes() {
        return this.stack.getRuntimeTypes();
    }

    @Override
    public Type getInferredDynamicType() {
        ExternalSet<Type> types = this.stack.getRuntimeTypes();
        if (this.stack.isTop() || this.stack.isBottom() || types.isEmpty()) {
            return Untyped.INSTANCE;
        }
        return types.reduce(types.first(), (result, t) -> result.commonSupertype((Type)t));
    }

    private static class ValueRepresentation
    extends DomainRepresentation {
        private final DomainRepresentation map;
        private final DomainRepresentation stack;

        public ValueRepresentation(DomainRepresentation map, DomainRepresentation stack) {
            this.map = map;
            this.stack = stack;
        }

        @Override
        public String toString() {
            return this.map + "\n[stack: " + this.stack + "]";
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.stack == null ? 0 : this.stack.hashCode());
            result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ValueRepresentation other = (ValueRepresentation)obj;
            if (this.stack == null ? other.stack != null : !this.stack.equals(other.stack)) {
                return false;
            }
            return !(this.map == null ? other.map != null : !this.map.equals(other.map));
        }
    }
}

