/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.nonrelational.value;

import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.nonrelational.Environment;
import it.unive.lisa.analysis.nonrelational.value.NonRelationalValueDomain;
import it.unive.lisa.analysis.representation.DomainRepresentation;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.ValueExpression;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class ValueEnvironment<T extends NonRelationalValueDomain<T>>
extends Environment<ValueEnvironment<T>, ValueExpression, T, T>
implements ValueDomain<ValueEnvironment<T>> {
    private final T stack;

    public ValueEnvironment(T domain) {
        super(domain);
        this.stack = (NonRelationalValueDomain)domain.bottom();
    }

    private ValueEnvironment(T domain, Map<Identifier, T> function, T stack) {
        super(domain, function);
        this.stack = stack;
    }

    public T getValueOnStack() {
        return this.stack;
    }

    @Override
    protected ValueEnvironment<T> mk(T lattice, Map<Identifier, T> function) {
        return new ValueEnvironment<T>(lattice, function, this.stack);
    }

    @Override
    protected ValueEnvironment<T> copy() {
        return new ValueEnvironment<NonRelationalValueDomain>((NonRelationalValueDomain)this.lattice, this.mkNewFunction(this.function), (NonRelationalValueDomain)this.stack);
    }

    @Override
    protected Pair<T, T> eval(ValueExpression expression, ProgramPoint pp) throws SemanticException {
        NonRelationalValueDomain eval = (NonRelationalValueDomain)((NonRelationalValueDomain)this.lattice).eval(expression, this, pp);
        return Pair.of((Object)eval, (Object)eval);
    }

    @Override
    protected ValueEnvironment<T> assignAux(Identifier id, ValueExpression expression, Map<Identifier, T> function, T value, T eval, ProgramPoint pp) {
        return new ValueEnvironment<NonRelationalValueDomain>((NonRelationalValueDomain)this.lattice, (Map<Identifier, NonRelationalValueDomain>)function, (NonRelationalValueDomain)value);
    }

    @Override
    public ValueEnvironment<T> smallStepSemantics(ValueExpression expression, ProgramPoint pp) throws SemanticException {
        return new ValueEnvironment<NonRelationalValueDomain>((NonRelationalValueDomain)this.lattice, this.function, (NonRelationalValueDomain)((NonRelationalValueDomain)this.lattice).eval(expression, this, pp));
    }

    @Override
    protected ValueEnvironment<T> assumeSatisfied(T eval) {
        return this;
    }

    @Override
    protected ValueEnvironment<T> glbAux(T lattice, Map<Identifier, T> function, ValueEnvironment<T> other) throws SemanticException {
        return new ValueEnvironment<NonRelationalValueDomain>((NonRelationalValueDomain)lattice, (Map<Identifier, NonRelationalValueDomain>)function, (NonRelationalValueDomain)this.stack.glb(other.stack));
    }

    @Override
    public ValueEnvironment<T> top() {
        return this.isTop() ? this : new ValueEnvironment<NonRelationalValueDomain>((NonRelationalValueDomain)((NonRelationalValueDomain)this.lattice).top(), null, (NonRelationalValueDomain)((NonRelationalValueDomain)this.lattice).top());
    }

    @Override
    public ValueEnvironment<T> bottom() {
        return this.isBottom() ? this : new ValueEnvironment<NonRelationalValueDomain>((NonRelationalValueDomain)((NonRelationalValueDomain)this.lattice).bottom(), null, (NonRelationalValueDomain)((NonRelationalValueDomain)this.lattice).bottom());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.stack == null ? 0 : this.stack.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ValueEnvironment)) {
            return false;
        }
        ValueEnvironment other = (ValueEnvironment)obj;
        return !(this.stack == null ? other.stack != null : !this.stack.equals(other.stack));
    }

    @Override
    public DomainRepresentation representation() {
        if (this.isBottom() || this.isTop()) {
            return super.representation();
        }
        return new ValueRepresentation(super.representation(), this.stack.representation());
    }

    private static class ValueRepresentation
    extends DomainRepresentation {
        private final DomainRepresentation map;
        private final DomainRepresentation stack;

        public ValueRepresentation(DomainRepresentation map, DomainRepresentation stack) {
            this.map = map;
            this.stack = stack;
        }

        @Override
        public String toString() {
            return this.map + "\n[stack: " + this.stack + "]";
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.stack == null ? 0 : this.stack.hashCode());
            result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ValueRepresentation other = (ValueRepresentation)obj;
            if (this.stack == null ? other.stack != null : !this.stack.equals(other.stack)) {
                return false;
            }
            return !(this.map == null ? other.map != null : !this.map.equals(other.map));
        }
    }
}

