/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.value;

import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticDomain;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.heap.HeapSemanticOperation;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.ValueExpression;
import java.util.List;

public interface ValueDomain<D extends ValueDomain<D>>
extends SemanticDomain<D, ValueExpression, Identifier>,
Lattice<D> {
    default public D applySubstitution(List<HeapSemanticOperation.HeapReplacement> substitution, ProgramPoint pp) throws SemanticException {
        if (this.isTop() || this.isBottom() || substitution == null || substitution.isEmpty()) {
            return (D)this;
        }
        ValueDomain result = this;
        for (HeapSemanticOperation.HeapReplacement r : substitution) {
            if (r.getSources().isEmpty()) continue;
            ValueDomain lub = (ValueDomain)this.bottom();
            for (Identifier source : r.getSources()) {
                ValueDomain partial = result;
                for (Identifier target : r.getTargets()) {
                    partial = (ValueDomain)partial.assign(target, source, pp);
                }
                lub = lub.lub(partial);
            }
            result = (ValueDomain)lub.forgetIdentifiers(r.getIdsToForget());
        }
        return (D)result;
    }
}

