/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.checks;

import it.unive.lisa.checks.Check;
import it.unive.lisa.logging.IterationLogger;
import it.unive.lisa.program.CompilationUnit;
import it.unive.lisa.program.Global;
import it.unive.lisa.program.Program;
import it.unive.lisa.program.cfg.CFG;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ChecksExecutor {
    private static final Logger LOG = LogManager.getLogger(ChecksExecutor.class);

    private ChecksExecutor() {
    }

    public static <C extends Check<T>, T> void executeAll(T tool, Program program, Iterable<C> checks) {
        checks.forEach(c -> c.beforeExecution(tool));
        for (Global global : IterationLogger.iterate(LOG, program.getGlobals(), "Analyzing program globals...", "Globals")) {
            checks.forEach(c -> c.visitGlobal(tool, program, global, false));
        }
        for (CFG cfg : IterationLogger.iterate(LOG, program.getCFGs(), "Analyzing program cfgs...", "CFGs")) {
            checks.forEach(c -> cfg.accept(c, tool));
        }
        for (CompilationUnit unit : IterationLogger.iterate(LOG, program.getUnits(), "Analyzing compilation units...", "Units")) {
            checks.forEach(c -> ChecksExecutor.visitUnit(tool, unit, c));
        }
        checks.forEach(c -> c.afterExecution(tool));
    }

    private static <C extends Check<T>, T> void visitUnit(T tool, CompilationUnit unit, C c) {
        if (!c.visitCompilationUnit(tool, unit)) {
            return;
        }
        for (Global global : unit.getGlobals()) {
            c.visitGlobal(tool, unit, global, false);
        }
        for (Global global : unit.getInstanceGlobals(false)) {
            c.visitGlobal(tool, unit, global, true);
        }
        for (CFG cfg : unit.getCFGs()) {
            cfg.accept(c, tool);
        }
        for (CFG cfg : unit.getInstanceCFGs(false)) {
            cfg.accept(c, tool);
        }
    }
}

