/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.checks.semantic;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.CFGWithAnalysisResults;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.value.TypeDomain;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.checks.syntactic.CheckTool;
import it.unive.lisa.interprocedural.callgraph.CallGraph;
import it.unive.lisa.interprocedural.callgraph.CallResolutionException;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeMember;
import it.unive.lisa.program.cfg.statement.call.Call;
import it.unive.lisa.program.cfg.statement.call.UnresolvedCall;
import java.util.Collection;
import java.util.Map;

public class CheckToolWithAnalysisResults<A extends AbstractState<A, H, V, T>, H extends HeapDomain<H>, V extends ValueDomain<V>, T extends TypeDomain<T>>
extends CheckTool {
    private final Map<CFG, Collection<CFGWithAnalysisResults<A, H, V, T>>> results;
    private final CallGraph callgraph;

    public CheckToolWithAnalysisResults(Map<CFG, Collection<CFGWithAnalysisResults<A, H, V, T>>> results, CallGraph callgraph) {
        this.results = results;
        this.callgraph = callgraph;
    }

    public CheckToolWithAnalysisResults(CheckTool other, Map<CFG, Collection<CFGWithAnalysisResults<A, H, V, T>>> results, CallGraph callgraph) {
        super(other);
        this.results = results;
        this.callgraph = callgraph;
    }

    public Collection<CFGWithAnalysisResults<A, H, V, T>> getResultOf(CFG cfg) {
        return this.results.get(cfg);
    }

    public Collection<CodeMember> getCallers(CodeMember cm) {
        return this.callgraph.getCallers(cm);
    }

    public Collection<CodeMember> getCallees(CodeMember cm) {
        return this.callgraph.getCallees(cm);
    }

    public Collection<Call> getCallSites(CodeMember cm) {
        return this.callgraph.getCallSites(cm);
    }

    public Call getResolvedVersion(UnresolvedCall call) {
        try {
            return this.callgraph.resolve(call, null, null);
        }
        catch (CallResolutionException e) {
            return null;
        }
    }
}

