/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.checks.warnings;

import it.unive.lisa.checks.warnings.Warning;
import it.unive.lisa.program.cfg.CodeLocation;
import java.util.Objects;

public abstract class WarningWithLocation
extends Warning {
    private final CodeLocation location;

    protected WarningWithLocation(CodeLocation location, String message) {
        super(message);
        Objects.requireNonNull(location, "The location of a warning with location cannot be null");
        this.location = location;
    }

    public final CodeLocation getLocation() {
        return this.location;
    }

    public final String getLocationWithBrackets() {
        return "[" + this.getLocation() + "]";
    }

    @Override
    public int compareTo(Warning o) {
        if (!(o instanceof WarningWithLocation)) {
            return super.compareTo(o);
        }
        WarningWithLocation other = (WarningWithLocation)o;
        int cmp = this.location.compareTo(other.location);
        if (cmp != 0) {
            return cmp;
        }
        return super.compareTo(other);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WarningWithLocation other = (WarningWithLocation)obj;
        return !(this.location == null ? other.location != null : !this.location.equals(other.location));
    }

    @Override
    public abstract String toString();
}

