/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.interprocedural.callgraph;

import it.unive.lisa.analysis.symbols.Aliases;
import it.unive.lisa.analysis.symbols.NameSymbol;
import it.unive.lisa.analysis.symbols.QualifiedNameSymbol;
import it.unive.lisa.analysis.symbols.QualifierSymbol;
import it.unive.lisa.analysis.symbols.SymbolAliasing;
import it.unive.lisa.interprocedural.callgraph.CallGraph;
import it.unive.lisa.interprocedural.callgraph.CallGraphConstructionException;
import it.unive.lisa.interprocedural.callgraph.CallGraphEdge;
import it.unive.lisa.interprocedural.callgraph.CallGraphNode;
import it.unive.lisa.interprocedural.callgraph.CallResolutionException;
import it.unive.lisa.outputs.DotGraph;
import it.unive.lisa.program.CompilationUnit;
import it.unive.lisa.program.Program;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CFGDescriptor;
import it.unive.lisa.program.cfg.CodeMember;
import it.unive.lisa.program.cfg.NativeCFG;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.VariableRef;
import it.unive.lisa.program.cfg.statement.call.CFGCall;
import it.unive.lisa.program.cfg.statement.call.Call;
import it.unive.lisa.program.cfg.statement.call.MultiCall;
import it.unive.lisa.program.cfg.statement.call.NativeCall;
import it.unive.lisa.program.cfg.statement.call.OpenCall;
import it.unive.lisa.program.cfg.statement.call.TruncatedParamsCall;
import it.unive.lisa.program.cfg.statement.call.UnresolvedCall;
import it.unive.lisa.type.Type;
import it.unive.lisa.type.UnitType;
import it.unive.lisa.util.collections.externalSet.ExternalSet;
import it.unive.lisa.util.datastructures.graph.Graph;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BaseCallGraph
extends Graph<BaseCallGraph, CallGraphNode, CallGraphEdge>
implements CallGraph {
    private static final Logger LOG = LogManager.getLogger(BaseCallGraph.class);
    private Program program;
    private final Map<CodeMember, Collection<Call>> callsites = new HashMap<CodeMember, Collection<Call>>();
    private final Map<UnresolvedCall, Call> resolvedCache = new IdentityHashMap<UnresolvedCall, Call>();

    @Override
    public void init(Program program) throws CallGraphConstructionException {
        this.program = program;
    }

    @Override
    public void registerCall(CFGCall call) {
        if (call.getSource() != null) {
            return;
        }
        CallGraphNode source = new CallGraphNode(this, call.getCFG());
        if (!this.adjacencyMatrix.containsNode(source)) {
            this.addNode(source, this.program.getEntryPoints().contains(call.getCFG()));
        }
        for (CFG cfg : call.getTargets()) {
            this.callsites.computeIfAbsent(cfg, cm -> new HashSet()).add(call);
            CallGraphNode t = new CallGraphNode(this, cfg);
            if (!this.adjacencyMatrix.containsNode(t)) {
                this.addNode(t, this.program.getEntryPoints().contains(call.getCFG()));
            }
            this.addEdge(new CallGraphEdge(source, t));
        }
    }

    @Override
    public Call resolve(UnresolvedCall call, ExternalSet<Type>[] types, SymbolAliasing aliasing) throws CallResolutionException {
        CallGraphNode t;
        Call cached = this.resolvedCache.get(call);
        if (cached != null) {
            return cached;
        }
        if (types == null) {
            throw new CallResolutionException("Cannot resolve call without runtime types");
        }
        if (aliasing == null) {
            throw new CallResolutionException("Cannot resolve call without symbol aliasing");
        }
        HashSet<CFG> targets = new HashSet<CFG>();
        HashSet<NativeCFG> nativeTargets = new HashSet<NativeCFG>();
        HashSet<CFG> targetsNoRec = new HashSet<CFG>();
        HashSet<NativeCFG> nativeTargetsNoRec = new HashSet<NativeCFG>();
        Expression[] params = call.getParameters();
        switch (call.getCallType()) {
            case INSTANCE: {
                this.resolveInstance(call, types, targets, nativeTargets, aliasing);
                break;
            }
            case STATIC: {
                this.resolveNonInstance(call, types, targets, nativeTargets, aliasing);
                break;
            }
            default: {
                UnresolvedCall tempCall = new UnresolvedCall(call.getCFG(), call.getLocation(), call.getAssigningStrategy(), call.getMatchingStrategy(), call.getTraversalStrategy(), Call.CallType.INSTANCE, call.getQualifier(), call.getTargetName(), call.getOrder(), params);
                this.resolveInstance(tempCall, types, targets, nativeTargets, aliasing);
                if (!(params[0] instanceof VariableRef)) {
                    LOG.debug(call + ": solving unknown-type calls as static-type requires the first parameter to be a reference to a variable, skipping");
                    break;
                }
                Expression[] truncatedParams = new Expression[params.length - 1];
                ExternalSet[] truncatedTypes = new ExternalSet[types.length - 1];
                System.arraycopy(params, 1, truncatedParams, 0, params.length - 1);
                System.arraycopy(types, 1, truncatedTypes, 0, types.length - 1);
                tempCall = new UnresolvedCall(call.getCFG(), call.getLocation(), call.getAssigningStrategy(), call.getMatchingStrategy(), call.getTraversalStrategy(), Call.CallType.STATIC, ((VariableRef)params[0]).getName(), call.getTargetName(), call.getOrder(), truncatedParams);
                this.resolveNonInstance(tempCall, truncatedTypes, targetsNoRec, nativeTargetsNoRec, aliasing);
            }
        }
        CFGCall cfgcall = new CFGCall(call, targets);
        NativeCall nativecall = new NativeCall(call, nativeTargets);
        TruncatedParamsCall cfgcallnorec = new CFGCall(call, targetsNoRec).removeFirstParameter();
        TruncatedParamsCall nativecallnorec = new NativeCall(call, nativeTargetsNoRec).removeFirstParameter();
        Call resolved = this.noTargets(targets, nativeTargets, targetsNoRec, nativeTargetsNoRec) ? new OpenCall(call) : (this.onlyNonRewritingCFGTargets(targets, nativeTargets, targetsNoRec, nativeTargetsNoRec) ? cfgcall : (this.onlyNonRewritingNativeTargets(targets, nativeTargets, targetsNoRec, nativeTargetsNoRec) ? nativecall : (this.onlyNonRewritingTargets(targets, nativeTargets, targetsNoRec, nativeTargetsNoRec) ? new MultiCall(call, cfgcall, nativecall) : (this.onlyRewritingCFGTargets(targets, nativeTargets, targetsNoRec, nativeTargetsNoRec) ? cfgcallnorec : (this.onlyRewritingNativeTargets(targets, nativeTargets, targetsNoRec, nativeTargetsNoRec) ? nativecallnorec : (this.onlyRewritingTargets(targets, nativeTargets, targetsNoRec, nativeTargetsNoRec) ? new MultiCall(call, cfgcallnorec, nativecallnorec) : (this.onlyCFGTargets(targets, nativeTargets, targetsNoRec, nativeTargetsNoRec) ? new MultiCall(call, cfgcall, cfgcallnorec) : (this.onlyNativeCFGTargets(targets, nativeTargets, targetsNoRec, nativeTargetsNoRec) ? new MultiCall(call, nativecall, nativecallnorec) : new MultiCall(call, cfgcall, cfgcallnorec, nativecall, nativecallnorec)))))))));
        resolved.setOffset(call.getOffset());
        resolved.setSource(call);
        this.resolvedCache.put(call, resolved);
        CallGraphNode source = new CallGraphNode(this, call.getCFG());
        if (!this.adjacencyMatrix.containsNode(source)) {
            this.addNode(source, this.program.getEntryPoints().contains(call.getCFG()));
        }
        for (CFG cFG : targets) {
            t = new CallGraphNode(this, cFG);
            if (!this.adjacencyMatrix.containsNode(t)) {
                this.addNode(t, this.program.getEntryPoints().contains(call.getCFG()));
            }
            this.addEdge(new CallGraphEdge(source, t));
            this.callsites.computeIfAbsent(cFG, cm -> new HashSet()).add(call);
        }
        for (NativeCFG nativeCFG : nativeTargets) {
            t = new CallGraphNode(this, nativeCFG);
            if (!this.adjacencyMatrix.containsNode(t)) {
                this.addNode(t, false);
            }
            this.addEdge(new CallGraphEdge(source, t));
            this.callsites.computeIfAbsent(nativeCFG, cm -> new HashSet()).add(call);
        }
        return resolved;
    }

    private boolean onlyNativeCFGTargets(Collection<CFG> targets, Collection<NativeCFG> nativeTargets, Collection<CFG> targetsNoRec, Collection<NativeCFG> nativeTargetsNoRec) {
        return targets.isEmpty() && !nativeTargets.isEmpty() && targetsNoRec.isEmpty() && !nativeTargetsNoRec.isEmpty();
    }

    private boolean onlyCFGTargets(Collection<CFG> targets, Collection<NativeCFG> nativeTargets, Collection<CFG> targetsNoRec, Collection<NativeCFG> nativeTargetsNoRec) {
        return !targets.isEmpty() && nativeTargets.isEmpty() && !targetsNoRec.isEmpty() && nativeTargetsNoRec.isEmpty();
    }

    private boolean onlyRewritingTargets(Collection<CFG> targets, Collection<NativeCFG> nativeTargets, Collection<CFG> targetsNoRec, Collection<NativeCFG> nativeTargetsNoRec) {
        return targets.isEmpty() && nativeTargets.isEmpty() && !targetsNoRec.isEmpty() && !nativeTargetsNoRec.isEmpty();
    }

    private boolean onlyRewritingNativeTargets(Collection<CFG> targets, Collection<NativeCFG> nativeTargets, Collection<CFG> targetsNoRec, Collection<NativeCFG> nativeTargetsNoRec) {
        return targets.isEmpty() && nativeTargets.isEmpty() && targetsNoRec.isEmpty() && !nativeTargetsNoRec.isEmpty();
    }

    private boolean onlyRewritingCFGTargets(Collection<CFG> targets, Collection<NativeCFG> nativeTargets, Collection<CFG> targetsNoRec, Collection<NativeCFG> nativeTargetsNoRec) {
        return targets.isEmpty() && nativeTargets.isEmpty() && !targetsNoRec.isEmpty() && nativeTargetsNoRec.isEmpty();
    }

    private boolean onlyNonRewritingTargets(Collection<CFG> targets, Collection<NativeCFG> nativeTargets, Collection<CFG> targetsNoRec, Collection<NativeCFG> nativeTargetsNoRec) {
        return !targets.isEmpty() && !nativeTargets.isEmpty() && targetsNoRec.isEmpty() && nativeTargetsNoRec.isEmpty();
    }

    private boolean onlyNonRewritingNativeTargets(Collection<CFG> targets, Collection<NativeCFG> nativeTargets, Collection<CFG> targetsNoRec, Collection<NativeCFG> nativeTargetsNoRec) {
        return targets.isEmpty() && !nativeTargets.isEmpty() && targetsNoRec.isEmpty() && nativeTargetsNoRec.isEmpty();
    }

    private boolean onlyNonRewritingCFGTargets(Collection<CFG> targets, Collection<NativeCFG> nativeTargets, Collection<CFG> targetsNoRec, Collection<NativeCFG> nativeTargetsNoRec) {
        return !targets.isEmpty() && nativeTargets.isEmpty() && targetsNoRec.isEmpty() && nativeTargetsNoRec.isEmpty();
    }

    private boolean noTargets(Collection<CFG> targets, Collection<NativeCFG> nativeTargets, Collection<CFG> targetsNoRec, Collection<NativeCFG> nativeTargetsNoRec) {
        return targets.isEmpty() && nativeTargets.isEmpty() && targetsNoRec.isEmpty() && nativeTargetsNoRec.isEmpty();
    }

    protected void resolveNonInstance(UnresolvedCall call, ExternalSet<Type>[] types, Collection<CFG> targets, Collection<NativeCFG> natives, SymbolAliasing aliasing) throws CallResolutionException {
        for (CodeMember cm : this.program.getAllCodeMembers()) {
            this.checkMember(call, types, targets, natives, aliasing, cm, false);
        }
    }

    protected void resolveInstance(UnresolvedCall call, ExternalSet<Type>[] types, Collection<CFG> targets, Collection<NativeCFG> natives, SymbolAliasing aliasing) throws CallResolutionException {
        if (call.getParameters().length == 0) {
            throw new CallResolutionException("An instance call should have at least one parameter to be used as the receiver of the call");
        }
        Expression receiver = call.getParameters()[0];
        for (Type recType : this.getPossibleTypesOfReceiver(receiver, types[0])) {
            Collection<CompilationUnit> units;
            if (recType.isUnitType()) {
                units = Collections.singleton(recType.asUnitType().getUnit());
            } else {
                if (!recType.isPointerType() || !recType.asPointerType().getInnerTypes().anyMatch(Type::isUnitType)) continue;
                units = recType.asPointerType().getInnerTypes().stream().filter(Type::isUnitType).map(Type::asUnitType).map(UnitType::getUnit).collect(Collectors.toSet());
            }
            HashSet<CompilationUnit> seen = new HashSet<CompilationUnit>();
            for (CompilationUnit unit : units) {
                for (CompilationUnit cu : call.getTraversalStrategy().traverse(call, unit)) {
                    if (!seen.add(unit)) continue;
                    for (CodeMember cm : cu.getInstanceCodeMembers(false)) {
                        this.checkMember(call, types, targets, natives, aliasing, cm, true);
                    }
                }
            }
        }
    }

    protected void checkMember(UnresolvedCall call, ExternalSet<Type>[] types, Collection<CFG> targets, Collection<NativeCFG> natives, SymbolAliasing aliasing, CodeMember cm, boolean instance) {
        CFGDescriptor descr = cm.getDescriptor();
        if (instance != descr.isInstance()) {
            return;
        }
        String qualifier = descr.getUnit().getName();
        String name = descr.getName();
        Aliases nAlias = (Aliases)aliasing.getState(new NameSymbol(name));
        Aliases qAlias = (Aliases)aliasing.getState(new QualifierSymbol(qualifier));
        Aliases qnAlias = (Aliases)aliasing.getState(new QualifiedNameSymbol(qualifier, name));
        boolean add = false;
        if (!qnAlias.isEmpty()) {
            for (QualifiedNameSymbol qualifiedNameSymbol : qnAlias.castElements(QualifiedNameSymbol.class)) {
                if (!this.matchCodeMemberName(call, qualifiedNameSymbol.getQualifier(), qualifiedNameSymbol.getName())) continue;
                add = true;
                break;
            }
        }
        if (!add && !qAlias.isEmpty()) {
            for (QualifierSymbol qualifierSymbol : qAlias.castElements(QualifierSymbol.class)) {
                if (!this.matchCodeMemberName(call, qualifierSymbol.getQualifier(), name)) continue;
                add = true;
                break;
            }
        }
        if (!add && !nAlias.isEmpty()) {
            for (NameSymbol nameSymbol : nAlias.castElements(NameSymbol.class)) {
                if (!this.matchCodeMemberName(call, qualifier, nameSymbol.getName())) continue;
                add = true;
                break;
            }
        }
        if (!add) {
            add = this.matchCodeMemberName(call, qualifier, name);
        }
        if (add && call.getMatchingStrategy().matches(call, descr.getFormals(), call.getParameters(), types)) {
            this.add(targets, natives, cm);
        }
    }

    private void add(Collection<CFG> targets, Collection<NativeCFG> natives, CodeMember cm) {
        if (cm instanceof CFG) {
            targets.add((CFG)cm);
        } else {
            natives.add((NativeCFG)cm);
        }
    }

    protected boolean matchCodeMemberName(UnresolvedCall call, String qualifier, String name) {
        if (!name.equals(call.getTargetName())) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)call.getQualifier())) {
            return true;
        }
        return qualifier.equals(call.getQualifier());
    }

    protected abstract Collection<Type> getPossibleTypesOfReceiver(Expression var1, ExternalSet<Type> var2) throws CallResolutionException;

    @Override
    public Collection<CodeMember> getCallees(CodeMember cm) {
        return this.followersOf(new CallGraphNode(this, cm)).stream().map(CallGraphNode::getCodeMember).collect(Collectors.toList());
    }

    @Override
    public Collection<CodeMember> getCallers(CodeMember cm) {
        return this.predecessorsOf(new CallGraphNode(this, cm)).stream().map(CallGraphNode::getCodeMember).collect(Collectors.toList());
    }

    @Override
    public Collection<Call> getCallSites(CodeMember cm) {
        return this.callsites.getOrDefault(cm, Collections.emptyList());
    }

    @Override
    protected DotGraph<CallGraphNode, CallGraphEdge, BaseCallGraph> toDot(Function<CallGraphNode, String> labelGenerator) {
        throw new UnsupportedOperationException();
    }
}

