/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.interprocedural.callgraph;

import it.unive.lisa.interprocedural.callgraph.BaseCallGraph;
import it.unive.lisa.interprocedural.callgraph.CallGraphNode;
import it.unive.lisa.util.datastructures.graph.Edge;
import it.unive.lisa.util.datastructures.graph.GraphVisitor;

public class CallGraphEdge
implements Edge<CallGraphNode, CallGraphEdge, BaseCallGraph> {
    private final CallGraphNode source;
    private final CallGraphNode destination;

    public CallGraphEdge(CallGraphNode source, CallGraphNode destination) {
        this.source = source;
        this.destination = destination;
    }

    @Override
    public CallGraphNode getSource() {
        return this.source;
    }

    @Override
    public CallGraphNode getDestination() {
        return this.destination;
    }

    @Override
    public boolean canBeSimplified() {
        return false;
    }

    @Override
    public CallGraphEdge newInstance(CallGraphNode source, CallGraphNode destination) {
        return new CallGraphEdge(source, destination);
    }

    @Override
    public <V> boolean accept(GraphVisitor<BaseCallGraph, CallGraphNode, CallGraphEdge, V> visitor, V tool) {
        return visitor.visit(tool, this.source.getGraph(), this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.destination == null ? 0 : this.destination.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CallGraphEdge other = (CallGraphEdge)obj;
        if (this.destination == null ? other.destination != null : !this.destination.equals(other.destination)) {
            return false;
        }
        return !(this.source == null ? other.source != null : !this.source.equals(other.source));
    }

    public String toString() {
        return this.source + " --> " + this.destination;
    }
}

