/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.logging;

import it.unive.lisa.logging.TimeFormat;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public final class Counter {
    private boolean logging;
    private int count;
    private final int cap;
    private final int updateEvery;
    private final String message;
    private final String objects;
    private final Logger logger;
    private final Level level;
    private long startTime;

    public Counter(Logger logger, Level level, String message, String objects, int cap, double updateFactor) {
        this.level = level;
        this.logging = false;
        this.count = 0;
        this.cap = cap;
        this.updateEvery = updateFactor < 0.0 || cap < 1 ? 1 : Math.max((int)Math.floor((double)cap * updateFactor), 1);
        this.logger = logger;
        this.message = message;
        this.objects = objects;
    }

    public int getCurrentCount() {
        return this.count;
    }

    public void on() {
        if (this.logging) {
            throw new IllegalStateException("This counter is already logging");
        }
        this.logging = true;
        this.startTime = System.nanoTime();
        this.logger.log(this.level, "{} [start]", (Object)this.message);
    }

    public boolean isLogging() {
        return this.logging;
    }

    public synchronized void count() {
        ++this.count;
        if (this.logging) {
            this.step();
        }
    }

    public void off() {
        if (!this.logging) {
            return;
        }
        this.logging = false;
        this.logger.log(this.level, "{} [stop] [{} {} in {}]", (Object)this.message, (Object)this.count, (Object)this.objects, (Object)TimeFormat.UP_TO_SECONDS.format(System.nanoTime() - this.startTime));
    }

    private void step() {
        if (this.getCurrentCount() % this.updateEvery != 0) {
            return;
        }
        String msg = this.message + ": ";
        msg = this.cap > 0 ? msg + this.getCurrentCount() + "/" + this.cap : msg + "in progress (" + this.getCurrentCount() + ")";
        this.logger.log(this.level, msg);
    }
}

